﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework;

namespace JF_Particle
{

    /// <summary>
    /// ビルボードの元になる頂点とIndex情報
    /// </summary>
    public struct VertexElementIndex
    {
        public Vector3 Position;
        public Vector2 texcode;
        public float Index;

        public static readonly int SizeInBytes
            = System.Runtime.InteropServices.Marshal.SizeOf(
                typeof(VertexElementIndex)
            );

        public static readonly VertexElement[] VertexElements
            = new VertexElement[]{
            new VertexElement(
                0,
                0,
                VertexElementFormat.Vector3,
                VertexElementMethod.Default,
                VertexElementUsage.Position,
                0
            ),
            new VertexElement(
                0,
                sizeof(float)*3,
                VertexElementFormat.Vector2, 
                VertexElementMethod.Default, 
                VertexElementUsage.TextureCoordinate, 
                0
            ),
            new VertexElement(
                0, 
                sizeof(float)*3 + sizeof(float)*2, 
                VertexElementFormat.Single, 
                VertexElementMethod.Default, 
                VertexElementUsage.TextureCoordinate, 
                1
            )
        };
    }



    /// <summary>マテリアル種別 </summary>
    public enum MaterialType : byte
    {
        /// <summary>白</summary>
        notSet = 0,
        Red,
        Blue,
        Green,

        maxvalue,
    }

    /// <summary>
    /// 定義済みの色取得構造体
    /// </summary>
    public class clsMaterials
    {

        protected List<Material> materials;

        /// <summary>
        /// 定義済み色の取得
        /// </summary>
        /// <param name="indexID"></param>
        /// <returns></returns>
        public Vector4 getMaterial(int indexID)
        {
            return materials[indexID].diffuseColor;
        }

        /// <summary>
        /// コンストラクタ　色をここで作る
        /// </summary>
        public clsMaterials()
        {
            materials = new List<Material>();

            Material mt = new Material();

            // MaterialType の順に追加してゆく
            mt.diffuseColor = new Vector4(1, 1, 1, 1);
            materials.Add(mt);

            //Red
            mt.diffuseColor = new Vector4(1, 0.3f, 0, 1);
            materials.Add(mt);

            //Blue
            mt.diffuseColor = new Vector4(0.2f, 0.3f, 1, 1);
            materials.Add(mt);

            //Green
            mt.diffuseColor = new Vector4(0, 1, 0.3f, 1);
            materials.Add(mt);

        }

    }

    public struct Material
    {
        /// <summary>基本色。RGBを、0～1.0であらわす</summary>
        public Vector4 diffuseColor;
        public bool lightingEnabled;
        /// <summary>発光色。RGBを、0～1.0であらわす</summary>
        public Vector3 emissiveColor;
        //public float alpha;
    }

    /// <summary>ビルボードエフェクト指定</summary>
    public enum cEnBillbdEfeID : ushort
    {
        /// <summary>通常丸型爆発</summary>
        bom_1 = 0,
        /// <summary>上に広がる爆発 </summary>
        bom_2,
        /// <summary>赤⇒黒煙になる爆発 </summary>
        bom_A_new,

        /// <summary>Hit用汎用炸裂 </summary>
        splead_1,
        /// <summary>中央が開いた炸裂(衝撃波）</summary>
        spSonic_1,

        /// <summary>土煙用煙</summary>
        kemuri_1,
        /// <summary>土煙用煙2</summary>
        kemuri_2,
        /// <summary>大型炸裂</summary>
        splead_2,

        /// <summary>煙3</summary>
        kemuri_3,

        /// <summary>チャージエフェクト</summary>
        cargeEf,

        /// <summary>アニメーションする渦</summary>
        uzu_1,

        /// <summary>1枚の細い渦</summary>
        uzu_2,

        /// <summary>鋭い棒</summary>
        Bou_A,

        /// <summary>白煙</summary>
        kemuri_Add,


        /// <summary>単純な●パーティ来る</summary>
        Simple,

        /// <summary>撃破時エミッター </summary>
        emitter_destroy = 2000,
        /// <summary>撃破時エミッター </summary>
        emitter_destroy2,
        /// <summary>指定方向に１列に爆発を５個出す </summary>
        emitter_VectBlast5,
        /// <summary>特殊：LWのHIT時のエフェクトを出す </summary>
        emitter_LW,

        /// <summary>撃破後の黒煙</summary>
        emitter_kokuen,
    }

}
