/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.DateFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import jp.sourceforge.jindolf.Avatar;
import jp.sourceforge.jindolf.FaceIconSet;
import jp.sourceforge.jindolf.Jindolf;
import jp.sourceforge.jindolf.Period;
import jp.sourceforge.jindolf.Player;
import jp.sourceforge.jindolf.SysEvent;
import jp.sourceforge.jindolf.Talk;
import jp.sourceforge.jindolf.Topic;
import jp.sourceforge.jindolf.Village;
import jp.sourceforge.jindolf.WolfBBS;
import jp.sourceforge.jindolf.corelib.Destiny;
import jp.sourceforge.jindolf.corelib.GameRole;
import jp.sourceforge.jindolf.corelib.SysEventType;
import jp.sourceforge.jindolf.corelib.Team;
import jp.sourceforge.jindolf.corelib.VillageState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GameSummary {
    private static Comparator<Player> castingComparator = new CastingComparator();
    private final Map<Avatar, Player> playerMap = new HashMap<Avatar, Player>();
    private final List<Player> playerList = new LinkedList<Player>();
    private final Village village;
    private Team winner;
    private int ctScryVillage = 0;
    private int ctScryMadman = 0;
    private int ctScryWolf = 0;
    private int ctGuardVillage = 0;
    private int ctGuardMadman = 0;
    private int ctGuardWolf = 0;
    private int ctGuardVillageGJ = 0;
    private int ctGuardMadmanGJ = 0;
    private int ctGuardFakeGJ = 0;
    private long talk1stTime = -1L;
    private long talkLastTime = -1L;

    public static CharSequence getRoleBalanceSequence(List<Player> players) {
        LinkedList<GameRole> roleList = new LinkedList<GameRole>();
        for (Player player : players) {
            GameRole role = player.getRole();
            roleList.add(role);
        }
        Collections.sort(roleList, GameRole.getPowerBalanceComparator());
        StringBuilder result = new StringBuilder();
        for (GameRole role : roleList) {
            char ch = role.getShortName();
            result.append(ch);
        }
        return result;
    }

    public GameSummary(Village village) {
        if (village == null) {
            throw new NullPointerException();
        }
        VillageState state = village.getState();
        if (state != VillageState.EPILOGUE && state != VillageState.GAMEOVER) {
            throw new IllegalStateException();
        }
        this.village = village;
        for (Period period : village.getPeriodList()) {
            this.summarizePeriod(period);
        }
        this.summarizeJudge();
        this.summarizeGuard();
    }

    private void summarizePeriod(Period period) {
        for (Topic topic : period.getTopicList()) {
            if (topic instanceof SysEvent) {
                SysEvent sysEvent = (SysEvent)topic;
                this.summarizeSysEvent(period, sysEvent);
                continue;
            }
            if (!(topic instanceof Talk)) continue;
            Talk talk = (Talk)topic;
            this.summarizeTalk(talk);
        }
    }

    private void summarizeSysEvent(Period period, SysEvent sysEvent) {
        List<Avatar> avatarList = sysEvent.getAvatarList();
        List<GameRole> roleList = sysEvent.getRoleList();
        List<Integer> integerList = sysEvent.getIntegerList();
        List<CharSequence> textList = sysEvent.getCharSequenceList();
        SysEventType eventType = sysEvent.getSysEventType();
        switch (eventType) {
            case WINVILLAGE: {
                this.winner = Team.VILLAGE;
                break;
            }
            case WINWOLF: {
                this.winner = Team.WOLF;
                break;
            }
            case WINHAMSTER: {
                this.winner = Team.HAMSTER;
                break;
            }
            case PLAYERLIST: {
                int avatarNum = avatarList.size();
                for (int idx = 0; idx < avatarNum; ++idx) {
                    Avatar avatar = avatarList.get(idx);
                    GameRole role = roleList.get(idx);
                    CharSequence urlText = textList.get(idx * 2);
                    CharSequence idName = textList.get(idx * 2 + 1);
                    int liveOrDead = integerList.get(idx);
                    Player player = this.registPlayer(avatar);
                    player.setRole(role);
                    player.setUrlText(((Object)urlText).toString());
                    player.setIdName(((Object)idName).toString());
                    if (liveOrDead != 0) {
                        player.setObitDay(-1);
                        player.setDestiny(Destiny.ALIVE);
                    }
                    this.playerList.add(player);
                }
                break;
            }
            case SUDDENDEATH: {
                Avatar suddenDeathAvatar = avatarList.get(0);
                Player suddenDeathPlayer = this.registPlayer(suddenDeathAvatar);
                suddenDeathPlayer.setDestiny(Destiny.SUDDENDEATH);
                suddenDeathPlayer.setObitDay(period.getDay());
                break;
            }
            case COUNTING: {
                int avatarTotal = avatarList.size();
                if (avatarTotal % 2 == 0) break;
                Avatar executedAvatar = avatarList.get(avatarTotal - 1);
                Player executedPlayer = this.registPlayer(executedAvatar);
                executedPlayer.setDestiny(Destiny.EXECUTED);
                executedPlayer.setObitDay(period.getDay());
                break;
            }
            case MURDERED: {
                for (Avatar avatar : avatarList) {
                    Player player = this.registPlayer(avatar);
                    player.setDestiny(Destiny.EATEN);
                    player.setObitDay(period.getDay());
                }
                break;
            }
            case ONSTAGE: {
                Avatar onstageAvatar = avatarList.get(0);
                Player onstagePlayer = this.registPlayer(onstageAvatar);
                onstagePlayer.setEntryNo(integerList.get(0));
                break;
            }
        }
    }

    private void summarizeTalk(Talk talk) {
        long epoch = talk.getTimeFromID();
        if (this.talk1stTime < 0L) {
            this.talk1stTime = epoch;
        }
        if (this.talkLastTime < 0L) {
            this.talkLastTime = epoch;
        }
        if (epoch < this.talk1stTime) {
            this.talk1stTime = epoch;
        }
        if (epoch > this.talkLastTime) {
            this.talkLastTime = epoch;
        }
    }

    private void summarizeJudge() {
        for (Period period : this.village.getPeriodList()) {
            block5: for (Topic topic : period.getTopicList()) {
                SysEvent sysEvent;
                if (!(topic instanceof SysEvent) || (sysEvent = (SysEvent)topic).getSysEventType() != SysEventType.JUDGE) continue;
                List<Avatar> avatarList = sysEvent.getAvatarList();
                Avatar avatar = avatarList.get(1);
                Player seered = this.getPlayer(avatar);
                GameRole role = seered.getRole();
                switch (role) {
                    case WOLF: {
                        ++this.ctScryWolf;
                        continue block5;
                    }
                    case MADMAN: {
                        ++this.ctScryMadman;
                        continue block5;
                    }
                }
                ++this.ctScryVillage;
            }
        }
    }

    public CharSequence dumpSeerActivity() {
        StringBuilder result = new StringBuilder();
        if (this.ctScryVillage > 0) {
            result.append("\u6751\u9663\u55b6\u3092");
            result.append(this.ctScryVillage);
            result.append("\u56de");
        }
        if (this.ctScryMadman > 0) {
            if (result.length() > 0) {
                result.append('\u3001');
            }
            result.append("\u72c2\u4eba\u3092");
            result.append(this.ctScryMadman);
            result.append("\u56de");
        }
        if (this.ctScryWolf > 0) {
            if (result.length() > 0) {
                result.append('\u3001');
            }
            result.append("\u4eba\u72fc\u3092");
            result.append(this.ctScryWolf);
            result.append("\u56de");
        }
        if (result.length() <= 0) {
            result.append("\u8ab0\u3082\u5360\u308f\u306a\u304b\u3063\u305f\u3002");
        } else {
            result.append("\u5360\u3063\u305f\u3002");
        }
        CharSequence seq = WolfBBS.escapeWikiSyntax(result);
        return seq;
    }

    private void summarizeGuard() {
        for (Period period : this.village.getPeriodList()) {
            if (period.getDay() <= 2) continue;
            boolean hunterAlive = false;
            boolean hasAssault = false;
            int wolfNum = 0;
            Enum guardedRole = null;
            block8: for (Topic topic : period.getTopicList()) {
                List<Avatar> avatarList;
                if (topic instanceof Talk) {
                    Talk talk = (Talk)topic;
                    if (talk.getTalkCount() > 0) continue;
                    hasAssault = true;
                    continue;
                }
                if (!(topic instanceof SysEvent)) continue;
                SysEvent sysEvent = (SysEvent)topic;
                SysEventType type = sysEvent.getSysEventType();
                if (type == SysEventType.COUNTING) {
                    avatarList = sysEvent.getAvatarList();
                    int avatarNum = avatarList.size();
                    for (int index = 0; index <= avatarNum - 1; index += 2) {
                        Avatar avatar = avatarList.get(index);
                        Player player = this.getPlayer(avatar);
                        if (player.getRole() == GameRole.HUNTER) {
                            if (index >= avatarNum - 1) {
                                hunterAlive = false;
                                continue;
                            }
                            hunterAlive = true;
                            continue;
                        }
                        if (player.getRole() != GameRole.WOLF) continue;
                        if (index >= avatarNum - 1) {
                            --wolfNum;
                            continue;
                        }
                        ++wolfNum;
                    }
                    continue;
                }
                if (type == SysEventType.GUARD) {
                    avatarList = sysEvent.getAvatarList();
                    Avatar avatar = avatarList.get(1);
                    Player guarded = this.getPlayer(avatar);
                    guardedRole = guarded.getRole();
                    switch (1.$SwitchMap$jp$sourceforge$jindolf$corelib$GameRole[guardedRole.ordinal()]) {
                        case 1: {
                            ++this.ctGuardWolf;
                            break;
                        }
                        case 2: {
                            ++this.ctGuardMadman;
                            break;
                        }
                        default: {
                            ++this.ctGuardVillage;
                            break;
                        }
                    }
                    continue;
                }
                if (type != SysEventType.NOMURDER || !hunterAlive) continue;
                if (!hasAssault && wolfNum > 0) {
                    ++this.ctGuardFakeGJ;
                    continue;
                }
                if (!hasAssault || guardedRole == null) continue;
                switch (1.$SwitchMap$jp$sourceforge$jindolf$corelib$GameRole[guardedRole.ordinal()]) {
                    case 2: {
                        ++this.ctGuardMadmanGJ;
                        continue block8;
                    }
                }
                ++this.ctGuardVillageGJ;
            }
        }
    }

    public CharSequence dumpHunterActivity() {
        StringBuilder result = new StringBuilder();
        String atLeast = this.ctGuardFakeGJ > 0 ? "\u5c11\u306a\u304f\u3068\u3082" : "";
        if (this.ctGuardVillage > 0) {
            result.append(atLeast);
            result.append("\u6751\u9663\u55b6\u3092");
            result.append(this.ctGuardVillage);
            result.append("\u56de\u8b77\u885b\u3057");
            if (this.ctGuardVillageGJ > 0) {
                result.append("GJ\u3092");
                result.append(this.ctGuardVillageGJ);
                result.append("\u56de\u51fa\u3057\u305f\u3002");
            } else {
                result.append("\u305f\u3002");
            }
        }
        if (this.ctGuardMadman > 0) {
            result.append(atLeast);
            result.append("\u72c2\u4eba\u3092");
            result.append(this.ctGuardMadman);
            result.append("\u56de\u8b77\u885b\u3057");
            if (this.ctGuardMadmanGJ > 0) {
                result.append("GJ\u3092");
                result.append(this.ctGuardMadmanGJ);
                result.append("\u56de\u51fa\u3057\u305f\u3002");
            } else {
                result.append("\u305f\u3002");
            }
        }
        if (this.ctGuardWolf > 0) {
            result.append(atLeast);
            result.append("\u4eba\u72fc\u3092");
            result.append(this.ctGuardWolf);
            result.append("\u56de\u8b77\u885b\u3057\u305f\u3002");
        }
        if (this.ctGuardFakeGJ > 0) {
            result.append("\u8b77\u885b\u5148\u306f\u4e0d\u660e\u306a\u304c\u3089\u507d\u88c5GJ\u304c");
            result.append(this.ctGuardFakeGJ);
            result.append("\u56de\u3042\u3063\u305f\u3002");
        }
        if (result.length() <= 0) {
            result.append("\u8ab0\u3082\u8b77\u885b\u3057\u306a\u304b\u3063\u305f");
        }
        CharSequence seq = WolfBBS.escapeWikiSyntax(result);
        return seq;
    }

    public CharSequence dumpExecutionInfo() {
        StringBuilder result = new StringBuilder();
        int exeWolf = 0;
        int exeMad = 0;
        int exeVillage = 0;
        block4: for (Player player : this.playerList) {
            Destiny destiny = player.getDestiny();
            if (destiny != Destiny.EXECUTED) continue;
            GameRole role = player.getRole();
            switch (role) {
                case WOLF: {
                    ++exeWolf;
                    continue block4;
                }
                case MADMAN: {
                    ++exeMad;
                    continue block4;
                }
            }
            ++exeVillage;
        }
        if (exeVillage > 0) {
            result.append("\u25bc\u6751\u9663\u55b6\u00d7").append(exeVillage).append("\u56de");
        }
        if (exeMad > 0) {
            if (result.length() > 0) {
                result.append("\u3001");
            }
            result.append("\u25bc\u72c2\u00d7").append(exeMad).append("\u56de");
        }
        if (exeWolf > 0) {
            if (result.length() > 0) {
                result.append("\u3001");
            }
            result.append("\u25bc\u72fc\u00d7").append(exeWolf).append("\u56de");
        }
        if (result.length() <= 0) {
            result.append("\u306a\u3057");
        }
        CharSequence seq = WolfBBS.escapeWikiSyntax(result);
        return seq;
    }

    public CharSequence dumpAssaultInfo() {
        StringBuilder result = new StringBuilder();
        int eatMad = 0;
        int eatVillage = 0;
        block3: for (Player player : this.playerList) {
            if (player.getAvatar() == Avatar.AVATAR_GERD) {
                result.append("\u25b2\u30b2\u30eb\u30c8");
                continue;
            }
            Destiny destiny = player.getDestiny();
            if (destiny != Destiny.EATEN) continue;
            GameRole role = player.getRole();
            switch (role) {
                case MADMAN: {
                    ++eatMad;
                    continue block3;
                }
            }
            ++eatVillage;
        }
        if (eatVillage > 0) {
            if (result.length() > 0) {
                result.append("\u3001");
            }
            result.append("\u25b2\u6751\u9663\u55b6\u00d7").append(eatVillage).append("\u56de");
        }
        if (eatMad > 0) {
            if (result.length() > 0) {
                result.append("\u3001");
            }
            result.append("\u25b2\u72c2\u00d7").append(eatMad).append("\u56de");
        }
        if (result.length() <= 0) {
            result.append("\u8972\u6483\u306a\u3057");
        }
        CharSequence seq = WolfBBS.escapeWikiSyntax(result);
        return seq;
    }

    public CharSequence dumpVoteBox() {
        StringBuilder wikiText = new StringBuilder();
        for (Player player : this.getCastingPlayerList()) {
            Avatar avatar = player.getAvatar();
            if (avatar == Avatar.AVATAR_GERD) continue;
            GameRole role = player.getRole();
            String fullName = avatar.getFullName();
            String roleName = role.getRoleName();
            StringBuilder line = new StringBuilder();
            line.append("[").append((CharSequence)roleName).append("] ").append((CharSequence)fullName);
            if (wikiText.length() > 0) {
                wikiText.append(',');
            }
            wikiText.append(WolfBBS.escapeWikiSyntax(line));
            wikiText.append("[0]");
        }
        wikiText.insert(0, "#vote(").append(")\n");
        return wikiText;
    }

    public CharSequence dumpCastingBoard(FaceIconSet iconSet) {
        StringBuilder wikiText = new StringBuilder();
        String vName = this.village.getVillageFullName();
        String generator = Jindolf.TITLE + " Ver." + Jindolf.VERSION;
        String author = iconSet.getAuthor() + "\u6c0f" + " [ " + iconSet.getUrlText() + " ]";
        wikiText.append(WolfBBS.COMMENTLINE);
        wikiText.append("// \u2193\u30ad\u30e3\u30b9\u30c8\u8868\u958b\u59cb\n");
        wikiText.append("//        Village : " + vName + "\n");
        wikiText.append("//        Generator : " + generator + "\n");
        wikiText.append("//        \u30a2\u30a4\u30b3\u30f3\u4f5c\u8005 : " + author + '\n');
        wikiText.append("// \u203b\u30a2\u30a4\u30b3\u30f3\u753b\u50cf\u306e\u8457\u4f5c\u8ca1\u7523\u6a29\u4fdd\u6301\u8005\u304a\u3088\u3073\u753b\u50cf\u30b5\u30fc\u30d0\u904b\u55b6\u8005\u304b\u3089\n");
        wikiText.append("// \u65b0\u3057\u3044\u610f\u5411\u304c\u793a\u3055\u308c\u305f\u5834\u5408\u3001\u305d\u3061\u3089\u3092\u6700\u512a\u5148\u3067\u5c0a\u91cd\u3057\u3066\u304f\u3060\u3055\u3044\u3002\n");
        wikiText.append(WolfBBS.COMMENTLINE);
        wikiText.append("|\u914d\u5f79").append("|\u53c2\u52a0\u8005").append("|\u5f79\u8077").append("|\u904b\u547d").append("|\u305d\u306e\u6d3b\u8e8d").append("|h").append('\n');
        wikiText.append(WolfBBS.COMMENTLINE);
        for (Player player : this.getCastingPlayerList()) {
            CharSequence report;
            Avatar avatar = player.getAvatar();
            GameRole role = player.getRole();
            Destiny destiny = player.getDestiny();
            int obitDay = player.getObitDay();
            String name = player.getIdName();
            String urlText = player.getUrlText();
            if (urlText == null) {
                urlText = "";
            }
            urlText = urlText.replace("~", "%7e");
            urlText = urlText.replace(" ", "%20");
            try {
                URL url = new URL(urlText);
                URI uri = url.toURI();
                urlText = uri.toASCIIString();
            }
            catch (MalformedURLException e) {
            }
            catch (URISyntaxException e) {
                // empty catch block
            }
            wikiText.append("// ========== ");
            wikiText.append(name + " acts as [" + avatar.getName() + "]");
            wikiText.append(" ==========\n");
            String teamColor = "BGCOLOR(" + WolfBBS.getTeamWikiColor(role) + "):";
            String avatarIcon = iconSet.getAvatarIconWiki(avatar);
            wikiText.append('|').append(teamColor);
            wikiText.append(avatarIcon).append("&br;");
            wikiText.append("[[").append(avatar.getName()).append("]]");
            wikiText.append('|').append(teamColor);
            wikiText.append("[[").append(WolfBBS.escapeWikiBracket(name));
            if (urlText != null && urlText.length() > 0) {
                wikiText.append('>').append(urlText);
            }
            wikiText.append("]]");
            wikiText.append('|').append(teamColor);
            wikiText.append(WolfBBS.getRoleIconWiki(role));
            wikiText.append("&br;");
            wikiText.append("[[");
            wikiText.append(role.getRoleName());
            wikiText.append("]]");
            String destinyColor = WolfBBS.getDestinyColorWiki(destiny);
            wikiText.append('|');
            wikiText.append("BGCOLOR(").append(destinyColor).append("):");
            if (destiny == Destiny.ALIVE) {
                wikiText.append("\u6700\u5f8c\u307e\u3067&br;\u751f\u5b58");
            } else {
                wikiText.append(obitDay).append("\u65e5\u76ee").append("&br;");
                wikiText.append(destiny.getMessage());
            }
            wikiText.append('|');
            wikiText.append(avatar.getJobTitle()).append('\u3002');
            if (avatar == Avatar.AVATAR_GERD) {
                wikiText.append("\u5bdd\u3066\u3070\u304b\u308a\u3044\u305f\u3002");
            } else if (role == GameRole.HUNTER) {
                report = this.dumpHunterActivity();
                wikiText.append(report);
            } else if (role == GameRole.SEER) {
                report = this.dumpSeerActivity();
                wikiText.append(report);
            }
            wikiText.append("|\n");
        }
        wikiText.append("|>|>|>|>|");
        wikiText.append("RIGHT:");
        wikiText.append("\u9854\u30a2\u30a4\u30b3\u30f3\u63d0\u4f9b : [[");
        wikiText.append(WolfBBS.escapeWikiBracket(iconSet.getAuthor()));
        wikiText.append(">" + iconSet.getUrlText());
        wikiText.append("]]\u6c0f");
        wikiText.append("|\n");
        wikiText.append(WolfBBS.COMMENTLINE);
        wikiText.append("// \u2191\u30ad\u30e3\u30b9\u30c8\u8868\u3053\u3053\u307e\u3067\n");
        wikiText.append(WolfBBS.COMMENTLINE);
        return wikiText;
    }

    public CharSequence dumpVillageWiki() {
        StringBuilder wikiText = new StringBuilder();
        DateFormat dform = DateFormat.getDateTimeInstance(0, 0);
        String vName = this.village.getVillageFullName();
        String generator = Jindolf.TITLE + " Ver." + Jindolf.VERSION;
        wikiText.append(WolfBBS.COMMENTLINE);
        wikiText.append("// \u2193\u6751\u8a73\u7d30\u958b\u59cb\n");
        wikiText.append("//        Village : " + vName + "\n");
        wikiText.append("//        Generator : " + generator + "\n");
        wikiText.append("* \u6751\u306e\u8a73\u7d30\n");
        wikiText.append(WolfBBS.COMMENTLINE);
        wikiText.append("- \u52dd\u8005\n");
        Team winnerTeam = this.getWinnerTeam();
        String wonTeam = winnerTeam.getTeamName();
        wikiText.append(wonTeam).append('\n');
        wikiText.append(WolfBBS.COMMENTLINE);
        wikiText.append("- \u30a8\u30f3\u30c8\u30ea\u30fc\u958b\u59cb\u6642\u523b\n");
        Date date = this.get1stTalkDate();
        String talk1st = dform.format(date);
        wikiText.append(talk1st).append('\n');
        wikiText.append(WolfBBS.COMMENTLINE);
        wikiText.append("- \u53c2\u52a0\u4eba\u6570\n");
        int avatarNum = this.countAvatarNum();
        String totalMember = "\u30b2\u30eb\u30c8 + " + (avatarNum - 1) + "\u540d = " + avatarNum + "\u540d";
        wikiText.append(WolfBBS.escapeWikiSyntax(totalMember)).append('\n');
        wikiText.append(WolfBBS.COMMENTLINE);
        wikiText.append("- \u5f79\u8077\u5185\u8a33\n");
        StringBuilder roleMsg = new StringBuilder();
        for (GameRole role : GameRole.values()) {
            List<Player> players = this.getRoledPlayerList(role);
            String roleName = role.getRoleName();
            if (players.size() <= 0) continue;
            if (roleMsg.length() > 0) {
                roleMsg.append('\u3001');
            }
            roleMsg.append(roleName).append(" \u00d7 ").append(players.size()).append("\u540d");
        }
        wikiText.append(WolfBBS.escapeWikiSyntax(roleMsg)).append('\n');
        wikiText.append(WolfBBS.COMMENTLINE);
        wikiText.append("- \u51e6\u5211\u5185\u8a33\n");
        wikiText.append(this.dumpExecutionInfo()).append('\n');
        wikiText.append(WolfBBS.COMMENTLINE);
        wikiText.append("- \u8972\u6483\u5185\u8a33\n");
        wikiText.append(this.dumpAssaultInfo()).append('\n');
        wikiText.append(WolfBBS.COMMENTLINE);
        wikiText.append("- \u7a81\u7136\u6b7b\n");
        wikiText.append(this.countSuddenDeath()).append("\u540d").append('\n');
        wikiText.append(WolfBBS.COMMENTLINE);
        wikiText.append("- \u4eba\u53e3\u63a8\u79fb\n");
        for (int day = 1; day < this.village.getPeriodSize(); ++day) {
            List<Player> players = this.getSurvivorList(day);
            CharSequence roleSeq = GameSummary.getRoleBalanceSequence(players);
            Period period = this.village.getPeriod(day);
            String daySeq = period.getCaption();
            wikiText.append('|').append(daySeq).append('|').append(roleSeq).append("|\n");
        }
        wikiText.append(WolfBBS.COMMENTLINE);
        wikiText.append("- \u5360\u3044\u5e2b\u306e\u6210\u7e3e\n");
        wikiText.append(this.dumpSeerActivity()).append('\n');
        wikiText.append(WolfBBS.COMMENTLINE);
        wikiText.append("- \u72e9\u4eba\u306e\u6210\u7e3e\n");
        wikiText.append(this.dumpHunterActivity()).append('\n');
        wikiText.append(WolfBBS.COMMENTLINE);
        wikiText.append("// \u2191\u6751\u8a73\u7d30\u3053\u3053\u307e\u3067\n");
        wikiText.append(WolfBBS.COMMENTLINE);
        return wikiText;
    }

    public Date get1stTalkDate() {
        return new Date(this.talk1stTime);
    }

    public Date getLastTalkDate() {
        return new Date(this.talkLastTime);
    }

    public List<Player> getSurvivorList(int day) {
        if (day < 0 || this.village.getPeriodSize() <= day) {
            throw new IndexOutOfBoundsException();
        }
        LinkedList<Player> result = new LinkedList<Player>();
        Period period = this.village.getPeriod(day);
        if (period.isPrologue() || period.isProgress() && day == 1) {
            result.addAll(this.playerList);
            return result;
        }
        if (period.isEpilogue()) {
            for (Player player : this.playerList) {
                if (player.getDestiny() != Destiny.ALIVE) continue;
                result.add(player);
            }
            return result;
        }
        for (Topic topic : period.getTopicList()) {
            SysEvent sysEvent;
            if (!(topic instanceof SysEvent) || (sysEvent = (SysEvent)topic).getSysEventType() != SysEventType.SURVIVOR) continue;
            List<Avatar> avatarList = sysEvent.getAvatarList();
            for (Avatar avatar : avatarList) {
                Player player = this.getPlayer(avatar);
                result.add(player);
            }
        }
        return result;
    }

    public List<Player> getPlayerList() {
        List<Player> result = Collections.unmodifiableList(this.playerList);
        return result;
    }

    public List<Player> getCastingPlayerList() {
        LinkedList<Player> sortedPlayers = new LinkedList<Player>();
        sortedPlayers.addAll(this.playerList);
        Collections.sort(sortedPlayers, castingComparator);
        return sortedPlayers;
    }

    public List<Player> getRoledPlayerList(GameRole role) {
        LinkedList<Player> result = new LinkedList<Player>();
        for (Player player : this.playerList) {
            if (player.getRole() != role) continue;
            result.add(player);
        }
        return result;
    }

    public Team getWinnerTeam() {
        return this.winner;
    }

    public int countSuddenDeath() {
        int suddenDeath = 0;
        for (Player player : this.playerList) {
            if (player.getDestiny() != Destiny.SUDDENDEATH) continue;
            ++suddenDeath;
        }
        return suddenDeath;
    }

    public int countAvatarNum() {
        int playerNum = this.playerList.size();
        return playerNum;
    }

    public final Player getPlayer(Avatar avatar) {
        Player player = this.playerMap.get(avatar);
        return player;
    }

    private Player registPlayer(Avatar avatar) {
        Player player = this.getPlayer(avatar);
        if (player == null) {
            player = new Player();
            player.setAvatar(avatar);
            this.playerMap.put(avatar, player);
        }
        return player;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CastingComparator
    implements Comparator<Player> {
        @Override
        public int compare(Player p1, Player p2) {
            Avatar avatar2;
            if (p1 == p2) {
                return 0;
            }
            if (p2 == null) {
                return 1;
            }
            if (p1 == null) {
                return -1;
            }
            Avatar avatar1 = p1.getAvatar();
            int avatarOrder = avatar1.compareTo(avatar2 = p2.getAvatar());
            if (avatarOrder == 0) {
                return 0;
            }
            if (avatar1 == Avatar.AVATAR_GERD) {
                return -1;
            }
            if (avatar2 == Avatar.AVATAR_GERD) {
                return 1;
            }
            if (p1.getDestiny() != Destiny.ALIVE && p2.getDestiny() == Destiny.ALIVE) {
                return -1;
            }
            if (p1.getDestiny() == Destiny.ALIVE && p2.getDestiny() != Destiny.ALIVE) {
                return 1;
            }
            if (p1.getObitDay() > p2.getObitDay()) {
                return 1;
            }
            if (p1.getObitDay() < p2.getObitDay()) {
                return -1;
            }
            int destinyOrder = p1.getDestiny().compareTo(p2.getDestiny());
            if (destinyOrder != 0) {
                return destinyOrder;
            }
            int entryOrder = p1.getEntryNo() - p2.getEntryNo();
            return entryOrder;
        }
    }
}

