<?php
require_once('init.php');
Loader::LoadFile('info_functions');
InfoHTML::OutputRoleHeader('恋人陣営');
?>
<p>
<a href="#rule">基本ルール</a>
<a href="#cupid_do">投票の仕様</a>
</p>
<p>
<a href="#cupid_group">キューピッド系</a>
<a href="#angel_group">天使系</a>
</p>

<h2 id="rule">基本ルール</h2>
<p>
<a href="#rule_summary">概要</a>
<a href="#rule_win">勝利条件</a>
<a href="#rule_distinguish">判定</a>
</p>

<h3 id="rule_summary">概要</h3>
<ol>
<li>初日の夜に「<a href="sub_role.php#lovers">恋人</a>」を作り、生存を目指します。</li>
</ol>

<h3 id="rule_win">勝利条件</h3>
<ol>
<li>ゲーム終了時に恋人が二人以上生存している。</li>
<li><a href="wolf.php">人狼</a>を全滅させるか、生存カウントの村人の生存数を人狼の生存数以下にする。</li>
<li>勝利条件を満たした<a href="vampire.php">吸血鬼</a>が存在する場合は恋人陣営勝利となる。</li>
<li>生存者が全て恋人になった場合は恋人陣営勝利となる。</li>
<li>自身や自分の作った恋人の生死は不問。</li>
</ol>

<h3 id="rule_distinguish">判定</h3>
<table>
<tr>
  <th>生存カウント</th>
  <th>占い</th>
  <th>霊能</th>
  <th>精神鑑定</th>
  <th>性別鑑定</th>
</tr>
<tr>
  <td>村人</td>
  <td>村人</td>
  <td>村人</td>
  <td>正常</td>
  <td>性別</td>
</tr>
</table>

<h2 id="cupid_do">投票の仕様</h2>
<ol>
<li>初日の夜に「<a href="sub_role.php#lovers">恋人</a>」にする人を二人選ぶ (人数は例外あり)。</li>
<li>投票結果は即座に反映される。</li>
<li>自分以外を恋人の対象に選ぶことができる (<a href="../rule.php#system_vote">他人撃ち</a>) 人数の制限は管理者が設定する。</li>
</ol>


<h2 id="cupid_group">キューピッド系</h2>
<p>
<a href="#cupid">キューピッド</a>
<a href="#self_cupid">求愛者</a>
<a href="#moon_cupid">かぐや姫</a>
<a href="#altair_cupid">彦星</a>
<a href="#mind_cupid">女神</a>
<a href="#sweet_cupid">弁財天</a>
<a href="#letter_cupid">文車妖妃</a>
<a href="#minstrel_cupid">吟遊詩人</a>
<a href="#triangle_cupid">小悪魔</a>
<a href="#nephila_cupid">絡新婦</a>
</p>
<p>
<a href="#revive_cupid">邪仙</a>
<a href="#snow_cupid">寒戸婆</a>
</p>

<h3 id="cupid">キューピッド (占い結果：村人 / 霊能結果：村人) [Ver. 1.2.0～]</h3>
<h4>[恋人作成能力] 自分撃ち固定：無し</h4>
<pre>
恋人陣営の<a href="mania.php#basic_mania">基本種</a>。
</pre>
<h4>関連役職</h4>
<pre>
<a href="duelist.php#valkyrja_duelist">戦乙女</a>
</pre>

<h3 id="self_cupid">求愛者 (占い結果：村人 / 霊能結果：村人) [Ver. 1.4.0 α21～]</h3>
<h4>[恋人作成能力] 自分撃ち固定：有り / 付加：受信者 (相手限定)</h4>
<pre>
自分撃ち固定のキューピッド。
矢を撃った相手に自分を対象にした<a href="sub_role.php#mind_receiver">受信者</a>が付く。
</pre>
<h5>Ver. 1.4.0 α22～</h5>
<pre>
矢を撃った相手に自分を対象にした<a href="sub_role.php#mind_receiver">受信者</a>が付く。
</pre>
<h4>同一表示役職</h4>
<pre>
<a href="chiroptera.php#dummy_chiroptera">夢求愛者</a>
</pre>
<h4>関連役職</h4>
<pre>
<a href="duelist.php#duelist">決闘者</a>・<a href="ability.php#mind_receiver">受信能力者</a>
</pre>
<h4>[作成者からのコメント]</h4>
<pre>
他国に実在する役職です。
対象が制限される代わりに、相手にメッセージを (一方的に) 送ることができます。
思う存分自分の想いを語ってください。
</pre>

<h3 id="moon_cupid">かぐや姫 (占い結果：村人 / 霊能結果：村人) [Ver. 1.4.0 β11～]</h3>
<h4>[恋人作成能力] 自分撃ち固定：有り / 付加：難題 + 受信者 (自分限定)</h4>
<pre>
自分撃ち固定で、矢を撃った二人に<a href="sub_role.php#challenge_lovers">難題</a>を付加するキューピッド。
自分に矢を撃った相手を対象にした<a href="sub_role.php#mind_receiver">受信者</a>が付く。
</pre>
<h4>関連役職</h4>
<pre>
<a href="ability.php#mind_receiver">受信能力者</a>
</pre>
<h4>[作成者からのコメント]</h4>
<pre>
バーボンハウス鯖＠鉄村人狼の管理人さんへの誕生日プレゼントです。
かぐや姫の不老不死の秘薬の伝説を元に、序盤は無敵だけど後半は月に帰る
(死亡する) 可能性が高くなるカップルを再現してみました。
</pre>

<h3 id="altair_cupid">彦星 (占い結果：村人 / 霊能結果：村人) [Ver. 2.3.0 α2～]</h3>
<h4>[恋人作成能力] 自分撃ち固定：有り / 付加：共鳴者 + 織姫 (相手限定)</h4>
<pre>
自分撃ち固定で、矢を撃った二人に<a href="sub_role.php#mind_friend">共鳴者</a>を付加するキューピッド。
矢を撃った相手に<a href="sub_role.php#vega_lovers">織姫</a>が付く。
</pre>
<h5>織姫付加判定</h5>
<ol>
<li><a href="sub_role.php#vega_lovers">織姫</a>が付加されるのは一つの村で一人だけ。</li>
<li>彦星が複数居た場合は抽選が発生し、一人だけが選出される。</li>
<li><a href="sub_role.php#vega_lovers">織姫</a>の名前は 2 日目昼の死亡メッセージ欄に表示される。</li>
</ol>
<h4>関連役職</h4>
<pre>
<a href="ability.php#mind_friend">共鳴能力者</a>
</pre>
<h4>[作成者からのコメント]</h4>
<pre>
<a href="sub_role.php#vega_lovers">織姫</a>の実装用に作成された役職です。
<a href="sub_role.php#vega_lovers">織姫</a>は実質無敵なので、彦星の生存力が勝利の鍵となります。
</pre>

<h3 id="mind_cupid">女神 (占い結果：村人 / 霊能結果：村人) [Ver. 1.4.0 α23～]</h3>
<h4>[恋人作成能力] 自分撃ち固定：無し / 付加：共鳴者 + 受信者 (他人撃ち + 自分限定)</h4>
<pre>
矢を撃った二人を<a href="sub_role.php#mind_friend">共鳴者</a>にする上位キューピッド。
他人撃ちの場合は、さらに自分が二人を対象にした<a href="sub_role.php#mind_receiver">受信者</a>になる。
</pre>
<h4>関連役職</h4>
<pre>
<a href="ability.php#mind_friend">共鳴能力者</a>・<a href="ability.php#mind_receiver">受信能力者</a>
</pre>
<h4>[作成者からのコメント]</h4>
<pre>
会話能力を持った恋人を作る上位キューピッドです。
自分撃ちの場合は<a href="#self_cupid">求愛者</a>の相互撃ちと同様の状態になります。
また、他人撃ちでも<a href="sub_role.php#mind_receiver">受信者</a>になるので、矢を撃った対象の発言が
必ず見えることになります。
</pre>

<h3 id="sweet_cupid">弁財天 (占い結果：村人 / 霊能結果：村人) [Ver. 1.4.0 β22～]</h3>
<h4>[恋人作成能力] 自分撃ち固定：無し / 付加：共鳴者</h4>
<pre>
矢を撃った二人を<a href="sub_role.php#mind_friend">共鳴者</a>にする上位キューピッド。
処刑投票先に<a href="sub_role.php#sweet_ringing">恋耳鳴</a>を付加する。
</pre>
<h5>恋耳鳴付加判定</h5>
<ol>
<li><a href="../spec.php#vote_day">判定</a>は処刑者決定後で、自分が毒やショック死で死亡した場合でも有効。</li>
<li>対象が死亡していた場合は無効 (例：処刑・毒死)。</li>
<li>自分が処刑された場合は無効。</li>
</ol>
<h4>関連役職</h4>
<pre>
<a href="human.php#philosophy_wizard">賢者</a>・<a href="ability.php#mind_friend">共鳴能力者</a>・<a href="ability.php#vote_action">処刑投票能力者</a>
</pre>
<h4>[作成者からのコメント]</h4>
<pre>
鉄村人狼のプレイヤーさんとの雑談から生まれた役職です。
テーマは「恋人の甘い会話を雰囲気だけおすそ分け」で、実利はあまりありません。
むしろ能力を発動すると不利になるので自分撃ちの場合は注意が必要です。
</pre>

<h3 id="letter_cupid">文車妖妃 (占い結果：村人 / 霊能結果：村人) [Ver. 3.0.0 α6～]</h3>
<h4>[恋人作成能力] 自分撃ち固定：無し / 付加：交換日記</h4>
<pre>
矢を撃った二人に<a href="sub_role.php#letter_exchange">交換日記</a>を付加する上位キューピッド。
</pre>
<h5>交換日記付加判定</h5>
<ol>
<li>判定が有効だった場合に両方に付加される。</li>
<li>どちらが送る側になるかは文車妖妃から付加される時点でランダムに決定される。</li>
<li>対象者が<a href="ability.php#last_words_limit">遺言制限能力者</a>であっても有効。</li>
<li>対象者のいずれかが複数のキューピッドから矢を打たれていた場合は無効。<br>
例4-1) X[文車妖妃] -> A-B / Y[キューピッド] -> B-C → 無効<br>
例4-2) X[文車妖妃] -> A-B / Y[キューピッド] -> A-B → 無効<br>
例4-3) X[文車妖妃] -> A-B / Y[キューピッド] -> C-D → 有効
</li>
<li>文車妖妃が複数出現してもカップルが重なっていなければ共に有効。<br>
例5-1) X[文車妖妃] -> A-B / Y[文車妖妃] -> C-D → X・Y 共に有効
</li>
</ol>
<h4>[作成者からのコメント]</h4>
<pre>
<a href="sub_role.php#letter_exchange">交換日記</a>の実装用に作成された役職です。
</pre>

<h3 id="minstrel_cupid">吟遊詩人 (占い結果：村人 / 霊能結果：村人) [Ver. 1.5.0 β1～]</h3>
<h4>[恋人作成能力] 自分撃ち固定：無し</h4>
<pre>
2日目夜以降、全ての<a href="sub_role.php#lovers">恋人</a>に一方的に声が届く上位キューピッド。
相手には誰の声が聞こえているのか分かるが、仲間表示などには何も出ない。
</pre>
<h4>関連役職</h4>
<pre>
<a href="mania.php#soul_mania">覚醒者</a>・<a href="ability.php#talk_mind">発言閲覧能力者</a>
</pre>
<h4>[作成者からのコメント]</h4>
<pre>
<a href="human.php#whisper_scanner">囁騒霊</a>のキューピッドバージョンで<a href="#mind_cupid">女神</a>の逆アプローチです。
暗号などを上手く使うことで恋人たちの司令塔になることができます。
</pre>

<h3 id="triangle_cupid">小悪魔 (占い結果：村人 / 霊能結果：村人) [Ver. 1.4.0 β8～]</h3>
<h4>[恋人作成能力] 自分撃ち固定：無し</h4>
<pre>
矢を三本撃てるキューピッド。
<a href="../rule.php#system_vote">他人撃ち</a>制限などは普通のキューピッドと同じ。
</pre>
<h4>関連役職</h4>
<pre>
<a href="duelist.php#triangle_duelist">舞首</a>
</pre>
<h4>[作成者からのコメント]</h4>
<pre>
翠星石鯖＠やる夫人狼で一時的に施されていた改造に別名を与えてみました。
</pre>

<h3 id="nephila_cupid">絡新婦 (占い結果：村人 / 霊能結果：村人) [Ver. 2.3.0 α3～]</h3>
<h4>[恋人作成能力] 自分撃ち固定：有り / 付加：愛人 + 受信者 (自分限定)</h4>
<pre>
自分を含めて矢を三本撃ち、<a href="sub_role.php#fake_lovers">愛人</a>を作る特殊なキューピッド。
</pre>
<ol>
<li>自分と矢を撃った二人のうちどちらか一人 (ランダム) と<a href="sub_role.php#lovers">恋人</a>同士になる。</li>
<li>自分以外の二人に<a href="sub_role.php#fake_lovers">愛人</a>を付加する。</li>
<li>自分が二人を対象にした<a href="sub_role.php#mind_receiver">受信者</a>になる。</li>
</ol>
<h4>関連役職</h4>
<pre>
<a href="ability.php#mind_receiver">受信能力者</a>
</pre>
<h4>[作成者からのコメント]</h4>
<pre>
他国の「悪女」をベースにカスタムしてみました。「じょろうぐも」と読みます。
</pre>

<h3 id="revive_cupid">邪仙 (占い結果：村人 / 霊能結果：村人) [Ver. 1.5.0 β13～]</h3>
<h4>[耐性] 人狼襲撃：死亡 + 蘇生 (1回限定) / 蘇生：不可 / 憑依：無効 / 封印：有効</h4>
<h4>[恋人作成能力] 自分撃ち固定：無し / 付加：死の宣告</h4>
<pre>
恋人に<a href="sub_role.php#death_warrant">死の宣告</a> (7日目昼) を付加する特殊なキューピッド。
人狼に襲撃されて死亡した場合、一度だけ即座に蘇生する (自己蘇生)。
自己蘇生能力の仕様は<a href="human.php#revive_pharmacist">仙人</a>と同じ。
</pre>
<h4>関連役職</h4>
<pre>
<a href="ability.php#doom">死の宣告能力者</a>・<a href="ability.php#revive">蘇生能力者</a>・<a href="ability.php#possessed_limit">憑依制限能力者</a>・<a href="ability.php#seal">封印対象者</a>
</pre>
<h4>[作成者からのコメント]</h4>
<pre>
<a href="human.php#revive_pharmacist">仙人</a>と<a href="duelist.php#doom_duelist">黒幕</a>を合わせたような能力で、東方 Project の霍 青娥がモチーフです。
</pre>

<h3 id="snow_cupid">寒戸婆 (占い結果：村人 / 霊能結果：村人) [Ver. 1.5.0 β8～]</h3>
<h4>[恋人作成能力] 自分撃ち固定：無し</h4>
<pre>
処刑投票先が恋人なら<a href="sub_role.php#frostbite">凍傷</a>を付加してしまうキューピッド。
</pre>
<h5>凍傷付加判定</h5>
<ol>
<li><a href="../spec.php#vote_day">判定</a>は処刑者決定後で、自分が毒やショック死で死亡した場合でも有効。</li>
<li>対象が死亡していた場合は無効 (例：処刑・毒死)。</li>
<li>自分が処刑された場合は無効。</li>
<li><a href="sub_role.php#vega_lovers">織姫</a>には無効。</li>
</ol>
<h4>関連役職</h4>
<pre>
<a href="mania.php#dummy_mania">夢語部</a>・<a href="ability.php#vote_action">処刑投票能力者</a>・<a href="ability.php#frostbite">凍傷能力者</a>
</pre>
<h4>[作成者からのコメント]</h4>
<pre>
寒戸の婆(さむとのばば)伝承がモチーフです。
恋人を死なせてしまう可能性がある劣化種としてデザインしました。
</pre>


<h2 id="angel_group">天使系</h2>
<p>
<a href="#angel">天使</a>
<a href="#rose_angel">薔薇天使</a>
<a href="#lily_angel">百合天使</a>
<a href="#exchange_angel">魂移使</a>
<a href="#ark_angel">大天使</a>
<a href="#sacrifice_angel">守護天使</a>
<a href="#scarlet_angel">紅天使</a>
<a href="#cursed_angel">堕天使</a>
</p>

<h3 id="angel">天使 (占い結果：村人 / 霊能結果：村人) [Ver. 1.4.0 β8～]</h3>
<h4>[恋人作成能力] 自分撃ち固定：無し / 付加：共感者 (男女限定)</h4>
<pre>
天使系の<a href="mania.php#basic_mania">基本種</a>。矢を撃った二人が男女だった場合に<a href="sub_role.php#mind_sympathy">共感者</a>を付加する。
</pre>
<h4>関連役職</h4>
<pre>
<a href="ability.php#sex">性別関連能力者</a>
</pre>
<h4>[作成者からのコメント]</h4>
<pre>
組み合わせ次第で特典が追加されるキューピッドの上位種です。
鉄板カップルが増えることを狙って作成してみました。
</pre>

<h3 id="rose_angel">薔薇天使 (占い結果：村人 / 霊能結果：村人) [Ver. 1.4.0 β8～]</h3>
<h4>[恋人作成能力] 自分撃ち固定：無し / 付加：共感者 (男性同士限定)</h4>
<pre>
矢を撃った二人が男性同士だった場合に<a href="sub_role.php#mind_sympathy">共感者</a>を付加する天使。
</pre>
<h4>関連役職</h4>
<pre>
<a href="ability.php#sex">性別関連能力者</a>
</pre>
<h4>[作成者からのコメント]</h4>
<pre>
<a href="#angel">天使</a>の男性版です。
<a href="#angel">天使</a>とは逆に予想外のカップリングが増えるかもしれませんね。
</pre>

<h3 id="lily_angel">百合天使 (占い結果：村人 / 霊能結果：村人) [Ver. 1.4.0 β8～]</h3>
<h4>[恋人作成能力] 自分撃ち固定：無し / 付加：共感者 (女性同士限定)</h4>
<pre>
矢を撃った二人が女性だった場合に<a href="sub_role.php#mind_sympathy">共感者</a>を付加する天使。
</pre>
<h4>関連役職</h4>
<pre>
<a href="ability.php#sex">性別関連能力者</a>
</pre>
<h4>[作成者からのコメント]</h4>
<pre>
<a href="#angel">天使</a>の女性版です。
<a href="human.php#sex_mage">ひよこ鑑定士</a>対策で性別を偽るケースがあることに気をつけましょう。
</pre>

<h3 id="exchange_angel">魂移使 (占い結果：村人 / 霊能結果：村人) [Ver. 1.4.0 β11～]</h3>
<h4>[恋人作成能力] 自分撃ち固定：無し / 付加：交換憑依</h4>
<pre>
矢を撃った二人を<a href="sub_role.php#possessed_exchange">交換憑依</a>させてしまう特殊な天使。
</pre>
<h5>交換憑依付加判定</h5>
<ol>
<li>矢が競合した場合は抽選が発生し、一組だけが入れ替わる。<br>
  例) A-B・B-C と矢を撃たれた → A-B または B-C のどちらかだけが入れ替わる。
</li>
<li><a href="ability.php#possessed_direct">憑依能力者 (直接型)</a> が対象だった場合は交換憑依は発生しない。</li>
<li>他人撃ちをした場合、矢を撃った本人には交換憑依が成立したかどうかは分からない。</li>
</ol>
<h4>関連役職</h4>
<pre>
<a href="ability.php#possessed">憑依能力者</a>
</pre>
<h4>[作成者からのコメント]</h4>
<pre>
ラブコメでよくある「中の人が入れ替わってしまう」展開を再現してみました。
これにぴったりくる実在する名前を思いつかなかったので造語を充てました。
「たまうつし」と読みます。
</pre>

<h3 id="ark_angel">大天使 (占い結果：村人 / 霊能結果：村人) [Ver. 1.4.0 β8～]</h3>
<h4>[恋人作成能力] 自分撃ち固定：無し</h4>
<pre>
他の人が作成した<a href="sub_role.php#mind_sympathy">共感者</a>の結果を見ることができる上位天使。
ただし、本人は<a href="sub_role.php#mind_sympathy">共感者</a>を作ることはできない。
</pre>
<h4>関連役職</h4>
<pre>
<a href="ability.php#soul">役職鑑定能力者</a>
</pre>
<h4>[作成者からのコメント]</h4>
<pre>
<a href="#angel">天使</a>の作成中の状態に別名を与えてみました。
組み合わせ次第で、二日目の朝に内訳をほぼ掌握することが可能になります。
<a href="human.php#widow_priest">未亡人</a>が作った<a href="sub_role.php#mind_sympathy">共感者</a>も見ることができます。
</pre>

<h3 id="sacrifice_angel">守護天使 (占い結果：村人 / 霊能結果：村人) [Ver. 1.4.0 β18～]</h3>
<h4>[耐性] 人狼襲撃：無効</h4>
<h4>[恋人作成能力] 自分撃ち固定：無し / 付加：共感者 + 庇護者</h4>
<pre>
矢を撃った相手に<a href="sub_role.php#mind_sympathy">共感者</a>と<a href="sub_role.php#protected">庇護者</a>を付加する上位天使。
人狼に襲撃されても死亡しない (襲撃は失敗扱い)。
襲撃者が<a href="wolf.php#sirius_wolf">天狼</a> (完全覚醒状態) だった場合は耐性無効。
自分撃ちをしても自分に<a href="sub_role.php#protected">庇護者</a>は付かない。
</pre>
<h4>関連役職</h4>
<pre>
<a href="mania.php#soul_mania">覚醒者</a>・<a href="ability.php#resist_wolf">人狼襲撃耐性能力者</a>・<a href="ability.php#sacrifice">身代わり能力者</a>
</pre>
<h4>[作成者からのコメント]</h4>
<pre>
<a href="vampire.php#sacrifice_vampire">吸血公</a>の能力を恋人陣営向けに転化してみました。
<a href="http://jbbs.livedoor.jp/bbs/read.cgi/netgame/2829/1246414115/467" target="_top">新役職考案スレ(467)</a> が原型です。
</pre>

<h3 id="scarlet_angel">紅天使 (占い結果：村人 / 霊能結果：村人) [Ver. 1.5.0 β1～]</h3>
<h4>[恋人作成能力] 自分撃ち固定：無し / 付加：共感者</h4>
<pre>
<a href="wolf.php#partner">人狼</a>から<a href="human.php#unconscious">無意識</a>に、<a href="fox.php#partner">妖狐陣営</a>から<a href="fox.php#child_fox_group">子狐</a>に、<a href="human.php#doll_rule">人形</a>から<a href="human.php#doll_rule_doll_master">人形遣い系</a>に見える特殊な天使。
夜に<a href="human.php#unconscious">無意識</a>が誰か分かる (人狼系の<a href="wolf.php#partner">仲間表示</a>参照)。
矢を撃った相手に<a href="sub_role.php#mind_sympathy">共感者</a>を付加する。
</pre>
<h4>関連役職</h4>
<pre>
<a href="ability.php#partner_scarlet">仲間情報妨害能力者</a>
</pre>
<h4>[作成者からのコメント]</h4>
<pre>
<a href="wolf.php#scarlet_wolf">紅狼</a>の天使バージョンです。
ある程度他の陣営の配置が分かるので恋人選定時に有利になります。
</pre>

<h3 id="cursed_angel">堕天使 (占い結果：村人(呪返し) / 霊能結果：村人) [Ver. 1.5.0 β8～]</h3>
<h4>[耐性] 狩り：有効 / 占い：呪返し / 陰陽師：死亡</h4>
<h4>[恋人作成能力] 自分撃ち固定：無し / 付加：共感者 (別陣営限定)</h4>
<pre>
呪いを持ち、矢を撃った二人が別陣営だった場合に<a href="sub_role.php#mind_sympathy">共感者</a>を付加する天使。
陣営の判定法則は<a href="human.php#medium_rule">巫女</a>と同じ。
<a href="sub_role.php#lovers">恋人</a>に処刑投票されるとショック死する。
</pre>
<h5>ショック死判定</h5>
<ol>
<li><a href="../spec.php#vote_day">判定</a>はショック死処理内部で行う。</li>
<li>ショック死した場合の死因は「封印された」。</li>
<li><a href="sub_role.php#vega_lovers">織姫</a>はショック死無効。</li>
</ol>
<h5>Ver. 1.5.0 β9～</h5>
<pre>
<a href="../spec.php#vote_day">判定</a>順をショック死処理の直前からショック死処理内部に変更
</pre>
<h4>関連役職</h4>
<pre>
<a href="mania.php#dummy_mania">夢語部</a>・<a href="ability.php#sudden_death">ショック死発動能力者</a>・<a href="ability.php#camp">陣営判定能力者</a>・<a href="ability.php#cursed_group">呪い能力者</a>
</pre>
<h4>[作成者からのコメント]</h4>
<pre>
天使系の劣化種として<a href="sub_role.php#celibacy">独身貴族</a>相当の能力を持たせてみました。
</pre>
</body>
</html>
