/* -----------------------------------------------------------------------
 MessageManager.java
 Copyright (C) 2003  Nue

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
----------------------------------------------------------------------- */
/*
 * Created on 2003/02/21
 *
 * File Name: MessageManager.java
 * Encoding : EUC-JP
 * LineDelimiter: LF
 * 
 */
package jp.co.jlight;

import org.eclipse.swt.*;
import org.eclipse.swt.widgets.*;
/**
 * ץꥱɽåܥå
 *       륯饹
 */
public class MessageManager {

	private Shell shell;

	/**
	 * MessageManager饹󥹥ȥ饯
	 * @param parent	Shell
	 */
	public MessageManager(Shell parent) {
		this.shell = parent;
	}

	/**
	 * 󥢥դåɽ
	 * @param msg
	 */
	public void displayInformation(String msg) {
		displayMessage(msg, SWT.ICON_INFORMATION);
	}

	/**
	 * 顼դåɽ
	 * @param msg
	 */
	public void displayError(String msg) {
		displayMessage(msg, SWT.ICON_ERROR);
	}

	/**
	 * YesNoܥ󡢼䥢դåɽ
	 * @param msg
	 * @return int	åܥå֤
	 */
	public int displayYesNoQuestion(String msg) {
		return displayMessage(msg, SWT.YES | SWT.NO | SWT.ICON_QUESTION);
	}

	/**
	 * YesNoCancelܥ󡢼䥢դåɽ
	 * @param msg
	 * @return int	åܥå֤
	 */
	public int displayYesNoCancel(String msg) {
		return displayMessage(msg, SWT.YES | SWT.NO | SWT.CANCEL | SWT.ICON_QUESTION);
	}

	/**
	 * åܥåɽ
	 * @param msg
	 * @param styles
	 * @return int	åܥå֤
	 */
	private int displayMessage(String msg, int styles) {
		int result = SWT.NONE;
		MessageBox mbox = new MessageBox(shell, styles);
		mbox.setMessage(msg);
		try {
			result = mbox.open();
		} catch (SWTException e) {
			System.err.println(e.getMessage());
		}
		return result;
	}

}
