/* -----------------------------------------------------------------------
 CommandStack.java
 Copyright (C) 2003  Nue

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
----------------------------------------------------------------------- */
/*
 * Created on 2003/11/01
 *
 * File Name: CommandStack.java
 * Encoding : EUC-JP
 * LineDelimiter: LF
 *
 */
package jp.co.jlight.undo;

import java.util.*;
/**
 * ޥɤ򤿤UndoRedo¹Ԥ
 */
public class CommandStack {
	
	private ArrayList history = new ArrayList();
	private int current = -1;
	private int index = -1;
	
	private TextUnit lastTextUnit = new TextUnit();
	
	public void append(CommandUnit cmdUnit) {
		TextUnit textUnit = cmdUnit.getTextUnit();
		CommandMacro cmdMacro;
		if (checkNewSegment(textUnit)) {
			cmdMacro = new CommandMacro();
			append(cmdMacro);
		}
		try {
			getLastCommandMacro().append(cmdUnit);
		} catch (NonLastCommandException e) {
		}
	}
	
	private void append(CommandMacro macro) {
		ArrayList al = null;
		CommandMacro cmdMacro = null;

		// listΥȰ֤ǸǤʤä(undo,redoǥȤѤä)ν
		if (current != index) {
			// åΰ־夫current֤ޤ
			// CommandMacroReverseɲ
			al = new ArrayList();
			for (int i = index; i > current; i--) {
				cmdMacro = (CommandMacro)history.get(i);
				al.add(cmdMacro.getCommandMacroReverse());
			}
			history.addAll(al);
			index = index + (index - current);
		}

		history.add(++index, macro);
		current = index;
	}
	
	private boolean checkNewSegment(TextUnit textUnit) {
		boolean seg = true;
		char chNow;
		char chOld;

		if (textUnit.getAddString().length() > 1) {

		} else if (textUnit.getAddString().length() == 1) {
			if (textUnit.getAddPoint().x != (lastTextUnit.getAddPoint().x + 1)) {
			
			} else if (lastTextUnit.getAddString().length() == 1) {
				chNow = textUnit.getAddString().charAt(0);
				chOld = lastTextUnit.getAddString().charAt(0);

				if (chNow == '\t' && chOld == '\t') {
					seg = false;
				} else if (chNow == '\n' && chOld == '\n') {
					seg = false;
				} else if (chNow == ' ' && chOld == ' ') {
					seg = false;
				} else if ((chOld != '\t' && chOld != '\n' && chOld != ' ')
						&& (chNow == '\t' || chNow == '\n' || chNow == ' ')) {
					seg = true;
				} else if (chOld != '\t' && chOld != '\n' && chOld != ' ') {
					seg = false;
				} else {
				}
			}
//		} else if (textUnit.getDelString().length() == 1 
//				&& lastTextUnit.getDelString().length() == 1) {
//			if (textUnit.getDelPoint().x == lastTextUnit.getDelPoint().x
//				|| textUnit.getDelPoint().x == (lastTextUnit.getDelPoint().x - 1)) {
//				seg = false;
//			}
		}
		lastTextUnit = new TextUnit(textUnit.getDelPoint(), textUnit.getDelString(),
									textUnit.getAddPoint(), textUnit.getAddString());
		return seg;
	}
	
	public void claer() {
		history.clear();
		current = -1;
		index = -1;
	}
	
	public int getSize() {
		return history.size();
	}
	
	public void undo() {
		if (current < 0) return;
		((CommandMacro)history.get(current--)).undo();
	}
	
	public void redo() {
		if (current > (getSize() - 2)) return;
		((CommandMacro)history.get(++current)).redo();
	}
	
	private CommandMacro getLastCommandMacro() throws NonLastCommandException{
		if (index < 0) throw new NonLastCommandException();
		return (CommandMacro)history.get(index);
	}
	
	class NonLastCommandException extends Exception {
	}
}
