/**
 * brownie-lang.js
 * 
 * uses
 *  brownie-lang.js
 * ;
 * 
 * @author T.Akima
 * @copyright T.Akima
 * @license LGNU
 */


var logger = new LogWindow("NaviMenu", true);

/***********************************************************
 * j[ڂ킷NX
 * diṽbp[ƌĂOK
 ***********************************************************/
function MenuItem(proto, itemId){

	var X=0, Y=1, Z=2;

	this._proto = proto;
	
	this._items = [];
	
	this._div = null;
	
	this.render = function( maxLevel ){
		if (this.getLevel() > maxLevel)
			return;
		if (!(this._div)){
			this.renderImpl();
		}
		for(var i = 0; i < this._items.length; i++){
			this._items[i].render( maxLevel );
		}
	}
	
	this.renderImpl = function(){
		var urlInStr = "'" + this._proto.url + "'";
		var itemInStr = "'" + itemId + "'";
		var htmLet = '<div id="'+ itemId +'"'
			+' ' 
			+this.getStyleToRender()
			+this._proto.otherDIV
			+' onclick="menuItemClick('+ itemInStr +', event)"'
			+' onmouseover="menuItemOver('+ itemInStr +', event)"'
			+' onmouseout="menuItemOut('+ itemInStr +', event)"'
			+'>'
			+'&nbsp;&nbsp;'
			+this._proto.caption
			+'</div>'
			;
		document.write( htmLet );
		
		this._div = xBrowser.getDiv(itemId);
	}
	
	this.getStyleToRender = function(){
		return 'style="'
			+ this.getStylePosition()
			+ 'z-index:' + this.getZOrder() +';'
			+ ((this.getWidth() != null) ? 'width:'		+ this.getWidth()		+'px;' : '')
			+ ((this.getHeight() != null) ? 'height:'	+	this.getHeight()	+'px;' : '')
			+ ((this.getBorder() != null) ? 'border: ' + this.getBorder()  + ';' : '')
			+ ((this.getLevel() > 1) ? 'visibility:hidden;' : "")
			+ 'background-color:'+this.getNormalBgColor()+';'
			+ this._proto.otherCSS
			+ ';" '
	}
	
	this.getStylePosition = function(){
		if (this.isPositionAbsolute()){
			return 'position:absolute;'
				+'left:' + this.getLeft() +'px;'
				+'top:' + this.getTop() +'px;' ;
		} else {
			return 'position:relative;' ;
		}
	}
	
	this.toString = function(){
		return "getIndex=" + this.getIndex() + ", "+
			"getLevel=" + this.getLevel() + ", "+
			"getLeft=" + this.getLeft() + ", " +
			"getTop=" + this.getTop() + ", " +
			"getWidth=" + this.getWidth() + ", " +
			"getHeight=" + this.getHeight();
	}
	
	this.getLeft = function(){
		var padding = this.getPadding();
		var prevItem = this.getPrevItem();
		return (this._div) ? xBrowser.getDivLeft(this._div) : 
			(this._proto.left) ? this._proto.left : 
			(this.getLevel() == 1) ? 
				((prevItem) ? 
					prevItem.getLeft() + prevItem.getWidth() + padding[X] : 
					this.getParent().getLeft() ) :
				(this.getLevel() == 2) ? 
					this.getParent().getLeft() :
					this.getParent().getLeft() + this.getParent().getWidth() + padding[X];
	}
	
	this.getTop = function(){
		var padding = this.getPadding();
		var prevItem = this.getPrevItem();
		return (this._div) ? xBrowser.getDivTop(this._div) :
			(this._proto.top) ? this._proto.top : 
			(this.getLevel() == 1) ? 
				this.getParent().getTop() :
				(this.getLevel() == 2) ? 
					((prevItem) ?
						prevItem.getTop() + prevItem.getHeight()  + padding[Y] -1 :
						this.getParent().getTop() + this.getParent().getHeight()) + padding[Y] :
					((prevItem) ?
						prevItem.getTop() + prevItem.getHeight()  + padding[Y] :
						this.getParent().getTop());
	}
	
	this.isPositionAbsolute = function(){
		return (this.getLevel() > 1) ? true : this.getParent().isPositionAbsolute();
	}
	
	this.getBorderWidth = function(){
		return (this._div) ? xBrowser.getDivWidth(this._div) :
			(this._proto.width) ? this._proto.width : this.getParent().getWidth();
	}
	
	this.getWidth = function(){
		return (this._div) ? xBrowser.getDivWidth(this._div) :
			(this._proto.width) ? this._proto.width : this.getParent().getWidth();
	}
	
	this.getHeight = function(){
		return (this._div) ? xBrowser.getDivHeight(this._div) :
			(this._proto.height) ? this._proto.height : this.getParent().getHeight();
	}
	
	this.getNormalBgColor = function(){
		return ((this._proto.styleNormal) && (this._proto.styleNormal.backgroundColor)) ? this._proto.styleNormal.backgroundColor : this.getParent().getNormalBgColor();
	}
	
	this.getFocusedBgColor = function(){
		return ((this._proto.styleFocused) && (this._proto.styleFocused.backgroundColor)) ? this._proto.styleFocused.backgroundColor : this.getParent().getFocusedBgColor();
	}
	
	this.getBorder = function(){
		return ((this._proto.style) && (this._proto.style.border)) ? this._proto.style.border : this.getParent().getBorder();
	}
	
	this.getZOrder = function(){
		return (this._proto.zOrder) ? this._proto.zOrder : this.getParent().getZOrder() + 1;
	}
	
	this.getUrl = function(){
		return isAvail(this._proto.url) ? this._proto.url : null;
	}
	
	this.getPadding = function(){
		return (this._proto.padding) ? this._proto.padding : this.getParent().getPadding();
	}



	
	this.getLevel = function(){
		return this.getParent().getLevel() + 1;
	}

	this.hasUrl = function(){
		return isAvail(this._proto.url);
	}
	
	this.isSeparator = function(){
		return ((! this.hasUrl()) && this.isEmpty());
	}


	this.add = function(menuItem){
		this._items[this._items.length] = menuItem;
		menuItem.setParent(this);
	}
	
	this.getIndex = function(){
		return this.getParent().indexOf(this);
	}
	
	this.getItem = function( index ){
		return this._items[index];
	}
	
	this.indexOf = function( item ){
		for(var i = 0; i < this._items.length; i++){
			if (this.getItem(i) == item)
				return i;
		}
		return -1;
	}
	
	this.isEmpty = function(){
		return (this._items.length == 0);
	}
	
	this.isActive = function(){
		return this.getRootNavi().isActive(this);
	}
	
	this.activate = function(){
		this.getRootNavi().activate(this);
	}	
	
	this.deactivate = function(){
		this.getRootNavi().deactivate(this);
	}	
	
	this.activateStyle = function(){
		this._div.style.backgroundColor = this.getFocusedBgColor();
	}	
	
	this.deactivateStyle = function(){
		this._div.style.backgroundColor = this.getNormalBgColor();
	}
	
	this.showItems = function(){
		this.showItemsVisibility( true );
		if (this.getLevel() > 0)
			this.getParent().showItems();
	}
	
	this.hideItems = function(){
		this.showItemsVisibility( false );
		for(var i = 0; i < this._items.length; i++){
			this._items[i].hideItems();
		}
	}
	
	this.showItemsVisibility = function( visible ){
		if (this.isEmpty())
			return;
		for(var i = 0; i < this._items.length; i++){
			var item = this._items[i];
			if (item._div){
				xBrowser.setDivVisibility(item._div, visible );
			}
		}
	}
	
	this.isVisible = function(){
		return (this._div) ? xBrowser.getDivVisibility(this._div) : false;
	}
	
	this.include = function(posX, posY){
		logger.debug("@include    [level/index] visible=    [" + this.getLevel() + "/" + this.getIndex() +  "]     "+ this.isVisible());
		if (! this.isVisible())
			return false;
		if (this._div){
			var divX = xBrowser.getDivLeft(this._div);
			var divY = xBrowser.getDivTop(this._div);
			var divW = xBrowser.getDivWidth(this._div);
			var divH = xBrowser.getDivHeight(this._div);
			logger.debug("@include    [level/index]  x,y,w,h=    [" + this.getLevel() + "/" + this.getIndex() +  "]     "+ divX + ","+ divY+","+ divW + ","+ divH);
		}
		if ( (this._div) ) {
			var left = xBrowser.getDivLeft(this._div);
			var top = xBrowser.getDivTop(this._div);
			var width = xBrowser.getDivWidth(this._div);
			var height = xBrowser.getDivHeight(this._div);
			if ((left <= posX) && (posX <= left + width) && (top <= posY) && (posY <= top + height))
				return true;
		}
		for(var i = 0; i < this._items.length; i++){
			var menuItem = this._items[i];
			if (menuItem.include(posX, posY))
				return true;
		}
		return false;
	}
	
	this.getRootNavi = function(){
		return this.getParent().getRootNavi();
	}
	
	this._parent = null;
	
	this.getParent = function(){
		return this._parent;
	}
	
	this.setParent = function( parent ){
		this._parent = parent;
	}
	
	this.getPrevItem = function(){
		var index = this.getParent().indexOf(this);
		return (index > 0) ? this.getParent().getItem(index -1) : null;
	}
	

}



//MenuItem̊Ǘdivid𐶐邽߂̕ϐ
var itemNo = 1;

//divMenuNaviIuWFNgێList
var menuNaviList = new ArrayList();
//divMenuItemIuWFNg̊֘Aێ}bv
var divIdToMenuItem = new Map();

/***********************************************************
 * j[킷NXB
 * [U͂̃NXgȂB
 ***********************************************************/
function MenuNavi(proto){
	this._proto = proto;
	
	this._items = [];
	
	this._div = null;
	
	this.build = function(){
		if (!isUndefined(this._proto.items)){
			for(var i = 0; i < this._proto.items.length; i++){
				var item = this._proto.items[i];
				var menuItem = this.buildItem(item);
				menuItem.setParent( this );
				this._items[this._items.length] = menuItem;
			}
		}
	}
	
	this.buildItem = function(item){
		var menuItemDivId = "mi" + itemNo++;
		var menuItem = new MenuItem( item, menuItemDivId);
		divIdToMenuItem.put(menuItemDivId, menuItem);
		if (item.sub){
			for(var i = 0; i < item.sub.length; i++){
				var subItem = item.sub[i];
				var subMenu = this.buildItem(subItem);
				menuItem.add(subMenu);
			}
		}
		return menuItem;
	}
	
	this.render = function(){
		if (this.isPositionAbsolute()){
			for(var i = 0; i < this._items.length; i++){
				this._items[i].render(1);
			}
		} else {
			var menuDivId = "mi" + itemNo++;
			document.write('<div id="'+ menuDivId +'" style="background-color: ' + this.getNormalBgColor() + '; border: 1px solid rgb(0, 0, 0)">');
			document.write('<table border="0" cellpadding="0" cellspacing="0">');
			document.write('<tr>');
			for(var i = 0; i < this._items.length; i++){
				document.write('<td>');
				this._items[i].render(1);
				document.write('</td>');
			}
			document.write('</tr>');
			document.write('</table>');
			document.write('</div>');
			this._div = xBrowser.getDiv( menuDivId );
			
			menuNaviList.add(this);
		}
		for(var i = 0; i < this._items.length; i++){
			this._items[i].render(999);
		}
	}
	
	this.getRootNavi = function(){
		return this;
	}
	
	this.getLevel = function(){
		return 0;
	}
	
	this.isPositionAbsolute = function(){
		return (this._proto.positionAbsolute) ? this._proto.positionAbsolute : false;
	}
	
	this.getZOrder = function(){
		return (this._proto.zOrder) ? this._proto.zOrder : 1;
	}
	
	this.getLeft = function(){
		return (this._proto.left) ? this._proto.left : 0;
	}
	
	this.getTop = function(){
		return (this._proto.top) ? this._proto.top : 0;
	}
	
	this.getWidth = function(){
		return (this._proto.width) ? this._proto.width : null;
	}
	
	this.getHeight = function(){
		return (this._proto.height) ? this._proto.height : null;
	}
	
	this.getNormalBgColor = function(){
		return ((this._proto.styleNormal) && (this._proto.styleNormal.backgroundColor)) ? this._proto.styleNormal.backgroundColor : "#F9E4A8";
	}
	
	this.getFocusedBgColor = function(){
		return ((this._proto.styleFocused) && (this._proto.styleFocused.backgroundColor)) ? this._proto.styleFocused.backgroundColor : "#FFAAAA";
	}
	
	this.getBorder = function(){
		return ((this._proto.style) && (this._proto.style.border)) ? this._proto.style.border : null;
	}
	
	this.getPadding = function(){
		return (this._proto.padding) ? this._proto.padding : [0,0];
	}
	
	this.getFocusOutTime = function(){
		if (isDefined(this._proto.focusOutTime))
			return this._proto.focusOutTime;
		else
			return 1000;
	}
	
	
	this.getItem = function( index ){
		return this._items[index];
	}
	
	this.indexOf = function( item ){
		for(var i = 0; i < this._items.length; i++){
			if (this.getItem(i) == item)
				return i;
		}
		return -1;
	}
	
	this.isEmpty = function(){
		return (this._items.length == 0);
	}
	
	this.build();
	this.render();
	

	
	this.showItems = function(){
	}
	
	this.hideItems = function(){
		for(var i = 0; i < this._items.length; i++){
			this._items[i].hideItems();
		}
	}
	
	
	//Level1ȏmenuItemێB
	this._activeItems = [];
	
	this.registerActiveItems = function(menuItem){
		if (this._activeItems[menuItem.getLevel() -1] != menuItem){
			if (this._activeItems[menuItem.getLevel() -1]){
				this._activeItems[menuItem.getLevel() -1].hideItems();
				this._activeItems[menuItem.getLevel() -1].deactivateStyle()
			}
		}
		this._activeItems[menuItem.getLevel() -1] = menuItem;
		if (menuItem.getLevel() > 0)
			this.registerActiveItems(menuItem.getParent());
	}
	
	this.isActive = function(menuItem){
		return (this._activeItems[menuItem.getLevel() -1] == menuItem);
	}
	
	this.activate = function(menuItem){
		this.registerActiveItems(menuItem);
		menuItem.showItems();
		menuItem.activateStyle();
	}
	
	this.deactivate = function(menuItem){
		var activeOnSameLevel = this._activeItems[menuItem.getLevel() -1];
		if (activeOnSameLevel != menuItem){
			this.forceDeactivate();
		}
	}
	
	this.forceDeactivate = function(menuItem){
		if (!(menuItem))
			return;
		menuItem.hideItems();
		menuItem.deactivateStyle();
		this._activeItems[menuItem.getLevel() -1] = null;
	}
	
	this.getLastActivatedItem = function(){
		for (var i = this._activeItems.length -1; i > -1 ; i--){
			var menuItem = this._activeItems[i];
			if (menuItem != null)
				return menuItem;
		}
		return null;
	}
	
	this.getActiveItem = function(level){
		var last = getLastActivatedItem();
		if (!(last))
			return null;
		var menuItem = last;
		{
			if (menuItem.getLevel() == level)
				return menuItem;
			menuItem = menuItem.getParent();
		} while(menuItem.getLevel() > 0)
    return null;
	}
	
	
	this.isCursorOnThis = function( event ){
		logger.debug("@isCursorOnThis      event is null: " + (event == null));
		var posX = xBrowser.getCursorLeft(event);
		var posY = xBrowser.getCursorTop(event);
		logger.debug("@isCursorOnThis      posX/posY=" + posX + "/"+ posY);
		if (this._div){
			var divX = xBrowser.getDivLeft(this._div);
			var divY = xBrowser.getDivTop(this._div);
			var divW = xBrowser.getDivWidth(this._div);
			var divH = xBrowser.getDivHeight(this._div);
			logger.debug("@isCursorOnThis      x,y,w,h=" + divX + ","+ divY+","+ divW + ","+ divH);
		}
		return this.include(posX, posY);
	}
	
	this.include = function(posX, posY){
		if (this._div){
			var left = xBrowser.getDivLeft(this._div);
			var top = xBrowser.getDivTop(this._div);
			var width = xBrowser.getDivWidth(this._div);
			var height = xBrowser.getDivHeight(this._div);
			if ((left <= posX) && (posX <= left + width) && (top <= posY) && (posY <= top + height))
				return true;
		}
		for(var i = 0; i < this._items.length; i++){
			var menuItem = this._items[i];
			if (menuItem.include(posX, posY))
				return true;
		}
		return false;
	}
	
	this.getClickStyle = function(){
		return (this._proto.clickStyle) ? this._proto.clickStyle : "normal";
	}
	
	
	
	
	var lastFocusedTime = 0;
	var cursorFocused = false;
	
	this.isTimeout = function(){
		return (new Date().getTime() - this.lastFocusedTime > this.getFocusOutTime());
	}
	
	this.updateFocused = function(event){
		this.cursorFocused = this.isCursorOnThis(event);
		if (this.cursorFocused)
			this.lastFocusedTime = new Date().getTime();
	}
	
	this.logFocused = function(methodName){
		logger.debug(methodName + "      cursorFocused=" + this.cursorFocused +"    isTimeout()=" + this.isTimeout());
	}
	
	this.itemOver = function(menuItem, event) {
		this.updateFocused(event);
		document.body.style.cursor = xBrowser.getCursorHand();
		if (! menuItem.isSeparator())
			menuItem.activate();
		this.logFocused("itemOver");
	}
	
	this.itemOut = function(menuItem, event) {
		this.updateFocused(event);
	}
	
	this.itemTimeout = function(){
		this.logFocused("itemTimeout");
		if (this.cursorFocused)
			return true;
		if (this.isTimeout()){
			document.body.style.cursor = "default";
			this.hideItems();
			return false;
		} else {
			return true;
		}
	}	
	
	
	this.windowMouseMove = function(event){
		this.updateFocused(event);
		this.logFocused("windowMouseMove");
		this.itemTimeout();
	}
	
	
	this.itemClick = function(menuItem, event){
		this.updateFocused(event);
		if (menuItem.hasUrl()){
			document.location = menuItem.getUrl();
		} else {
			switch(this.getClickStyle()){
				case "flip-flop":
					if (menuItem.isActive()){
						this.forceDeactivate(menuItem);
					}else{
						menuItem.activate();
					}
					break;
				default:
					if (! menuItem.isActive())
						menuItem.activate();
					break;
			}
		}
	}
	
}



/**</br/>
 * diṽCxgnhO֐QB
 * {Ȃ炱Ȋ֐ł͂ȂÃ\bhɂ񂾂
 * ݂Ȃ̂łƂ肠֐ŁB
 */
 
function menuItemOver(divId, event) {
	var menuItem = divIdToMenuItem.get(divId);
	menuItem.getRootNavi().itemOver(menuItem, event);
}

var inSetTimeout = false;

function menuItemOut(divId, event) {
	if (! inSetTimeout){
		inSetTimeout = true;
		setTimeout("menuItemOutImpl('" +divId+ "')", 100);
	}
}

function menuItemOutImpl(divId) {
	inSetTimeout = false;
	var menuItem = divIdToMenuItem.get(divId);
	if (menuItem.getRootNavi().itemTimeout()){
		inSetTimeout = true;
		setTimeout("menuItemOutImpl('" +divId+ "')", 100);
	}
}

function menuItemClick(divId, event) {
	var menuItem = divIdToMenuItem.get(divId);
	menuItem.getRootNavi().itemClick(menuItem, event);
}

/**
 * window.onmousemovenhOĂ܂B
 * window.onmousemovenhÔꍇ́A
 * 炩menuNaviWindowMouseMoveĂяo悤ɂĂB
 */
function menuNaviWindowMouseMove(event){
	for(var i = 0; i < menuNaviList.size(); i++) {
		var menuNavi = menuNaviList.get(i);
		menuNavi.windowMouseMove(event);
	}
}

if (xBrowser.ie) {
	document.onmousemove = menuNaviWindowMouseMove;
} else if (xBrowser.ff) {
}
window.onmousemove = menuNaviWindowMouseMove;
