/**
 * brownie-ctrl.js
 * 
 * uses 
 *  LibCrossBrowser.js
 *  EventHandler.js
 */
<!-- 

//ech_attachMouseDragɓnindex
var draggingIndex = 0;


/***************************************************************************************
 * 
 * utility functions
 * 
 ***************************************************************************************/

/**
 * hbȎΏۂƂȂdivƃhbOdivw肷
 */
function registerDragging(dragPointDivId, draggedDivId){
	return new DraggablePanel(
		getDivFromName(dragPointDivId), 
		getDivFromName(draggedDivId), 
		draggingIndex++);
}

/**
 * JiBjyCidiv, span, trEEEjƂ𐧌䂷{^w肷
 */
function registerClosablePane(openBtnId, closeBtnId, paneId){
	return new ClosablePanes(
		getDivFromName(openBtnId), 
		getDivFromName(closeBtnId), 
		[paneId]);
}

/**
 * JiBjyCidiv, span, trEEEjƂ𐧌䂷{^w肷
 */
function registerClosablePanes(openBtnId, closeBtnId, paneIdArray){
	return new ClosablePanes(
		getDivFromName(openBtnId), 
		getDivFromName(closeBtnId), 
		paneIdArray);
}

/**
 * `FbN{^ȂǂŊJiBjyCidiv, span, trEEEjw肷
 * radioŎgp̂͂߂قƎv܂B
 * ȂȂonclickCxgł͒lς邱(checkedfalseɂȂ邱)擾łȂłB
 * radioƘAꍇRadioClosablePanesNXpB
 */
function registerCheckingClosablePane(checkable, paneId){
	return new CheckingClosablePanes(
		getDivFromName(checkable), 
		[paneId]);
}

/**
 * `FbN{^ȂǂŊJiBjyCidiv, span, trEEEjw肷
 * radioŎgp̂͂߂قƎv܂B
 * ȂȂonclickCxgł͒lς邱(checkedfalseɂȂ邱)擾łȂłB
 * radioƘAꍇRadioClosablePanesNXpB
 */
function registerCheckingClosablePanes(checkable, paneIdArray){
	return new CheckingClosablePanes(
		getDivFromName(checkable), 
		paneIdArray);
}


/***************************************************************************************
 * 
 * DraggablePanel
 * 
 ***************************************************************************************/

/**
 * hbȎΏۂƂȂdivƃhbOdivw肷
 */
function DraggablePanel(dragPointDiv, draggedDiv, index) {
	this._titleBar = dragPointDiv;
	this._panel = draggedDiv;
	this._index = index;
	this.initTitleBar();
}

DraggablePanel.prototype.initTitleBar = function(){
	this._titleBar.style.cursor = "default";
  var ctrl = ech_attachMouseDrag(this._titleBar, null,null, this.titleBarMouseMove,this._index, null,null, null,null);
  ctrl._user = this;
}

DraggablePanel.prototype.titleBarMouseMove = function(ctrl, client) {
 	moveDivBy(ctrl._user._panel, ctrl.pageX-ctrl.curX, ctrl.pageY-ctrl.curY);
}

/***************************************************************************************
 * 
 * Pane
 * 
 ***************************************************************************************/

function AbstractPane(){
}

AbstractPane.prototype.setPanelDisplay = function(panelBodyIdArray, displayValue) {
	for (idx in panelBodyIdArray) {
		var panelName = panelBodyIdArray[idx];
		var p = getDivFromName(panelName);
		if (p) {
			p.style.display = displayValue;
		}
	}
}

new AbstractPane();

/***************************************************************************************
 * 
 * ClosablePanes
 * 
 ***************************************************************************************/

/**
 * ^Cgo[t̃pl𐧌䂷NX
 */
function ClosablePanes(openBtn, closeBtn, panelBodyIdArray) {
	this._openBtn = openBtn; 
	this._closeBtn = closeBtn;
	this._panelBodyIdArray = panelBodyIdArray;
	this.init(this._closeBtn, this.clickClose);
	this.init(this._openBtn, this.clickOpen);
}

inherit(ClosablePanes, AbstractPane);

ClosablePanes.prototype.init = function(button, handler) {
	button.style.cursor = "pointer";
  var ctrl = ech_attachMouseDrag(button, null,null, null,null, null,null, handler,draggingIndex++);
  ctrl._user = this;
}

ClosablePanes.prototype.open = function() {
	this._closeBtn.style.display = "inline";
	this._openBtn.style.display = "none";
	this.setPanelDisplay(this._panelBodyIdArray, "block");
}

ClosablePanes.prototype.close = function() {
	this._closeBtn.style.display = "none";
	this._openBtn.style.display = "inline";
	this.setPanelDisplay(this._panelBodyIdArray, "none");
}

ClosablePanes.prototype.clickClose = function(ctrl,client) {
	ctrl._user.close();
}

ClosablePanes.prototype.clickOpen = function(ctrl,client) {
	ctrl._user.open();
}

/***************************************************************************************
 * 
 * CheckingClosablePanes
 * 
 ***************************************************************************************/
/**
 * ^Cgo[t̃pl`FbN{bNXȂǂŐ䂷NX
 */
function CheckingClosablePanes(checkable, panelBodyIdArray) {
	this._checkable = checkable; 
	this._panelBodyIdArray = panelBodyIdArray;
	this.init();
}

inherit(CheckingClosablePanes, AbstractPane);

CheckingClosablePanes.prototype.init = function() {
	this._checkable.onclick = this.checkableOnClick( this );
}

CheckingClosablePanes.prototype.open = function() {
	this.setPanelDisplay(this._panelBodyIdArray, "block");
}

CheckingClosablePanes.prototype.close = function() {
	this.setPanelDisplay(this._panelBodyIdArray, "none");
}

CheckingClosablePanes.prototype.doOnClick = function() {
	if (this._checkable.checked) {
		this.open();
	} else {
		this.close();
	}
}

CheckingClosablePanes.prototype.checkableOnClick = function( pane ) {
	pane.doOnClick();
}

/***************************************************************************************
 * 
 * RadioClosablePanes
 * 
 ***************************************************************************************/

function RadioClosablePanes(){
	this._radioPaneMap = new Map();
	this._paneNameSet = new Set();
}

inherit(RadioClosablePanes, AbstractPane);

RadioClosablePanes.prototype.add = function(radioBtnId, mappedPaneNameArray) {
	var radioBtn = getDivFromName(radioBtnId);
	if (! radioBtn){
		alert(radioBtnId + " was not found");
	}
	var pane = this;
	radioBtn.onclick = function(){
		pane.refresh();
	}
	this._radioPaneMap.put(radioBtn, mappedPaneNameArray);
	//
	for (i = 0; i < mappedPaneNameArray.length; i++) {
		var panelName = mappedPaneNameArray[i];
		this._paneNameSet.add( panelName );
	}
}

RadioClosablePanes.prototype.refresh = function() {
	this.setPanelDisplay(this._paneNameSet.toArray(), "none");
	//
	var radios = this._radioPaneMap.keySet();
	for(var i = 0; i < radios.size(); i++){
		var radio = radios.get(i);
		if (radio.checked) {
			var paneNameArray = this._radioPaneMap.get( radio );
			this.setPanelDisplay(paneNameArray, "block");
		}
	}
}

-->