/**
 * brownie-lang.js
 * 
 * uses
 *  ;
 * @author T.Akima
 * @copyright T.Akima
 * @license LGNU
 */

<!-- 


/**************************************************************
 * XBrowser
 * class for CrossBrowsing
 **************************************************************/
function XBrowser(){
	var is_major=parseInt(navigator.appVersion);
	this.nver = is_major;
	this.ver = navigator.appVersion;
	this.dom = document.getElementById ? true : false;
	this.agent = navigator.userAgent;
	this.opera = window.opera ? true : false;
	this.opera7 = ((this.agent.toLowerCase().indexOf('opera 7')>-1) || (this.agent.toLowerCase().indexOf('opera/7')>-1));
	this.operaOld = this.opera&&!this.opera7;
	this.ie5 = (this.ver.indexOf("MSIE 5")>-1&&this.dom&&!this.opera);
	this.ie6 = (this.ver.indexOf("MSIE 6")>-1&&this.dom&&!this.opera);
	this.ie4 = (document.all&&!this.dom&&!this.opera);
	this.ie =  this.ie4||this.ie5||this.ie6;
	this.mac = this.agent.indexOf("Mac")>-1;
	this.ff = this.agent.indexOf("Firefox") > -1;
	this.nn6 = (this.dom&&(parseInt(this.ver)>=5)&&(! this.ff));
	this.ie3 = (this.ver.indexOf("MSIE")&&(is_major<4));
	this.hotjava = (this.agent.toLowerCase().indexOf('hotjava')!=-1);
	this.nn4 = (document.layers&&!this.dom&&!this.hotjava) ? true : false;
	this.bw = (this.ie6||this.ie5||this.ie4||this.nn4||this.nn6||this.opera);
	this.ver3 = (this.hotjava||this.ie3);
	
	this.toString = function(){
		return "nver=" + this.nver 
			+" ver=" + this.ver
			+" dom=" + this.dom
			+" ie=" + this.ie
			+" ie3=" + this.ie3
			+" ie4=" + this.ie4
			+" ie5=" + this.ie5
			+" ie6=" + this.ie6
			+" nn4=" + this.nn4
			+" nn6=" + this.nn6
			+" mac=" + this.mac
			+" hotjava=" + this.hotjava
			+" bw=" + this.bw
			+" ver3=" + this.ver3
			+" opera=" + this.opera
			+" opera7=" + this.opera7
			+" operaOld=" + this.operaOld
			+" ff=" + this.ff
			+" agent=" + this.agent;
	}
	
	/*----------------------------------------------------------*
	 * Div֌W
	 *----------------------------------------------------------*/
	this.getDiv = function(name){
		return this.nn4 ? document.layers[name] :
			(document.all) ? document.all[name] : document.getElementById(name);
	}
	

	this.getDivLeft = function(div){
		return (this.ie4) ? div.style.pixelLeft :
			(this.nn4) ? div.left :
			div.offsetLeft;
		return div.offsetLeft;
	}
	
	this.getDivTop = function(div){
		return (this.ie4) ? div.style.pixelTop :
			(this.nn4) ? div.top :
			div.offsetTop;
	}
	
	
	this.getDivWidth = function(div){
		return (this.ie4) ? div.style.pixelWidth :
			(this.nn4) ? div.width :
			div.offsetWidth;
	}
	
	this.getDivHeight = function(div){
		return (this.ie4) ? div.style.pixelHeight :
			(this.nn4) ? div.height :
			div.offsetHeight;
	}
	
	
	this.getDivVisibility = function(div){
		if (this.nn4) {
			return (div.visibility == 'inherit');
		//} else if (this.ff) {
		//	return (div.style.visibility == 'inherit') || (div.style.visibility == 'visible');
		} else {
			return (div.style.visibility != 'hidden');
		}
	}
	
	this.setDivVisibility = function(div, visible){
		if (this.nn4) {
			div.visibility = (visible) ? 'inherit' : 'hide';
		} else {
			div.style.visibility = (visible) ? 'inherit' : 'hidden';
		}
	}
	
	
	/*----------------------------------------------------------*
	 * J[\֌W
	 *----------------------------------------------------------*/
	this.getCursorLeft = function( e ){
		return (this.nn6) ? e.clientX + window.scrollX :
			(this.nn4) ? e.pageX : 
			(this.ie) ? document.body.scrollLeft + window.event.clientX : 
			(this.ff) ? document.body.scrollLeft + e.clientX : 
			e.clientX;
	}
	
	this.getCursorTop = function( e ){
		return (this.nn6) ? e.clientY + window.scrollY :
			(this.nn4) ? e.pageY : 
			(this.ie) ? document.body.scrollTop + window.event.clientY : 
			(this.ff) ? document.body.scrollTop + e.clientY : 
			e.clientY;
	}
	
	this.getCursorHand = function(){
		return this.ff ? "pointer" : "hand";
	}
	


}

/**************************************************************
 * XBrowser̃CX^X
 **************************************************************/
var xBrowser = new XBrowser();




/**************************************************************
 * lLǂ𔻒f
 **************************************************************/
function isDefined(val){
	return ! isUndefined(val);
}

/**************************************************************
 * lǂ𔻒f
 **************************************************************/
function isUndefined(val){
	return typeof(val) == 'undefined';
}

/**************************************************************
 * Lȕ񂩂ǂ𔻒f
 **************************************************************/
function isAvail(str){
	return (! isUndefined(str)) && (str != null) && (str != "");
}


/**************************************************************
 * IuWFNg̒g𕶎
 **************************************************************/
function descProps( obj ){
	var s = "";
	for (var key in obj){
		s = s + key +"="+ obj[key] + " ";
	}
	return s;
}


/**************************************************************
 * ps֐
 **************************************************************/
function inherit(subClass, superClass) {
	for (var prop in superClass.prototype) {
		subClass.prototype[prop] = superClass.prototype[prop];
	}
}

/**************************************************************
 * ziArrayIuWFNgjgXg
 * ArrayƂ̈Ⴂ́AremoveƂlengthς
 **************************************************************/
function ArrayList(){
	this.initVariables();
}

ArrayList.prototype.initVariables = function(){
  this.array = new Array();
}

ArrayList.prototype.add = function( obj ){
	var oldArray = this.array;
	this.array = new Array(oldArray.length +1 );
	this.array[ oldArray.length ] = obj;
	for (var i = 0; i < oldArray.length; i++){
		this.array[i] = oldArray[i];
	}
	return this.array.length;
}

ArrayList.prototype.addAll = function( collection ){
	for(var i = 0; i < collection.size(); i++){
		this.add(collection.get(i));
	}
}

ArrayList.prototype.clear = function(){
	this.array = new Array( 0 );
}

ArrayList.prototype.contain = function( obj ){
	var idx = this.indexOf( obj );
	return ( idx != -1 );
}

ArrayList.prototype.get = function( index ){
	return this.array[ index ];
} 

ArrayList.prototype.indexOf = function( obj ){
	for (var i = 0; i < this.array.length; i++){
		if ( this.array[ i ] == obj){
			return i;
		}
	}
	return -1;
} 

ArrayList.prototype.isEmpty = function( obj ){
	var sz = this.size();
	return (sz == 0);
}

ArrayList.prototype.remove = function( obj ){
	var removeIndex = this.indexOf( obj );
	if (removeIndex == -1)
		return removeIndex;
	var oldArray = this.array;
	this.array = new Array(oldArray.length -1 );
	var destIndex = 0;
	for (var i = 0; i < oldArray.length; i++){
		if (i != removeIndex){
			this.array[destIndex] = oldArray[i];
			destIndex ++ ;
		}
	}
	return removeIndex;
}

ArrayList.prototype.size = function(){
	return this.array.length ;
}

ArrayList.prototype.toArray = function(){
	var result = new Array( this.size() );
	for (var i = 0; i <this.size(); i++){
		result[i] = this.get(i);
	}
	return result;
}


new ArrayList(); //pp̃_~[𐶐

/**************************************************************
 * Set
 **************************************************************/
function Set(){
	this.initVariables();
}

inherit(Set, ArrayList);

Set.prototype.super_add = Set.prototype.add;
Set.prototype.add = function( obj ){
	if (! obj)
		return;
	if (this.indexOf(obj) <0)
		this.super_add( obj );
}

/**************************************************************
 * }bv̗vf
 **************************************************************/
function MapEntry(key, value){
	this._key = key;
	this._value = value;
}
MapEntry.prototype.getKey = function(){
	return this._key;
}
MapEntry.prototype.getValue = function(){
	return this._value;
}
MapEntry.prototype.setValue = function(value){
	this._value = value;
}


/**************************************************************
 * }bv
 **************************************************************/
function Map() {
	this._entries = new ArrayList();
}
Map.prototype.clear = function(){
	this._entries.clear();
}

Map.prototype.get = function(key){
	var entry = this.getEntry(key);
	if (entry) {
		return entry.getValue();
	} else {
		return null;
	}
}

Map.prototype.getEntry = function(key){
	if (key == null){
		return null;
	}
	for(var i = 0; i < this._entries.size(); i++){
		var entry = this._entries.get(i);
		if (entry.getKey() == key){
			return entry;
		}
	}
	return null;
}

Map.prototype.keySet = function(){
	var result = new Set();
	for(var i = 0; i < this._entries.size(); i++){
		var entry = this._entries.get(i);
		result.add( entry.getKey() );
	}
	return result;
}

Map.prototype.put = function(key, value){
	if (key == null){
		return;
	}
	var entry = this.getEntry(key);
	if (entry) {
		entry.setValue( value );
	} else {
		this._entries.add(new MapEntry(key, value));
	}	
}


/**************************************************************
 * Rg[idivȂǁjƕʂ̃IuWFNg̔ėp}bv
 **************************************************************/
var _controlToObject = new Map();







/**************************************************************
 * Oo͂邽߂̃NX
 **************************************************************/

function LogWindow(name, logging) {
	
	if (!(logging && logger_enabled)){
		this.debug = function( msg ) {
			//Ȃ
		}
	} else {
	
		this._name = name;
		
		this._window = null;
		
		this.debug = function( msg ) {
			try{ 
				this._write(msg);
			} catch(e) {
				this._window = null;
				this._write(msg);
			}
		}
		
		this._write = function( msg ){
			var w = this.getWindow();
			w.document.write( "<br/>" );
			w.document.write( this.formatDate( new Date() ) );
			w.document.write( " [" + this._name + "] ");
			w.document.write( msg );
			w.document.write( "\n" );
			w.scrollBy(0, 1000);
		}
		
		this.formatDate = function( d ){
			return d.getYear()+ "/"+
				(d.getMonth() + 1)+ "/"+
				d.getDate()+ " "+
				d.getHours() + ":" +
				d.getMinutes() + ":" +
				d.getSeconds() + ":" +
				d.getMilliseconds();
		}
		
		this.getWindow = function(){
			if (this._window == null){
				this._window = window.open('', this._name, "resizable=yes,scrollbars=yes,top=0,left=0");
				this._window.document.clear();
				this._window.document.write("<head><title>" + this._name + "</title></head>\n");
			} else if (this._window.closed){
				this._window.open();
			}
			return this._window;
		}
	}
}

var logger_enabled = false;
var glogger = new LogWindow("global_logger", true);

-->