/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.core.collection;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.asyrinx.brownie.core.collection.ClassKeyMap;

public class ClassKeyHashMap
implements ClassKeyMap {
    protected final Map impl = new HashMap();
    private LookingUp lookingUp = new LookingUpClassFirst();

    public ClassKeyHashMap() {
    }

    public ClassKeyHashMap(LookingUp lookingUp) {
        this.setLookingUp(lookingUp);
    }

    public Object get(Class key) {
        return this.getLookingUp().get(this.impl, key);
    }

    public void put(Class key, Object value) {
        this.impl.put(key, value);
    }

    public void put(String keyClassName, Object value) throws ClassNotFoundException {
        Class<?> keyClass = Class.forName(keyClassName);
        this.put(keyClass, value);
    }

    public void clear() {
        this.impl.clear();
    }

    public boolean containsKey(Class key) {
        return this.impl.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.impl.containsValue(value);
    }

    public boolean isEmpty() {
        return this.impl.isEmpty();
    }

    public Set keySet() {
        return this.impl.keySet();
    }

    public Object remove(Class key) {
        return this.impl.remove(key);
    }

    public int size() {
        return this.impl.size();
    }

    public Collection values() {
        return this.impl.values();
    }

    public LookingUp getLookingUp() {
        return this.lookingUp;
    }

    public void setLookingUp(LookingUp lookingUp) {
        this.lookingUp = lookingUp;
    }

    public interface LookingUp {
        public Object get(Map var1, Class var2);
    }

    public static class LookingUpClassFirst
    implements LookingUp {
        private Map repository = null;

        public Object get(Map repository, Class key) {
            this.repository = repository;
            Object result = this.getBySuperClass(key);
            if (result != null) {
                return result;
            }
            result = this.getByInterfacesOfClass(key);
            if (result != null) {
                return result;
            }
            return null;
        }

        private Object getBySuperClass(Class key) {
            Class current = key;
            while (current != null) {
                Object result = this.repository.get(current);
                if (result != null) {
                    return result;
                }
                current = current.getSuperclass();
            }
            return null;
        }

        private Object getByInterfacesOfClass(Class key) {
            Class current = key;
            while (current != null) {
                Object result = this.getByInterfaces(current.getInterfaces());
                if (result != null) {
                    return result;
                }
                current = current.getSuperclass();
            }
            return null;
        }

        private Object getByInterfaces(Class[] interfaces) {
            int i = 0;
            while (i < interfaces.length) {
                Object result = this.repository.get(interfaces[i]);
                if (result != null) {
                    return result;
                }
                result = this.getByInterfaces(interfaces[i].getInterfaces());
                if (result != null) {
                    return result;
                }
                ++i;
            }
            return null;
        }
    }

    public static class LookingUpInterfaceFirst
    implements LookingUp {
        private Map repository = null;

        public Object get(Map repository, Class key) {
            this.repository = repository;
            return this.getBySuperClass(key);
        }

        private Object getBySuperClass(Class key) {
            Class current = key;
            while (current != null) {
                Object result = this.getImpl(current);
                if (result != null) {
                    return result;
                }
                current = current.getSuperclass();
            }
            return null;
        }

        private Object getImpl(Class key) {
            Object result = this.repository.get(key);
            if (result != null) {
                return result;
            }
            return this.getByInterface(key);
        }

        private Object getByInterface(Class key) {
            Class<?>[] interfaces = key.getInterfaces();
            int i = 0;
            while (i < interfaces.length) {
                Object result = this.getBySuperClass(interfaces[i]);
                if (result != null) {
                    return result;
                }
                ++i;
            }
            return null;
        }
    }
}

