/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.core.collection.maptree;

import java.util.Map;
import org.asyrinx.brownie.core.collection.MapFactory;
import org.asyrinx.brownie.core.collection.maptree.MapTree;
import org.asyrinx.brownie.core.lang.ArrayUtils;

public class ArrayKeyHashMapTree
implements MapTree.ArrayKey {
    protected final Map root;
    protected final MapFactory mapFactory;

    public ArrayKeyHashMapTree() {
        this(null);
    }

    public ArrayKeyHashMapTree(Map root) {
        this(root, null);
    }

    public ArrayKeyHashMapTree(Map root, MapFactory mapFactory) {
        this.mapFactory = mapFactory != null ? mapFactory : MapFactory.HashMap;
        this.root = root != null ? root : this.createMap();
    }

    public Object get(Object[] key) {
        if (key == null || key.length == 0) {
            return null;
        }
        Map map = key.length == 1 ? this.root : this.getMap(ArrayUtils.subArray(key, 0, key.length - 1));
        return map == null ? null : map.get(key[key.length - 1]);
    }

    public void put(Object[] key, Object value) {
        if (key == null || key.length == 0) {
            return;
        }
        Map map = key.length == 1 ? this.root : this.needMap(ArrayUtils.subArray(key, 0, key.length - 1));
        map.put(key[key.length - 1], value);
    }

    public Map getRoot() {
        return this.root;
    }

    public Map getMap(Object[] key) {
        Map current = this.root;
        int i = 0;
        while (i < key.length) {
            Object val = current.get(key[i]);
            if (!(val instanceof Map)) {
                return null;
            }
            current = (Map)val;
            ++i;
        }
        return current;
    }

    protected Map needMap(Object[] key) {
        Map current = this.root;
        int i = 0;
        while (i < key.length) {
            Object val = current.get(key[i]);
            if (val instanceof Map) {
                current = (Map)val;
            } else {
                Map newMap = this.createMap();
                current.put(key[i], newMap);
                current = newMap;
            }
            ++i;
        }
        return current;
    }

    protected Map createMap() {
        return this.mapFactory.createMap();
    }
}

