/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.core.sql;

import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Set;
import org.asyrinx.brownie.core.collection.IntegerKeyMap;
import org.asyrinx.brownie.core.collection.StringKeyMap;

public class SqlReplacer {
    private DateFormat formatForDate = new SimpleDateFormat("yyyy/MM/dd");
    private DateFormat formatForTime = new SimpleDateFormat("HH:mm:ss");
    private DateFormat formatForTimestamp = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
    private char quote = (char)39;
    private static final char DEFAULT_QUOTE = '\'';

    public String execute(String sql, IntegerKeyMap parameters) {
        StringBuffer result = new StringBuffer(100);
        int lastParameterIndex = this.getLastParameterIndex(parameters);
        int paramIndex = 0;
        boolean inSingleQuote = false;
        boolean inDoubleQuote = false;
        int i = 0;
        while (i < sql.length()) {
            char currChar = sql.charAt(i);
            switch (currChar) {
                case '?': {
                    if (inSingleQuote || inDoubleQuote) {
                        result.append(currChar);
                        break;
                    }
                    if (++paramIndex > lastParameterIndex) {
                        paramIndex = 1;
                    }
                    Object value = parameters.get(paramIndex);
                    this.appendValue(result, value);
                    break;
                }
                case '\'': {
                    if (!inDoubleQuote) {
                        inSingleQuote = !inSingleQuote;
                    }
                    result.append(currChar);
                    break;
                }
                case '\"': {
                    if (!inSingleQuote) {
                        inDoubleQuote = !inDoubleQuote;
                    }
                    result.append(currChar);
                    break;
                }
                default: {
                    result.append(currChar);
                }
            }
            ++i;
        }
        return result.toString();
    }

    public String execute(String sql, StringKeyMap parameters) {
        return String.valueOf(sql) + " parameters=" + parameters;
    }

    private int getLastParameterIndex(IntegerKeyMap parameters) {
        Set keySet = parameters.keySet();
        ArrayList keyList = new ArrayList();
        keyList.addAll(keySet);
        Collections.sort(keyList);
        if (keyList.isEmpty()) {
            return 0;
        }
        Object value = keyList.get(keyList.size() - 1);
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        return 0;
    }

    private void appendValue(StringBuffer dest, Object value) {
        if (value == null) {
            dest.append("null");
            return;
        }
        if (this.needQuote(value)) {
            dest.append(this.getQuote());
        }
        if (value instanceof String) {
            dest.append(this.toString((String)value));
        } else if (value instanceof Timestamp) {
            dest.append(this.toString((Timestamp)value));
        } else if (value instanceof Time) {
            dest.append(this.toString((Time)value));
        } else if (value instanceof Date) {
            dest.append(this.toString((Date)value));
        } else {
            dest.append(this.toString(value));
        }
        if (this.needQuote(value)) {
            dest.append(this.getQuote());
        }
    }

    private boolean needQuote(Object value) {
        return value instanceof String || value instanceof Date || value instanceof Time || value instanceof Timestamp;
    }

    private String toString(Object value) {
        return String.valueOf(value);
    }

    private String toString(String value) {
        return value;
    }

    private String toString(Time value) {
        return String.valueOf(this.formatForTime.format(value));
    }

    private String toString(Date value) {
        return String.valueOf(this.formatForDate.format(value));
    }

    private String toString(Timestamp value) {
        return this.formatForTimestamp.format(new Date(value.getTime()));
    }

    public static String replacePreparedParmaeters(String sql, IntegerKeyMap parameters) {
        SqlReplacer replacer = new SqlReplacer();
        return replacer.execute(sql, parameters);
    }

    public static String replacePreparedParmaeters(String sql, IntegerKeyMap parameters, String formatForDate, String formatForTime, String formatForTimestamp) {
        SqlReplacer replacer = new SqlReplacer();
        replacer.setFormatForDate(new SimpleDateFormat(formatForDate));
        replacer.setFormatForTime(new SimpleDateFormat(formatForTime));
        replacer.setFormatForTimestamp(new SimpleDateFormat(formatForTimestamp));
        return replacer.execute(sql, parameters);
    }

    public DateFormat getFormatForDate() {
        return this.formatForDate;
    }

    public DateFormat getFormatForTime() {
        return this.formatForTime;
    }

    public DateFormat getFormatForTimestamp() {
        return this.formatForTimestamp;
    }

    public void setFormatForDate(DateFormat format) {
        this.formatForDate = format;
    }

    public void setFormatForTime(DateFormat format) {
        this.formatForTime = format;
    }

    public void setFormatForTimestamp(DateFormat format) {
        this.formatForTimestamp = format;
    }

    public char getQuote() {
        return this.quote;
    }

    public void setQuote(char c) {
        this.quote = c;
    }
}

