/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.core.xml.digester;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.Rule;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;

public class SetPropertiesRule
extends Rule {
    protected final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private String[] attributeNames;
    private String[] propertyNames;

    public SetPropertiesRule(Digester digester) {
        this();
    }

    public SetPropertiesRule() {
    }

    public SetPropertiesRule(String attributeName, String propertyName) {
        this.attributeNames = new String[1];
        this.attributeNames[0] = attributeName;
        this.propertyNames = new String[1];
        this.propertyNames[0] = propertyName;
    }

    public SetPropertiesRule(String[] attributeNames, String[] propertyNames) {
        this.attributeNames = new String[attributeNames.length];
        int i = 0;
        int size = attributeNames.length;
        while (i < size) {
            this.attributeNames[i] = attributeNames[i];
            ++i;
        }
        this.propertyNames = new String[propertyNames.length];
        i = 0;
        size = propertyNames.length;
        while (i < size) {
            this.propertyNames[i] = propertyNames[i];
            ++i;
        }
    }

    public void begin(Attributes attributes) throws Exception {
        HashMap values = this.prepareValues(attributes);
        Object top = this.digester.peek();
        if (this.log.isDebugEnabled()) {
            if (top != null) {
                this.log.debug((Object)("[SetPropertiesRule]{" + this.digester.getMatch() + "} Set " + top.getClass().getName() + " properties"));
            } else {
                this.log.debug((Object)("[SetPropertiesRule]{" + this.digester.getMatch() + "} Set NULL properties"));
            }
        }
        this.populateBean(values, top);
    }

    protected void populateBean(HashMap values, Object bean) throws Exception {
        BeanUtils.populate((Object)bean, (Map)values);
    }

    protected HashMap prepareValues(Attributes attributes) {
        int attNamesLength = this.attributeNames != null ? this.attributeNames.length : 0;
        int propNamesLength = this.propertyNames != null ? this.propertyNames.length : 0;
        HashMap<String, String> values = new HashMap<String, String>();
        int i = 0;
        while (i < attributes.getLength()) {
            String name = attributes.getLocalName(i);
            if ("".equals(name)) {
                name = attributes.getQName(i);
            }
            String value = attributes.getValue(i);
            int n = 0;
            while (n < attNamesLength) {
                if (name.equals(this.attributeNames[n])) {
                    if (n < propNamesLength) {
                        name = this.propertyNames[n];
                        break;
                    }
                    name = null;
                    break;
                }
                ++n;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("[SetPropertiesRule]{" + this.digester.getMatch() + "} Setting property '" + name + "' to '" + value + "'"));
            }
            if (name != null) {
                values.put(name, value);
            }
            ++i;
        }
        return values;
    }

    public void addAlias(String attributeName, String propertyName) {
        if (this.attributeNames == null) {
            this.attributeNames = new String[1];
            this.attributeNames[0] = attributeName;
            this.propertyNames = new String[1];
            this.propertyNames[0] = propertyName;
        } else {
            int length = this.attributeNames.length;
            String[] tempAttributes = new String[length + 1];
            int i = 0;
            while (i < length) {
                tempAttributes[i] = this.attributeNames[i];
                ++i;
            }
            tempAttributes[length] = attributeName;
            String[] tempProperties = new String[length + 1];
            int i2 = 0;
            while (i2 < length && i2 < this.propertyNames.length) {
                tempProperties[i2] = this.propertyNames[i2];
                ++i2;
            }
            tempProperties[length] = propertyName;
            this.propertyNames = tempProperties;
            this.attributeNames = tempAttributes;
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("SetPropertiesRule[");
        sb.append("]");
        return sb.toString();
    }

    public String[] getAttributeNames() {
        return this.attributeNames;
    }

    public void setAttributeNames(String[] attributeNames) {
        this.attributeNames = attributeNames;
    }

    public String[] getPropertyNames() {
        return this.propertyNames;
    }

    public void setPropertyNames(String[] propertyNames) {
        this.propertyNames = propertyNames;
    }
}

