/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.jdbc;

import java.io.IOException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.asyrinx.brownie.core.io.sf.RelativeClassResourceStreamFactory;
import org.asyrinx.brownie.core.io.sf.StreamFactory;
import org.asyrinx.brownie.core.io.sf.StreamFactoryFacade;
import org.asyrinx.brownie.core.io.sf.StringLoader;
import org.asyrinx.brownie.core.lang.StringUtils;
import org.asyrinx.brownie.jdbc.SqlLoadableStatement;
import org.asyrinx.brownie.jdbc.wrapper.ConnectionWrapper;

public final class SqlLoadableConnection
extends ConnectionWrapper {
    private final StreamFactory streamFactory;
    private final StreamFactoryFacade baseFactoryFacade;
    private final StringLoader loader;
    static /* synthetic */ Class class$0;

    public SqlLoadableConnection(Connection source) {
        this(source, null);
    }

    public SqlLoadableConnection(Connection source, String classToBeCalled) {
        this(source, classToBeCalled, null);
    }

    public SqlLoadableConnection(Connection source, String classToBeCalled, String sqlResources) {
        super(source);
        this.baseFactoryFacade = SqlLoadableConnection.newBaseFactoryFacade(sqlResources);
        this.streamFactory = SqlLoadableConnection.newFactory(classToBeCalled, this.baseFactoryFacade);
        this.loader = new StringLoader(this.streamFactory);
    }

    protected final String load(String key) throws SQLException {
        try {
            return this.loader.load(key);
        }
        catch (IOException e) {
            throw new SQLException(e.getMessage());
        }
    }

    static StreamFactoryFacade newBaseFactoryFacade(String sqlResources) {
        StreamFactoryFacade result = StreamFactoryFacade.newFacade(sqlResources);
        return result;
    }

    static StreamFactory newFactory(String classToBeCalled, StreamFactoryFacade baseFactoryFacade) {
        String string;
        StreamFactoryFacade result = baseFactoryFacade.copy();
        if (StringUtils.isEmpty((String)classToBeCalled)) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.asyrinx.brownie.jdbc.SqlLoadableConnection");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            string = clazz.getName();
        } else {
            string = classToBeCalled;
        }
        classToBeCalled = string;
        result.add(1, new RelativeClassResourceStreamFactory(classToBeCalled));
        return result;
    }

    public SqlLoadableStatement createSqlLoadableStatement() throws SQLException {
        return new SqlLoadableStatement(super.createStatement(), this.baseFactoryFacade);
    }

    public SqlLoadableStatement createSqlLoadableStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return new SqlLoadableStatement(super.createStatement(resultSetType, resultSetConcurrency), this.baseFactoryFacade);
    }

    public SqlLoadableStatement createSqlLoadableStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return new SqlLoadableStatement(super.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability), this.baseFactoryFacade);
    }

    public CallableStatement prepareCallFromFile(String sqlKey, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return super.prepareCall(this.load(sqlKey), resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    public CallableStatement prepareCallFromFile(String sqlKey, int resultSetType, int resultSetConcurrency) throws SQLException {
        return super.prepareCall(this.load(sqlKey), resultSetType, resultSetConcurrency);
    }

    public CallableStatement prepareCallFromFile(String sqlKey) throws SQLException {
        return super.prepareCall(this.load(sqlKey));
    }

    public PreparedStatement prepareStatementFromFile(String sqlKey, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return super.prepareStatement(this.load(sqlKey), resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    public PreparedStatement prepareStatementFromFile(String sqlKey, int resultSetType, int resultSetConcurrency) throws SQLException {
        return super.prepareStatement(this.load(sqlKey), resultSetType, resultSetConcurrency);
    }

    public PreparedStatement prepareStatementFromFile(String sqlKey, int autoGeneratedKeys) throws SQLException {
        return super.prepareStatement(this.load(sqlKey), autoGeneratedKeys);
    }

    public PreparedStatement prepareStatementFromFile(String sqlKey, int[] columnIndexes) throws SQLException {
        return super.prepareStatement(this.load(sqlKey), columnIndexes);
    }

    public PreparedStatement prepareStatementFromFile(String sqlKey, String[] columnNames) throws SQLException {
        return super.prepareStatement(this.load(sqlKey), columnNames);
    }

    public PreparedStatement prepareStatementFromFile(String sqlKey) throws SQLException {
        return super.prepareStatement(this.load(sqlKey));
    }
}

