/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.jdbc.logger;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import org.asyrinx.brownie.core.collection.MapUtils;
import org.asyrinx.brownie.core.collection.StringKeyMap;
import org.asyrinx.brownie.core.log.CascadeNamedLog;
import org.asyrinx.brownie.jdbc.logger.LogPreparedStatement;

public class LogCallableStatement
extends LogPreparedStatement
implements CallableStatement {
    private final CallableStatement wrapped;
    private final StringKeyMap parameters = MapUtils.toStringKeyMap(new HashMap());

    public LogCallableStatement(CallableStatement wrapped, String sql, CascadeNamedLog parentLog) {
        super(wrapped, sql, parentLog);
        this.wrapped = wrapped;
    }

    protected final void addParam(String paramName, Object value) {
        this.parameters.put(paramName, value);
    }

    protected String formatSql() {
        if (this.parameters.isEmpty()) {
            return super.formatSql();
        }
        return this.replacer.execute(this.sql, this.parameters);
    }

    public void clearParameters() throws SQLException {
        super.clearParameters();
        this.parameters.clear();
    }

    public Array getArray(int parameterIndex) throws SQLException {
        return this.wrapped.getArray(parameterIndex);
    }

    public Array getArray(String parameterName) throws SQLException {
        return this.wrapped.getArray(parameterName);
    }

    public BigDecimal getBigDecimal(int parameterIndex) throws SQLException {
        return this.wrapped.getBigDecimal(parameterIndex);
    }

    public BigDecimal getBigDecimal(int parameterIndex, int scale) throws SQLException {
        return this.wrapped.getBigDecimal(parameterIndex, scale);
    }

    public BigDecimal getBigDecimal(String parameterName) throws SQLException {
        return this.wrapped.getBigDecimal(parameterName);
    }

    public Blob getBlob(int parameterIndex) throws SQLException {
        return this.wrapped.getBlob(parameterIndex);
    }

    public Blob getBlob(String parameterName) throws SQLException {
        return this.wrapped.getBlob(parameterName);
    }

    public boolean getBoolean(int parameterIndex) throws SQLException {
        return this.wrapped.getBoolean(parameterIndex);
    }

    public boolean getBoolean(String parameterName) throws SQLException {
        return this.wrapped.getBoolean(parameterName);
    }

    public byte getByte(int parameterIndex) throws SQLException {
        return this.wrapped.getByte(parameterIndex);
    }

    public byte getByte(String parameterName) throws SQLException {
        return this.wrapped.getByte(parameterName);
    }

    public byte[] getBytes(int parameterIndex) throws SQLException {
        return this.wrapped.getBytes(parameterIndex);
    }

    public byte[] getBytes(String parameterName) throws SQLException {
        return this.wrapped.getBytes(parameterName);
    }

    public Clob getClob(int parameterIndex) throws SQLException {
        return this.wrapped.getClob(parameterIndex);
    }

    public Clob getClob(String parameterName) throws SQLException {
        return this.wrapped.getClob(parameterName);
    }

    public Date getDate(int parameterIndex) throws SQLException {
        return this.wrapped.getDate(parameterIndex);
    }

    public Date getDate(int parameterIndex, Calendar cal) throws SQLException {
        return this.wrapped.getDate(parameterIndex, cal);
    }

    public Date getDate(String parameterName) throws SQLException {
        return this.wrapped.getDate(parameterName);
    }

    public Date getDate(String parameterName, Calendar cal) throws SQLException {
        return this.wrapped.getDate(parameterName, cal);
    }

    public double getDouble(int parameterIndex) throws SQLException {
        return this.wrapped.getDouble(parameterIndex);
    }

    public double getDouble(String parameterName) throws SQLException {
        return this.wrapped.getDouble(parameterName);
    }

    public float getFloat(int parameterIndex) throws SQLException {
        return this.wrapped.getFloat(parameterIndex);
    }

    public float getFloat(String parameterName) throws SQLException {
        return this.wrapped.getFloat(parameterName);
    }

    public int getInt(int parameterIndex) throws SQLException {
        return this.wrapped.getInt(parameterIndex);
    }

    public int getInt(String parameterName) throws SQLException {
        return this.wrapped.getInt(parameterName);
    }

    public long getLong(int parameterIndex) throws SQLException {
        return this.wrapped.getLong(parameterIndex);
    }

    public long getLong(String parameterName) throws SQLException {
        return this.wrapped.getLong(parameterName);
    }

    public Object getObject(int parameterIndex) throws SQLException {
        return this.wrapped.getObject(parameterIndex);
    }

    public Object getObject(int parameterIndex, Map map) throws SQLException {
        return this.wrapped.getObject(parameterIndex, map);
    }

    public Object getObject(String parameterName) throws SQLException {
        return this.wrapped.getObject(parameterName);
    }

    public Object getObject(String parameterName, Map map) throws SQLException {
        return this.wrapped.getObject(parameterName, map);
    }

    public Ref getRef(int parameterIndex) throws SQLException {
        return this.wrapped.getRef(parameterIndex);
    }

    public Ref getRef(String parameterName) throws SQLException {
        return this.wrapped.getRef(parameterName);
    }

    public short getShort(int parameterIndex) throws SQLException {
        return this.wrapped.getShort(parameterIndex);
    }

    public short getShort(String parameterName) throws SQLException {
        return this.wrapped.getShort(parameterName);
    }

    public String getString(int parameterIndex) throws SQLException {
        return this.wrapped.getString(parameterIndex);
    }

    public String getString(String parameterName) throws SQLException {
        return this.wrapped.getString(parameterName);
    }

    public Time getTime(int parameterIndex) throws SQLException {
        return this.wrapped.getTime(parameterIndex);
    }

    public Time getTime(int parameterIndex, Calendar cal) throws SQLException {
        return this.wrapped.getTime(parameterIndex, cal);
    }

    public Time getTime(String parameterName) throws SQLException {
        return this.wrapped.getTime(parameterName);
    }

    public Time getTime(String parameterName, Calendar cal) throws SQLException {
        return this.wrapped.getTime(parameterName, cal);
    }

    public Timestamp getTimestamp(int parameterIndex) throws SQLException {
        return this.wrapped.getTimestamp(parameterIndex);
    }

    public Timestamp getTimestamp(int parameterIndex, Calendar cal) throws SQLException {
        return this.wrapped.getTimestamp(parameterIndex, cal);
    }

    public Timestamp getTimestamp(String parameterName) throws SQLException {
        return this.wrapped.getTimestamp(parameterName);
    }

    public Timestamp getTimestamp(String parameterName, Calendar cal) throws SQLException {
        return this.wrapped.getTimestamp(parameterName, cal);
    }

    public URL getURL(int parameterIndex) throws SQLException {
        return this.wrapped.getURL(parameterIndex);
    }

    public URL getURL(String parameterName) throws SQLException {
        return this.wrapped.getURL(parameterName);
    }

    public void registerOutParameter(int parameterIndex, int sqlType) throws SQLException {
        this.wrapped.registerOutParameter(parameterIndex, sqlType);
    }

    public void registerOutParameter(int parameterIndex, int sqlType, int scale) throws SQLException {
        this.wrapped.registerOutParameter(parameterIndex, sqlType, scale);
    }

    public void registerOutParameter(int paramIndex, int sqlType, String typeName) throws SQLException {
        this.wrapped.registerOutParameter(paramIndex, sqlType, typeName);
    }

    public void registerOutParameter(String parameterName, int sqlType) throws SQLException {
        this.wrapped.registerOutParameter(parameterName, sqlType);
    }

    public void registerOutParameter(String parameterName, int sqlType, int scale) throws SQLException {
        this.wrapped.registerOutParameter(parameterName, sqlType, scale);
    }

    public void registerOutParameter(String parameterName, int sqlType, String typeName) throws SQLException {
        this.wrapped.registerOutParameter(parameterName, sqlType, typeName);
    }

    public void setAsciiStream(String parameterName, InputStream x, int length) throws SQLException {
        this.wrapped.setAsciiStream(parameterName, x, length);
    }

    public void setBigDecimal(String parameterName, BigDecimal x) throws SQLException {
        this.wrapped.setBigDecimal(parameterName, x);
        this.addParam(parameterName, (Object)x);
    }

    public void setBinaryStream(String parameterName, InputStream x, int length) throws SQLException {
        this.wrapped.setBinaryStream(parameterName, x, length);
    }

    public void setBoolean(String parameterName, boolean x) throws SQLException {
        this.wrapped.setBoolean(parameterName, x);
        this.addParam(parameterName, (Object)new Boolean(x));
    }

    public void setByte(String parameterName, byte x) throws SQLException {
        this.wrapped.setByte(parameterName, x);
        this.addParam(parameterName, (Object)new Byte(x));
    }

    public void setBytes(String parameterName, byte[] x) throws SQLException {
        this.wrapped.setBytes(parameterName, x);
        this.addParam(parameterName, (Object)x);
    }

    public void setCharacterStream(String parameterName, Reader reader, int length) throws SQLException {
        this.wrapped.setCharacterStream(parameterName, reader, length);
    }

    public void setDate(String parameterName, Date x) throws SQLException {
        this.wrapped.setDate(parameterName, x);
        this.addParam(parameterName, (Object)x);
    }

    public void setDate(String parameterName, Date x, Calendar cal) throws SQLException {
        this.wrapped.setDate(parameterName, x, cal);
        this.addParam(parameterName, (Object)x);
    }

    public void setDouble(String parameterName, double x) throws SQLException {
        this.wrapped.setDouble(parameterName, x);
        this.addParam(parameterName, (Object)new Double(x));
    }

    public void setFloat(String parameterName, float x) throws SQLException {
        this.wrapped.setFloat(parameterName, x);
        this.addParam(parameterName, (Object)new Float(x));
    }

    public void setInt(String parameterName, int x) throws SQLException {
        this.wrapped.setInt(parameterName, x);
        this.addParam(parameterName, (Object)new Integer(x));
    }

    public void setLong(String parameterName, long x) throws SQLException {
        this.wrapped.setLong(parameterName, x);
        this.addParam(parameterName, (Object)new Long(x));
    }

    public void setNull(String parameterName, int sqlType) throws SQLException {
        this.wrapped.setNull(parameterName, sqlType);
    }

    public void setNull(String parameterName, int sqlType, String typeName) throws SQLException {
        this.wrapped.setNull(parameterName, sqlType, typeName);
    }

    public void setObject(String parameterName, Object x) throws SQLException {
        this.wrapped.setObject(parameterName, x);
        this.addParam(parameterName, x);
    }

    public void setObject(String parameterName, Object x, int targetSqlType) throws SQLException {
        this.wrapped.setObject(parameterName, x, targetSqlType);
        this.addParam(parameterName, x);
    }

    public void setObject(String parameterName, Object x, int targetSqlType, int scale) throws SQLException {
        this.wrapped.setObject(parameterName, x, targetSqlType, scale);
        this.addParam(parameterName, x);
    }

    public void setShort(String parameterName, short x) throws SQLException {
        this.wrapped.setShort(parameterName, x);
        this.addParam(parameterName, (Object)new Short(x));
    }

    public void setString(String parameterName, String x) throws SQLException {
        this.wrapped.setString(parameterName, x);
        this.addParam(parameterName, (Object)x);
    }

    public void setTime(String parameterName, Time x) throws SQLException {
        this.wrapped.setTime(parameterName, x);
        this.addParam(parameterName, (Object)x);
    }

    public void setTime(String parameterName, Time x, Calendar cal) throws SQLException {
        this.wrapped.setTime(parameterName, x, cal);
        this.addParam(parameterName, (Object)x);
    }

    public void setTimestamp(String parameterName, Timestamp x) throws SQLException {
        this.wrapped.setTimestamp(parameterName, x);
        this.addParam(parameterName, (Object)x);
    }

    public void setTimestamp(String parameterName, Timestamp x, Calendar cal) throws SQLException {
        this.wrapped.setTimestamp(parameterName, x, cal);
        this.addParam(parameterName, (Object)x);
    }

    public void setURL(String parameterName, URL x) throws SQLException {
        this.wrapped.setURL(parameterName, x);
        this.addParam(parameterName, (Object)x);
    }

    public boolean wasNull() throws SQLException {
        return this.wrapped.wasNull();
    }
}

