/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.jdbc.logger;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import org.asyrinx.brownie.core.lang.ArrayUtils;
import org.asyrinx.brownie.core.log.CascadeNamedLog;
import org.asyrinx.brownie.jdbc.logger.LogCallableStatement;
import org.asyrinx.brownie.jdbc.logger.LogPreparedStatement;
import org.asyrinx.brownie.jdbc.logger.LogStatement;
import org.asyrinx.brownie.jdbc.wrapper.ConnectionWrapper;

public class LogConnection
extends ConnectionWrapper {
    private final CascadeNamedLog log;

    public LogConnection(Connection wrapped) {
        this(wrapped, wrapped.getClass().getName());
    }

    public LogConnection(Connection wrapped, String loggerName) {
        this(wrapped, loggerName, "debug");
    }

    public LogConnection(Connection wrapped, String loggerName, String logLevel) {
        this(wrapped, new CascadeNamedLog(loggerName, logLevel));
    }

    public LogConnection(Connection wrapped, CascadeNamedLog parentLog) {
        super(wrapped);
        this.log = parentLog.subLog(this.wrapped);
    }

    public Statement createStatement() throws SQLException {
        try {
            Statement result = super.createStatement();
            this.log.log("createStatement(): " + result);
            return new LogStatement(result, this.log);
        }
        catch (SQLException e) {
            this.log.error("failed to createStatement()", e);
            throw e;
        }
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        try {
            Statement result = super.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
            this.log.log("createStatement(" + resultSetType + "," + resultSetConcurrency + "," + resultSetHoldability + "): " + result);
            return new LogStatement(result, this.log);
        }
        catch (SQLException e) {
            this.log.error("failed to createStatement(" + resultSetType + "," + resultSetConcurrency + "," + resultSetHoldability + ")", e);
            throw e;
        }
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        try {
            Statement result = super.createStatement(resultSetType, resultSetConcurrency);
            this.log.log("createStatement(" + resultSetType + "," + resultSetConcurrency + "): " + result);
            return new LogStatement(result, this.log);
        }
        catch (SQLException e) {
            this.log.error("failed to createStatement(" + resultSetType + "," + resultSetConcurrency + ")", e);
            throw e;
        }
    }

    public String nativeSQL(String sql) throws SQLException {
        try {
            String result = super.nativeSQL(sql);
            this.log.log("nativeSQL(\"" + sql + "\"): \"" + result + "\"");
            return result;
        }
        catch (SQLException e) {
            this.log.error(sql, e);
            throw e;
        }
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        try {
            CallableStatement result = super.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
            this.log.log("prepareCall(\"" + sql + "\"," + resultSetType + "," + resultSetConcurrency + "," + resultSetHoldability + "): " + result);
            return new LogCallableStatement(result, sql, this.log.subLog(result));
        }
        catch (SQLException e) {
            this.log.error("failed to prepareCall(\"" + sql + "\"," + resultSetType + "," + resultSetConcurrency + "," + resultSetHoldability + ")", e);
            throw e;
        }
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        try {
            CallableStatement result = super.prepareCall(sql, resultSetType, resultSetConcurrency);
            this.log.log("prepareCall(\"" + sql + "\"," + resultSetType + "," + resultSetConcurrency + "): " + result);
            return new LogCallableStatement(result, sql, this.log.subLog(result));
        }
        catch (SQLException e) {
            this.log.error("failed to prepareCall(\"" + sql + "\"," + resultSetType + "," + resultSetConcurrency + ")", e);
            throw e;
        }
    }

    public CallableStatement prepareCall(String sql) throws SQLException {
        try {
            CallableStatement result = super.prepareCall(sql);
            this.log.log("prepareCall(\"" + sql + "\"):" + result);
            return new LogCallableStatement(result, sql, this.log.subLog(result));
        }
        catch (SQLException e) {
            this.log.error("failed to prepareCall(\"" + sql + "\")", e);
            throw e;
        }
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        try {
            PreparedStatement result = super.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
            this.log.log("prepareStatement(\"" + sql + "\"," + resultSetType + "," + resultSetConcurrency + "," + resultSetHoldability + "): " + result);
            return new LogPreparedStatement(result, sql, this.log.subLog(result));
        }
        catch (SQLException e) {
            this.log.error("failed to prepareStatement(\"" + sql + "\"," + resultSetType + "," + resultSetConcurrency + "," + resultSetHoldability + ")", e);
            throw e;
        }
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        try {
            PreparedStatement result = super.prepareStatement(sql, resultSetType, resultSetConcurrency);
            this.log.log("prepareStatement(\"" + sql + "\"," + resultSetType + "," + resultSetConcurrency + "): " + result);
            return new LogPreparedStatement(result, sql, this.log.subLog(result));
        }
        catch (SQLException e) {
            this.log.error("failed to prepareStatement(\"" + sql + "\"," + resultSetType + "," + resultSetConcurrency + ")", e);
            throw e;
        }
    }

    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        try {
            PreparedStatement result = super.prepareStatement(sql, autoGeneratedKeys);
            this.log.log("prepareStatement(\"" + sql + "\"," + autoGeneratedKeys + "): " + result);
            return new LogPreparedStatement(result, sql, this.log.subLog(result));
        }
        catch (SQLException e) {
            this.log.error("failed to prepareStatement(\"" + sql + "\"," + autoGeneratedKeys + ")", e);
            throw e;
        }
    }

    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        try {
            PreparedStatement result = super.prepareStatement(sql, columnIndexes);
            this.log.log("prepareStatement(\"" + sql + "\",[" + ArrayUtils.toString(columnIndexes) + "]): " + result);
            return new LogPreparedStatement(result, sql, this.log.subLog(result));
        }
        catch (SQLException e) {
            this.log.error("failed to prepareStatement(\"" + sql + "\",[" + ArrayUtils.toString(columnIndexes) + "])", e);
            throw e;
        }
    }

    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        try {
            PreparedStatement result = super.prepareStatement(sql, columnNames);
            this.log.log("prepareStatement(\"" + sql + "\",[" + ArrayUtils.toString(columnNames) + "]): " + result);
            return new LogPreparedStatement(result, sql, this.log.subLog(result));
        }
        catch (SQLException e) {
            this.log.error("failed to prepareStatement(\"" + sql + "\",[" + ArrayUtils.toString(columnNames) + "])", e);
            throw e;
        }
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        try {
            PreparedStatement result = super.prepareStatement(sql);
            this.log.log("prepareStatement(\"" + sql + "): " + result);
            return new LogPreparedStatement(result, sql, this.log.subLog(result));
        }
        catch (SQLException e) {
            this.log.error("failed to prepareStatement(\"" + sql + ")", e);
            throw e;
        }
    }

    public void commit() throws SQLException {
        try {
            super.commit();
            this.log.log("commit()");
        }
        catch (SQLException e) {
            this.log.error("failed to commit()", e);
            throw e;
        }
    }

    public void rollback() throws SQLException {
        try {
            super.rollback();
            this.log.log("rollback()");
        }
        catch (SQLException e) {
            this.log.error("failed to rollback()", e);
            throw e;
        }
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        try {
            super.rollback(savepoint);
            this.log.log("rollback(" + savepoint + ")");
        }
        catch (SQLException e) {
            this.log.error("failed to rollback(" + savepoint + ")", e);
            throw e;
        }
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        try {
            super.setAutoCommit(autoCommit);
            this.log.log("setAutoCommit(" + autoCommit + ")");
        }
        catch (SQLException e) {
            this.log.error("failed to setAutoCommit(" + autoCommit + ")", e);
            throw e;
        }
    }

    public Savepoint setSavepoint() throws SQLException {
        try {
            Savepoint result = super.setSavepoint();
            this.log.log("setSavepoint(): " + result);
            return result;
        }
        catch (SQLException e) {
            this.log.error("failed to setSavepoint()", e);
            throw e;
        }
    }

    public Savepoint setSavepoint(String name) throws SQLException {
        try {
            Savepoint result = super.setSavepoint(name);
            this.log.log("setSavepoint(" + name + "): " + result);
            return result;
        }
        catch (SQLException e) {
            this.log.error("failed to setSavepoint(" + name + ")", e);
            throw e;
        }
    }
}

