/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.jdbc.logger;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import org.asyrinx.brownie.core.collection.IntegerKeyMap;
import org.asyrinx.brownie.core.collection.MapUtils;
import org.asyrinx.brownie.core.log.CascadeNamedLog;
import org.asyrinx.brownie.core.sql.SqlReplacer;
import org.asyrinx.brownie.jdbc.logger.LogStatement;

public class LogPreparedStatement
extends LogStatement
implements PreparedStatement {
    private final PreparedStatement wrapped;
    private final IntegerKeyMap parameters = MapUtils.toIntegerKeyMap(new HashMap());
    protected final String sql;
    protected final SqlReplacer replacer = new SqlReplacer();

    public LogPreparedStatement(PreparedStatement wrapped, String sql, CascadeNamedLog parentLog) {
        super(wrapped, parentLog);
        this.wrapped = wrapped;
        this.sql = sql;
    }

    protected final void addParam(int paramIndex, Object value) {
        this.parameters.put(paramIndex, value);
    }

    protected void log() {
        this.log.log(this.formatSql());
    }

    protected void log(SQLException e) {
        this.log.error(this.formatSql(), e);
    }

    protected String formatSql() {
        return this.replacer.execute(this.sql, this.parameters);
    }

    public void addBatch() throws SQLException {
        this.wrapped.addBatch();
        this.batches.add(this.formatSql());
    }

    public void clearParameters() throws SQLException {
        this.wrapped.clearParameters();
        this.parameters.clear();
    }

    public boolean execute() throws SQLException {
        try {
            boolean reasult = this.wrapped.execute();
            this.log();
            return reasult;
        }
        catch (SQLException e) {
            this.log(e);
            throw e;
        }
    }

    public ResultSet executeQuery() throws SQLException {
        try {
            ResultSet result = this.wrapped.executeQuery();
            this.log();
            return result;
        }
        catch (SQLException e) {
            this.log(e);
            throw e;
        }
    }

    public int executeUpdate() throws SQLException {
        try {
            int result = this.wrapped.executeUpdate();
            this.log();
            return result;
        }
        catch (SQLException e) {
            this.log(e);
            throw e;
        }
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return this.wrapped.getMetaData();
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        return this.wrapped.getParameterMetaData();
    }

    public void setArray(int parameterIndex, Array x) throws SQLException {
        this.wrapped.setArray(parameterIndex, x);
        this.addParam(parameterIndex, x);
    }

    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.wrapped.setAsciiStream(parameterIndex, x, length);
    }

    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.wrapped.setBigDecimal(parameterIndex, x);
        this.addParam(parameterIndex, x);
    }

    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.wrapped.setBinaryStream(parameterIndex, x, length);
    }

    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        this.wrapped.setBlob(parameterIndex, x);
        this.addParam(parameterIndex, x);
    }

    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.wrapped.setBoolean(parameterIndex, x);
        this.addParam(parameterIndex, new Boolean(x));
    }

    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.wrapped.setByte(parameterIndex, x);
        this.addParam(parameterIndex, new Byte(x));
    }

    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.wrapped.setBytes(parameterIndex, x);
        this.addParam(parameterIndex, x);
    }

    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.wrapped.setCharacterStream(parameterIndex, reader, length);
    }

    public void setClob(int parameterIndex, Clob x) throws SQLException {
        this.wrapped.setClob(parameterIndex, x);
        this.addParam(parameterIndex, x);
    }

    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.wrapped.setDate(parameterIndex, x);
        this.addParam(parameterIndex, x);
    }

    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        this.wrapped.setDate(parameterIndex, x, cal);
        this.addParam(parameterIndex, x);
    }

    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.wrapped.setDouble(parameterIndex, x);
        this.addParam(parameterIndex, new Double(x));
    }

    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.wrapped.setFloat(parameterIndex, x);
        this.addParam(parameterIndex, new Float(x));
    }

    public void setInt(int parameterIndex, int x) throws SQLException {
        this.wrapped.setInt(parameterIndex, x);
        this.addParam(parameterIndex, new Integer(x));
    }

    public void setLong(int parameterIndex, long x) throws SQLException {
        this.wrapped.setLong(parameterIndex, x);
        this.addParam(parameterIndex, new Long(x));
    }

    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.wrapped.setNull(parameterIndex, sqlType);
    }

    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.wrapped.setNull(parameterIndex, sqlType, typeName);
    }

    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.wrapped.setObject(parameterIndex, x);
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.wrapped.setObject(parameterIndex, x, targetSqlType);
        this.addParam(parameterIndex, x);
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType, int scale) throws SQLException {
        this.wrapped.setObject(parameterIndex, x, targetSqlType, scale);
        this.addParam(parameterIndex, x);
    }

    public void setRef(int parameterIndex, Ref x) throws SQLException {
        this.wrapped.setRef(parameterIndex, x);
        this.addParam(parameterIndex, x);
    }

    public void setShort(int parameterIndex, short x) throws SQLException {
        this.wrapped.setShort(parameterIndex, x);
        this.addParam(parameterIndex, new Short(x));
    }

    public void setString(int parameterIndex, String x) throws SQLException {
        this.wrapped.setString(parameterIndex, x);
        this.addParam(parameterIndex, x);
    }

    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.wrapped.setTime(parameterIndex, x);
        this.addParam(parameterIndex, x);
    }

    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        this.wrapped.setTime(parameterIndex, x, cal);
        this.addParam(parameterIndex, x);
    }

    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.wrapped.setTimestamp(parameterIndex, x);
        this.addParam(parameterIndex, x);
    }

    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.wrapped.setTimestamp(parameterIndex, x, cal);
        this.addParam(parameterIndex, x);
    }

    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.wrapped.setUnicodeStream(parameterIndex, x, length);
    }

    public void setURL(int parameterIndex, URL x) throws SQLException {
        this.wrapped.setURL(parameterIndex, x);
        this.addParam(parameterIndex, x);
    }
}

