/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.jdbc.logger;

import java.sql.SQLException;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import org.asyrinx.brownie.core.log.CascadeNamedLog;
import org.asyrinx.brownie.jdbc.logger.LogXAConnection;
import org.asyrinx.brownie.jdbc.wrapper.XADataSourceWrapper;

public class LogXADataSource
extends XADataSourceWrapper {
    protected final CascadeNamedLog log;

    public LogXADataSource(XADataSource wrapped) {
        this(wrapped, new CascadeNamedLog(wrapped.getClass(), "debug"));
    }

    public LogXADataSource(XADataSource wrapped, String name) {
        this(wrapped, new CascadeNamedLog(name, "debug"));
    }

    public LogXADataSource(XADataSource wrapped, CascadeNamedLog log) {
        super(wrapped);
        this.log = log;
    }

    protected XAConnection toLogXAConnection(XAConnection connection) {
        return new LogXAConnection(connection, this.log.subLog(connection.getClass()));
    }

    public XAConnection getXAConnection() throws SQLException {
        try {
            XAConnection result = super.getXAConnection();
            this.log.log("getXAConnection(): " + result);
            return this.toLogXAConnection(result);
        }
        catch (SQLException e) {
            this.log.error("failed to getXAConnection(): ", e);
            throw e;
        }
    }

    public XAConnection getXAConnection(String user, String password) throws SQLException {
        try {
            XAConnection result = super.getXAConnection(user, password);
            this.log.log("getXAConnection(" + user + "," + password + "): " + result);
            return this.toLogXAConnection(result);
        }
        catch (SQLException e) {
            this.log.error("failed to getXAConnection(" + user + "," + password + "): ", e);
            throw e;
        }
    }

    public void setLoginTimeout(int seconds) throws SQLException {
        try {
            super.setLoginTimeout(seconds);
            this.log.log("setLoginTimeout(" + seconds + ")");
        }
        catch (SQLException e) {
            this.log.error("failed to setLoginTimeout(" + seconds + ")", e);
            throw e;
        }
    }
}

