/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.jdbc.logger;

import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.asyrinx.brownie.core.log.CascadeNamedLog;
import org.asyrinx.brownie.jdbc.wrapper.XAResourceWrapper;

public class LogXAResource
extends XAResourceWrapper {
    protected final CascadeNamedLog log;

    public LogXAResource(XAResource wrapped) {
        this(wrapped, new CascadeNamedLog(wrapped.getClass(), "debug"));
    }

    public LogXAResource(XAResource wrapped, CascadeNamedLog log) {
        super(wrapped);
        this.log = log;
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        try {
            super.commit(xid, onePhase);
            this.log.log("commit(" + xid + "," + onePhase + ")");
        }
        catch (XAException e) {
            this.log.error("failed to commit(" + xid + "," + onePhase + ")", e);
            throw e;
        }
    }

    public void end(Xid xid, int flags) throws XAException {
        try {
            super.end(xid, flags);
            this.log.log("end(" + xid + "," + flags + ")");
        }
        catch (XAException e) {
            this.log.error("failed to end(" + xid + "," + flags + ")", e);
            throw e;
        }
    }

    public void forget(Xid xid) throws XAException {
        try {
            super.forget(xid);
            this.log.log("forget(" + xid + ")");
        }
        catch (XAException e) {
            this.log.error("failed to forget(" + xid + ")", e);
            throw e;
        }
    }

    public int getTransactionTimeout() throws XAException {
        try {
            int result = super.getTransactionTimeout();
            this.log.log("getTransactionTimeout(): " + result);
            return result;
        }
        catch (XAException e) {
            this.log.error("failed to getTransactionTimeout(): ");
            throw e;
        }
    }

    public boolean isSameRM(XAResource xares) throws XAException {
        try {
            boolean result = super.isSameRM(xares);
            this.log.log("isSameRM(" + xares + "): " + result);
            return result;
        }
        catch (XAException e) {
            this.log.error("failed to isSameRM(" + xares + "): ");
            throw e;
        }
    }

    public int prepare(Xid xid) throws XAException {
        try {
            int result = super.prepare(xid);
            this.log.log("prepare(" + xid + "): " + result);
            return result;
        }
        catch (XAException e) {
            this.log.error("failed to prepare(" + xid + "): ");
            throw e;
        }
    }

    public Xid[] recover(int flag) throws XAException {
        try {
            Xid[] result = super.recover(flag);
            this.log.log("recover(" + flag + "): " + result);
            return result;
        }
        catch (XAException e) {
            this.log.error("failed to recover(" + flag + "): ");
            throw e;
        }
    }

    public void rollback(Xid xid) throws XAException {
        try {
            super.rollback(xid);
            this.log.log("rollback(" + xid + ")");
        }
        catch (XAException e) {
            this.log.error("failed to rollback(" + xid + ")", e);
            throw e;
        }
    }

    public boolean setTransactionTimeout(int seconds) throws XAException {
        try {
            boolean result = super.setTransactionTimeout(seconds);
            this.log.log("setTransactionTimeout(" + seconds + "): " + result);
            return result;
        }
        catch (XAException e) {
            this.log.error("failed to setTransactionTimeout(" + seconds + "): ");
            throw e;
        }
    }

    public void start(Xid xid, int flags) throws XAException {
        try {
            super.start(xid, flags);
            this.log.log("start(" + xid + "," + flags + ")");
        }
        catch (XAException e) {
            this.log.error("failed to start(" + xid + "," + flags + ")", e);
            throw e;
        }
    }
}

