/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.jdbc.measure;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import org.asyrinx.brownie.core.log.MeasureLog;
import org.asyrinx.brownie.jdbc.measure.StatementMeasure;

public class PreparedStatementMeasure
extends StatementMeasure
implements PreparedStatement {
    private final PreparedStatement source;
    private final String keyName;

    public PreparedStatementMeasure(PreparedStatement source, Object key, MeasureLog measureLog) {
        super(source, measureLog);
        this.source = source;
        this.keyName = String.valueOf(key);
    }

    public PreparedStatementMeasure(PreparedStatement source, Object key) {
        this(source, key, null);
    }

    public void addBatch() throws SQLException {
        this.source.addBatch();
    }

    public void clearParameters() throws SQLException {
        this.source.clearParameters();
    }

    public boolean execute() throws SQLException {
        this.measureLog.reset();
        boolean result = this.source.execute();
        this.measureLog.done(this.keyName);
        return result;
    }

    public int executeUpdate() throws SQLException {
        this.measureLog.reset();
        int result = this.source.executeUpdate();
        this.measureLog.done(this.keyName);
        return result;
    }

    public ResultSet executeQuery() throws SQLException {
        this.measureLog.reset();
        ResultSet result = this.source.executeQuery();
        this.measureLog.done(this.keyName);
        return result;
    }

    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.source.setBigDecimal(parameterIndex, x);
    }

    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.source.setBoolean(parameterIndex, x);
    }

    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.source.setBytes(parameterIndex, x);
    }

    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.source.setDate(parameterIndex, x);
    }

    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        this.source.setDate(parameterIndex, x, cal);
    }

    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.source.setDouble(parameterIndex, x);
    }

    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.source.setFloat(parameterIndex, x);
    }

    public void setInt(int parameterIndex, int x) throws SQLException {
        this.source.setInt(parameterIndex, x);
    }

    public void setLong(int parameterIndex, long x) throws SQLException {
        this.source.setLong(parameterIndex, x);
    }

    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.source.setNull(parameterIndex, sqlType);
    }

    public void setNull(int paramIndex, int sqlType, String typeName) throws SQLException {
        this.source.setNull(paramIndex, sqlType, typeName);
    }

    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.source.setObject(parameterIndex, x);
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.source.setObject(parameterIndex, x, targetSqlType);
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType, int scale) throws SQLException {
        this.source.setObject(parameterIndex, x, targetSqlType, scale);
    }

    public void setShort(int parameterIndex, short x) throws SQLException {
        this.source.setShort(parameterIndex, x);
    }

    public void setString(int parameterIndex, String x) throws SQLException {
        this.source.setString(parameterIndex, x);
    }

    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.source.setTime(parameterIndex, x);
    }

    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        this.source.setTime(parameterIndex, x, cal);
    }

    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.source.setTimestamp(parameterIndex, x);
    }

    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.source.setTimestamp(parameterIndex, x, cal);
    }

    public void setArray(int i, Array x) throws SQLException {
        this.source.setArray(i, x);
    }

    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.source.setAsciiStream(parameterIndex, x, length);
    }

    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.source.setBinaryStream(parameterIndex, x, length);
    }

    public void setBlob(int i, Blob x) throws SQLException {
        this.source.setBlob(i, x);
    }

    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.source.setByte(parameterIndex, x);
    }

    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.source.setCharacterStream(parameterIndex, reader, length);
    }

    public void setClob(int i, Clob x) throws SQLException {
        this.source.setClob(i, x);
    }

    public void setRef(int i, Ref x) throws SQLException {
        this.source.setRef(i, x);
    }

    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return this.source.getMetaData();
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        return this.source.getParameterMetaData();
    }

    public void setURL(int parameterIndex, URL x) throws SQLException {
        this.source.setURL(parameterIndex, x);
    }
}

