/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.log.log4j;

import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.config.PropertySetter;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.helpers.OptionConverter;
import org.apache.log4j.or.RendererMap;
import org.apache.log4j.spi.Configurator;
import org.apache.log4j.spi.LoggerFactory;
import org.apache.log4j.spi.LoggerRepository;
import org.apache.log4j.spi.OptionHandler;
import org.apache.log4j.spi.RendererSupport;
import org.asyrinx.brownie.log.log4j.DefaultCategoryFactory;
import org.asyrinx.brownie.log.log4j.PropertyWatchdog;

public class PropertyConfigurator
implements Configurator {
    protected Hashtable registry = new Hashtable(11);
    protected LoggerFactory loggerFactory = new DefaultCategoryFactory();
    protected static final String CATEGORY_PREFIX = "log4j.category.";
    protected static final String LOGGER_PREFIX = "log4j.logger.";
    protected static final String FACTORY_PREFIX = "log4j.factory";
    protected static final String ADDITIVITY_PREFIX = "log4j.additivity.";
    protected static final String ROOT_CATEGORY_PREFIX = "log4j.rootCategory";
    protected static final String ROOT_LOGGER_PREFIX = "log4j.rootLogger";
    protected static final String APPENDER_PREFIX = "log4j.appender.";
    protected static final String RENDERER_PREFIX = "log4j.renderer.";
    protected static final String THRESHOLD_PREFIX = "log4j.threshold";
    public static final String LOGGER_FACTORY_KEY = "log4j.loggerFactory";
    private static final String INTERNAL_ROOT_NAME = "root";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public void doConfigure(String configFileName, LoggerRepository hierarchy) {
        Properties props = new Properties();
        try {
            FileInputStream istream = new FileInputStream(configFileName);
            props.load(istream);
            istream.close();
        }
        catch (IOException e) {
            LogLog.error((String)("Could not read configuration file [" + configFileName + "]."), (Throwable)e);
            LogLog.error((String)("Ignoring configuration file [" + configFileName + "]."));
            return;
        }
        this.doConfigure(props, hierarchy);
    }

    public static void configure(String configFilename) {
        new PropertyConfigurator().doConfigure(configFilename, LogManager.getLoggerRepository());
    }

    public static void configure(URL configURL) {
        new PropertyConfigurator().doConfigure(configURL, LogManager.getLoggerRepository());
    }

    public static void configure(Properties properties) {
        new PropertyConfigurator().doConfigure(properties, LogManager.getLoggerRepository());
    }

    public static void configureAndWatch(String configFilename) {
        PropertyConfigurator.configureAndWatch(configFilename, 60000L);
    }

    public static void configureAndWatch(String configFilename, long delay) {
        PropertyWatchdog pdog = new PropertyWatchdog(configFilename);
        pdog.setDelay(delay);
        pdog.start();
    }

    public void doConfigure(Properties properties, LoggerRepository hierarchy) {
        String thresholdStr;
        String value = properties.getProperty("log4j.debug");
        if (value == null && (value = properties.getProperty("log4j.configDebug")) != null) {
            LogLog.warn((String)"[log4j.configDebug] is deprecated. Use [log4j.debug] instead.");
        }
        if (value != null) {
            LogLog.setInternalDebugging((boolean)OptionConverter.toBoolean((String)value, (boolean)true));
        }
        if ((thresholdStr = OptionConverter.findAndSubst((String)THRESHOLD_PREFIX, (Properties)properties)) != null) {
            hierarchy.setThreshold(OptionConverter.toLevel((String)thresholdStr, (Level)Level.ALL));
            LogLog.debug((String)("Hierarchy threshold set to [" + hierarchy.getThreshold() + "]."));
        }
        this.configureRootCategory(properties, hierarchy);
        this.configureLoggerFactory(properties);
        this.parseCatsAndRenderers(properties, hierarchy);
        LogLog.debug((String)"Finished configuring.");
        this.registry.clear();
    }

    public void doConfigure(URL configURL, LoggerRepository hierarchy) {
        Properties props = new Properties();
        LogLog.debug((String)("Reading configuration from URL " + configURL));
        try {
            props.load(configURL.openStream());
        }
        catch (IOException e) {
            LogLog.error((String)("Could not read configuration file from URL [" + configURL + "]."), (Throwable)e);
            LogLog.error((String)("Ignoring configuration file [" + configURL + "]."));
            return;
        }
        this.doConfigure(props, hierarchy);
    }

    protected void configureLoggerFactory(Properties props) {
        String factoryClassName = OptionConverter.findAndSubst((String)LOGGER_FACTORY_KEY, (Properties)props);
        if (factoryClassName != null) {
            LogLog.debug((String)("Setting category factory to [" + factoryClassName + "]."));
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.apache.log4j.spi.LoggerFactory");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.loggerFactory = (LoggerFactory)OptionConverter.instantiateByClassName((String)factoryClassName, (Class)clazz, (Object)this.loggerFactory);
            PropertySetter.setProperties((Object)this.loggerFactory, (Properties)props, (String)"log4j.factory.");
        }
    }

    protected void configureRootCategory(Properties props, LoggerRepository hierarchy) {
        String effectiveFrefix = ROOT_LOGGER_PREFIX;
        String value = OptionConverter.findAndSubst((String)ROOT_LOGGER_PREFIX, (Properties)props);
        if (value == null) {
            value = OptionConverter.findAndSubst((String)ROOT_CATEGORY_PREFIX, (Properties)props);
            effectiveFrefix = ROOT_CATEGORY_PREFIX;
        }
        if (value == null) {
            LogLog.debug((String)"Could not find root logger information. Is this OK?");
        } else {
            Logger root;
            Logger logger = root = hierarchy.getRootLogger();
            synchronized (logger) {
                this.parseCategory(props, root, effectiveFrefix, INTERNAL_ROOT_NAME, value);
            }
        }
    }

    protected void parseCatsAndRenderers(Properties props, LoggerRepository hierarchy) {
        Enumeration<?> enumeration = props.propertyNames();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            if (key.startsWith(CATEGORY_PREFIX) || key.startsWith(LOGGER_PREFIX)) {
                Logger logger;
                String loggerName = null;
                if (key.startsWith(CATEGORY_PREFIX)) {
                    loggerName = key.substring(CATEGORY_PREFIX.length());
                } else if (key.startsWith(LOGGER_PREFIX)) {
                    loggerName = key.substring(LOGGER_PREFIX.length());
                }
                String value = OptionConverter.findAndSubst((String)key, (Properties)props);
                Logger logger2 = logger = hierarchy.getLogger(loggerName, this.loggerFactory);
                synchronized (logger2) {
                    this.parseCategory(props, logger, key, loggerName, value);
                    this.parseAdditivityForLogger(props, logger, loggerName);
                    continue;
                }
            }
            if (!key.startsWith(RENDERER_PREFIX)) continue;
            String renderedClass = key.substring(RENDERER_PREFIX.length());
            String renderingClass = OptionConverter.findAndSubst((String)key, (Properties)props);
            if (!(hierarchy instanceof RendererSupport)) continue;
            RendererMap.addRenderer((RendererSupport)((RendererSupport)hierarchy), (String)renderedClass, (String)renderingClass);
        }
    }

    protected void parseAdditivityForLogger(Properties props, Logger cat, String loggerName) {
        String value = OptionConverter.findAndSubst((String)(ADDITIVITY_PREFIX + loggerName), (Properties)props);
        LogLog.debug((String)("Handling log4j.additivity." + loggerName + "=[" + value + "]"));
        if (value != null && !value.equals("")) {
            boolean additivity = OptionConverter.toBoolean((String)value, (boolean)true);
            LogLog.debug((String)("Setting additivity for \"" + loggerName + "\" to " + additivity));
            cat.setAdditivity(additivity);
        }
    }

    protected void parseCategory(Properties props, Logger logger, String optionKey, String loggerName, String value) {
        LogLog.debug((String)("Parsing for [" + loggerName + "] with value=[" + value + "]."));
        StringTokenizer st = new StringTokenizer(value, ",");
        if (!value.startsWith(",") && !value.equals("")) {
            if (!st.hasMoreTokens()) {
                return;
            }
            String levelStr = st.nextToken();
            LogLog.debug((String)("Level token is [" + levelStr + "]."));
            if ("inherited".equalsIgnoreCase(levelStr) || "null".equalsIgnoreCase(levelStr)) {
                if (loggerName.equals(INTERNAL_ROOT_NAME)) {
                    LogLog.warn((String)"The root logger cannot be set to null.");
                } else {
                    logger.setLevel(null);
                }
            } else {
                logger.setLevel(OptionConverter.toLevel((String)levelStr, (Level)Level.DEBUG));
            }
            LogLog.debug((String)("Category " + loggerName + " set to " + logger.getLevel()));
        }
        logger.removeAllAppenders();
        while (st.hasMoreTokens()) {
            String appenderName = st.nextToken().trim();
            if (appenderName == null || appenderName.equals(",")) continue;
            LogLog.debug((String)("Parsing appender named \"" + appenderName + "\"."));
            Appender appender = this.parseAppender(props, appenderName);
            if (appender == null) continue;
            logger.addAppender(appender);
        }
    }

    protected Appender parseAppender(Properties props, String appenderName) {
        Appender appender = this.registryGet(appenderName);
        if (appender != null) {
            LogLog.debug((String)("Appender \"" + appenderName + "\" was already parsed."));
            return appender;
        }
        String prefix = APPENDER_PREFIX + appenderName;
        String layoutPrefix = String.valueOf(prefix) + ".layout";
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.apache.log4j.Appender");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((appender = (Appender)OptionConverter.instantiateByKey((Properties)props, (String)prefix, (Class)clazz, null)) == null) {
            LogLog.error((String)("Could not instantiate appender named \"" + appenderName + "\"."));
            return null;
        }
        appender.setName(appenderName);
        if (appender instanceof OptionHandler) {
            if (appender.requiresLayout()) {
                Layout layout;
                Class<?> clazz2 = class$2;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$2 = Class.forName("org.apache.log4j.Layout");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((layout = (Layout)OptionConverter.instantiateByKey((Properties)props, (String)layoutPrefix, (Class)clazz2, null)) != null) {
                    appender.setLayout(layout);
                    LogLog.debug((String)("Parsing layout options for \"" + appenderName + "\"."));
                    PropertySetter.setProperties((Object)layout, (Properties)props, (String)(String.valueOf(layoutPrefix) + "."));
                    LogLog.debug((String)("End of parsing for \"" + appenderName + "\"."));
                }
            }
            PropertySetter.setProperties((Object)appender, (Properties)props, (String)(String.valueOf(prefix) + "."));
            LogLog.debug((String)("Parsed \"" + appenderName + "\" options."));
        }
        this.registryPut(appender);
        return appender;
    }

    protected final void registryPut(Appender appender) {
        this.registry.put(appender.getName(), appender);
    }

    protected final Appender registryGet(String name) {
        return (Appender)this.registry.get(name);
    }
}

