/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.swing.table;

import javax.swing.table.TableModel;
import org.asyrinx.brownie.swing.table.util.InvisibleColumnTableModel;
import org.asyrinx.brownie.swing.table.wrapper.TableModelWrapper;

class InvisibleColumnTableModelImpl
extends TableModelWrapper
implements InvisibleColumnTableModel {
    private final int invisibleColumnIndex;
    private final int invisibleColumnCount;

    public InvisibleColumnTableModelImpl(TableModel model, int invisibleColumnIndex, int invisibleColumnCount) {
        super(model);
        this.invisibleColumnIndex = invisibleColumnIndex;
        this.invisibleColumnCount = invisibleColumnCount;
    }

    public int getColumnCount() {
        return this.model.getColumnCount() - this.invisibleColumnCount;
    }

    public int getOriginalColumnIndex(int columnIndex) {
        return columnIndex < this.invisibleColumnIndex ? columnIndex : columnIndex + this.invisibleColumnCount;
    }

    public String getColumnName(int columnIndex) {
        return this.model.getColumnName(this.getOriginalColumnIndex(columnIndex));
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.model.getValueAt(rowIndex, this.getOriginalColumnIndex(columnIndex));
    }
}

