/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.swing.table.calc;

import java.util.HashMap;
import java.util.Map;
import javax.swing.table.TableModel;
import org.apache.commons.lang.StringUtils;
import org.asyrinx.brownie.core.collection.calc.Calculation;
import org.asyrinx.brownie.core.lang.NumberUtils;
import org.asyrinx.brownie.swing.table.key.AbstractColumn;
import org.asyrinx.brownie.swing.table.key.Column;
import org.asyrinx.brownie.swing.table.key.RowKey;
import org.asyrinx.brownie.swing.table.key.RowKeyContainer;

public class CalcColumnImpl
extends AbstractColumn
implements Column {
    private final String name;
    private final Calculation calculation;
    private static final Map calcNames = CalcColumnImpl.initCalcNames();
    static /* synthetic */ Class class$0;

    public CalcColumnImpl(int originalColumnIndex, TableModel tableModel, RowKeyContainer keyContainer, Calculation calculation, String name) {
        super(originalColumnIndex, tableModel, keyContainer);
        this.calculation = calculation;
        this.name = name;
    }

    private static Map initCalcNames() {
        HashMap<Calculation, String> result = new HashMap<Calculation, String>();
        result.put(Calculation.SUMMARY, "sum");
        result.put(Calculation.COUNT, "count");
        result.put(Calculation.AVERAGE, "average");
        result.put(Calculation.MIN, "min");
        result.put(Calculation.MAX, "max");
        return result;
    }

    public Calculation getCalculation() {
        return this.calculation;
    }

    public Class getColumnClass() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.Number");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    public String getColumnName() {
        if (!StringUtils.isEmpty((String)this.name)) {
            return this.name;
        }
        Object calcName = calcNames.get(this.calculation);
        String result = this.tableModel.getColumnName(this.getOriginalColumnIndex());
        return calcName == null ? result : calcName + "(" + result + ")";
    }

    public Object getValueAt(int rowIndex) {
        RowKey key = this.keyContainer.getKey(rowIndex);
        int[] targetKeyRowIndexes = key.getTargetKeyIndexes();
        Number[] values = new Number[targetKeyRowIndexes.length];
        int i = 0;
        while (i < targetKeyRowIndexes.length) {
            int row = targetKeyRowIndexes[i];
            values[i] = NumberUtils.toNumber(this.tableModel.getValueAt(row, this.getOriginalColumnIndex()));
            ++i;
        }
        return this.getCalculation().calculate(values);
    }
}

