/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2004/01/12
 */
package org.asyrinx.brownie.torque.om;

import org.apache.commons.lang.exception.NestableRuntimeException;
import org.apache.torque.TorqueException;
import org.apache.torque.om.BaseObject;
import org.asyrinx.brownie.core.lang.ClassUtils;
import org.asyrinx.brownie.torque.om.IModifyRecorder.ModifyType;

/**
 * @author akima
 */
public class ModifyRecorder {

	/**
	 * 
	 */
	public ModifyRecorder() {
		super();
	}

	public static void record(BaseObject object, ModifyType type)
		throws TorqueException {
		IModifyRecorder recorder = getRecorder(object);
		if (recorder != null) {
			recorder.record(object, type);
		}
	}
	public static IModifyRecorder getRecorder(BaseObject object) {
		if (recorder == null)
			recorder = find(object);
		return recorder;
	}

	private static IModifyRecorder recorder = null;

	private static IModifyRecorder find(BaseObject object) {
		final String packageName = object.getClass().getPackage().getName();
		IModifyRecorder recorder;
		try {
			Class recorderClass = Class.forName(packageName + ".Recorder");
			try {
				recorder =
					(IModifyRecorder) ClassUtils.newObject(
						recorderClass,
						ModifyRecorder.class);
			} catch (InstantiationException e) {
				throw new NestableRuntimeException(e);
			}
		} catch (ClassNotFoundException e) {
			recorder = new DummyModifyRecorder();
		}
		return recorder;
	}
}
