/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2003/11/23
 */
package org.asyrinx.brownie.torque.util;

import java.sql.Date;
import java.util.List;

import org.apache.torque.TorqueException;
import org.apache.torque.util.BasePeer;

import com.workingdogs.village.DataSetException;
import com.workingdogs.village.Record;
import com.workingdogs.village.Value;

/**
 * @author akima
 */
public final class PeerUtils {

	/**
	 * 
	 */
	public PeerUtils() {
		super();
	}

	public static Date getServerDate() throws TorqueException {
		final List result =
			BasePeer.executeQuery("select timenow() as servertime");
		if (result.isEmpty()) {
			throw new TorqueException("failed to get setver time");
		} else {
			final Record record = (Record) result.get(0);
			try {
				Value value = record.getValue(1);
				return new Date(value.asDate().getTime());
			} catch (DataSetException e) {
				throw new TorqueException(e);
			}
		}
	}

}
