/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2004/02/27
 */
package org.asyrinx.joey.om.hibernate;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.asyrinx.brownie.core.lang.ArrayUtils;
import org.asyrinx.brownie.core.lang.UnsupportedClassRuntimeException;

/**
 * @author akima
 */
public abstract class AbstractHibernateTranslator {

	/**
	 * 
	 */
	public AbstractHibernateTranslator(
		Map columnToProperty,
		Map tableToClass) {
		super();
		this.columnToProperty = columnToProperty;
		this.tableToClass = tableToClass;
	}

	/**
	 * 
	 */
	public AbstractHibernateTranslator(
		Map columnToProperty,
		Map tableToClass,
		boolean usePropertyInCondition) {
		super();
		this.columnToProperty = columnToProperty;
		this.tableToClass = tableToClass;
		this.usePropertyInCondition = usePropertyInCondition;
	}

	private boolean usePropertyInCondition = false;
	protected final Map columnToProperty;
	protected final Map tableToClass;

	protected String toClass(String tableName) {
		final String result = String.valueOf(tableToClass.get(tableName));
		return StringUtils.isEmpty(result) ? tableName : result;
	}

	protected String toFieldName(String columnName) {
		if (this.isUsePropertyInCondition()) {
			final String result =
				String.valueOf(columnToProperty.get(columnName));
			return StringUtils.isEmpty(result) ? columnName : result;
		} else {
			final int idx = columnName.indexOf('.');
			return (idx > -1) ? columnName.substring(idx + 1) : columnName;
		}
	}

	protected final Log log = LogFactory.getLog(this.getClass());

	/**
	 * @return
	 */
	public boolean isUsePropertyInCondition() {
		return usePropertyInCondition;
	}

	/**
	 * @param b
	 */
	public void setUsePropertyInCondition(boolean b) {
		usePropertyInCondition = b;
	}

	protected final Object toNumber(Object value, Class numberClass) {
		if (value == null)
			return null;
		if (value instanceof Number)
			return (Number) value;
		else if (value.getClass().isArray()) {
			if (value.getClass().getComponentType().isPrimitive())
				value = ArrayUtils.toObjectArray(value);
			if (Number
				.class
				.isAssignableFrom(value.getClass().getComponentType())) {
				return value;
			} else {
				final Object[] objects = (Object[]) value;
				final Object[] result = new Object[objects.length];
				for (int i = 0; i < objects.length; i++) {
					result[i] = toNumber(objects[i], numberClass);
				}
				return result;
			}
		} else if (value instanceof Collection) {
			final Collection result;
			if (value instanceof Set)
				result = new HashSet();
			else
				result = new ArrayList();
			final Iterator iterator = ((Collection) value).iterator();
			while (iterator.hasNext()) {
				result.add(toNumber(iterator.next(), numberClass));
			}
			return result;
		} else if (value instanceof String) {
			final String strValue = (String) value;
			if (StringUtils.isEmpty(strValue))
				return null;
			if (numberClass == Byte.class)
				return new Byte(strValue);
			else if (numberClass == Short.class)
				return new Short(strValue);
			else if (numberClass == Integer.class)
				return new Integer(strValue);
			else if (numberClass == Long.class)
				return new Long(strValue);
			else if (numberClass == BigInteger.class)
				return new BigInteger(strValue);
			else if (numberClass == Float.class)
				return new Float(strValue);
			else if (numberClass == Double.class)
				return new Double(strValue);
			else
				return new Long(strValue);
		} else {
			throw new UnsupportedClassRuntimeException(
				"cannot convert to Number: " + value.getClass().getName());
		}
	}

}
