/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2003/12/29
 */
package org.asyrinx.joey.tapestry.components.stative;

import java.util.ArrayList;
import java.util.List;

import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.form.IPropertySelectionModel;
import org.apache.tapestry.form.StringPropertySelectionModel;
import org.asyrinx.joey.om.SearchCondition;

/**
 * @author akima
 */
public abstract class BaseListPage extends EditablePage {

	/**
	 * 
	 */
	public BaseListPage() {
		super();
	}

	public static IPropertySelectionModel MAX_RECORD_COUNT_OPTIONS =
		new StringPropertySelectionModel(
			new String[] { "10", "20", "30", "50", "100", });

	private String maxRecordCount = "10";

	/**
	 * @return
	 */
	public String getMaxRecordCount() {
		return maxRecordCount;
	}

	/**
	 * @param integer
	 */
	public void setMaxRecordCount(String integer) {
		maxRecordCount = integer;
	}

	private List objects = new ArrayList();

	/**
	 * @return
	 */
	public List getObjects() {
		return objects;
	}

	abstract public SearchCondition getWayToSearch();
	abstract public void setWayToSearch(SearchCondition condition);

	abstract public void selectObj(IRequestCycle cycle);
	abstract public void createObj(IRequestCycle cycle);
	abstract public void deleteObj(IRequestCycle cycle);

	abstract public void search(IRequestCycle cycle);
}
