/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2004/01/12
 */
package org.asyrinx.joey.tapestry.components.stative;

import org.apache.tapestry.ApplicationRuntimeException;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.IRequestCycle;
import org.asyrinx.brownie.core.user.IUser;
import org.asyrinx.brownie.core.user.LoginManager;

/**
 * @author akima
 */
public abstract class LoginForm extends BaseComponent {

	private String userId = null;
	private String password = null;

	public void formSubmit(IRequestCycle cycle) {
		final LoginManager loginManager =
			new LoginManager(this.getUserCertifierClassName());
		final IUser user = loginManager.tryLogin(getUserId(), getPassword());
		if (cycle.getPage().getVisit() instanceof BaseVisit) {
			final BaseVisit visit = (BaseVisit) cycle.getPage().getVisit();
			visit.setLoginUser(user);
		} else {
			throw new ApplicationRuntimeException("Visit must be extended BaseVisit");
		}
		cycle.activate(getPage());
	}

	/**
	 * @return
	 */
	public String getPassword() {
		return password;
	}

	/**
	 * @return
	 */
	public String getUserId() {
		return userId;
	}

	/**
	 * @param string
	 */
	public void setPassword(String string) {
		password = string;
	}

	/**
	 * @param string
	 */
	public void setUserId(String string) {
		userId = string;
	}

	abstract public String getUserCertifierClassName();
	abstract public void setUserCertifierClassName(String string);

}
