/*
 * Decompiled with CFR 0.152.
 */
package jongs;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import jongs.jongsDisplayManagement;
import jongs.jongsSound;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JongScripter
extends Thread {
    public static final String CMD_file = "command.conf";
    public static final String FIRST_script = "script00.txt";
    public static final int LGK_and = 1;
    public static final int LGK_or = 2;
    public static final int TYPE_int = 100;
    public static final int TYPE_str = 200;
    public static final int CMD_if = 1001;
    public static final int CMD_else = 1002;
    public static final int CMD_while = 1003;
    public static final int CMD_for = 1004;
    public static final int CMD_goto = 1005;
    public static final int CMD_gosub = 1006;
    public static final int CMD_return = 1007;
    public static final int CMD_begin = 1008;
    public static final int CMD_end = 1009;
    public static final int CMD_set = 1010;
    public static final int CMD_text = 1011;
    public static final int CMD_exit = 1012;
    public static final int CMD_input = 1013;
    public static final int CMD_switch = 1014;
    public static final int CMD_case = 1015;
    public static final int CMD_label = 1016;
    public static final int CMD_break = 1017;
    public static final int CMD_continue = 1018;
    public static final int CMD_debug = 1019;
    public static final int CMD_goScript = 1020;
    public static final int CMD_display = 1021;
    public static final int CMD_WaitText = 1022;
    public static final int CMD_setCellNumber = 2001;
    public static final int CMD_setCellImage = 2002;
    public static final int CMD_setCellPosition = 2003;
    public static final int CMD_setCellSize = 2004;
    public static final int CMD_setCellTransColor = 2005;
    public static final int CMD_setCellFlag = 2006;
    public static final int CMD_viewDisplay = 2007;
    public static final int CMD_transitionDisplay = 2008;
    public static final int CMD_setDisplaySize = 2009;
    public static final int CMD_wait = 2010;
    public static final int CMD_setFontColor = 2011;
    public static final int CMD_setFont = 2012;
    public static final int CMD_setTextArea = 2013;
    public static final int CMD_select = 2014;
    public static final int CMD_setSelectArea = 2015;
    public static final int CMD_setSelectColor = 2016;
    public static final int CMD_midiPlay = 2017;
    public static final int CMD_midiLoad = 2018;
    public static final int CMD_midiStop = 2019;
    public static final int CMD_audioPlay = 2020;
    public static final int CMD_audioLoop = 2021;
    public static final int CMD_audioStop = 2022;
    public static final int CMD_setWaitTime = 2023;
    public static final int CMD_cellClick = 2024;
    Vector<Vector<String>> scriptParams;
    Vector<int[]> scriptCode;
    int scriptPointer;
    HashMap<String, int[]> typeMap;
    HashMap<String, int[]> basicMap;
    HashMap<String, int[]> cmdMap;
    HashMap<String, int[]> labelMap;
    HashMap<String, Object> varIntMap;
    HashMap<String, Object> varStrMap;
    Stack<int[]> parStack;
    Stack<int[]> subroutineStack;
    int th_wtime;
    int debug;
    String Text;
    BufferedReader bread = new BufferedReader(new InputStreamReader(System.in));
    String now_Line;
    jongsDisplayManagement dmng;
    jongsSound sound;

    public JongScripter() {
        super("JONGS");
        this.varIntMap = new HashMap();
        this.varStrMap = new HashMap();
        this.initBasicCode();
        this.initCommandCode();
        this.th_wtime = 0;
        this.debug = 0;
        this.Text = "";
        this.sound = new jongsSound();
    }

    private void initBasicCode() {
        this.typeMap = new HashMap();
        this.typeMap.put("int", this.getIntArray(100));
        this.typeMap.put("integer", this.getIntArray(100));
        this.typeMap.put("str", this.getIntArray(200));
        this.typeMap.put("string", this.getIntArray(200));
        this.basicMap = new HashMap();
        this.basicMap.put("if", this.getIntArray(1001));
        this.basicMap.put("else", this.getIntArray(1002));
        this.basicMap.put("while", this.getIntArray(1003));
        this.basicMap.put("for", this.getIntArray(1004));
        this.basicMap.put("goto", this.getIntArray(1005));
        this.basicMap.put("gosub", this.getIntArray(1006));
        this.basicMap.put("return", this.getIntArray(1007));
        this.basicMap.put("begin", this.getIntArray(1008));
        this.basicMap.put("end", this.getIntArray(1009));
        this.basicMap.put("set", this.getIntArray(1010));
        this.basicMap.put("text", this.getIntArray(1011));
        this.basicMap.put("exit", this.getIntArray(1012));
        this.basicMap.put("input", this.getIntArray(1013));
        this.basicMap.put("switch", this.getIntArray(1014));
        this.basicMap.put("case", this.getIntArray(1015));
        this.basicMap.put("label", this.getIntArray(1016));
        this.basicMap.put("break", this.getIntArray(1017));
        this.basicMap.put("continue", this.getIntArray(1018));
        this.basicMap.put("debug", this.getIntArray(1019));
        this.basicMap.put("goscript", this.getIntArray(1020));
        this.basicMap.put("display", this.getIntArray(1021));
        this.basicMap.put("waittext", this.getIntArray(1022));
    }

    private void initCommandCode() {
        this.cmdMap = new HashMap();
        this.cmdMap.put("setcellnumber", this.getIntArray(2001));
        this.cmdMap.put("setcellimage", this.getIntArray(2002));
        this.cmdMap.put("setcellposition", this.getIntArray(2003));
        this.cmdMap.put("setcellsize", this.getIntArray(2004));
        this.cmdMap.put("setcelltranscolor", this.getIntArray(2005));
        this.cmdMap.put("setcellflag", this.getIntArray(2006));
        this.cmdMap.put("viewdisplay", this.getIntArray(2007));
        this.cmdMap.put("transitiondisplay", this.getIntArray(2008));
        this.cmdMap.put("showimage", this.getIntArray(2007));
        this.cmdMap.put("setdisplaysize", this.getIntArray(2009));
        this.cmdMap.put("wait", this.getIntArray(2010));
        this.cmdMap.put("setfontcolor", this.getIntArray(2011));
        this.cmdMap.put("settextfont", this.getIntArray(2012));
        this.cmdMap.put("setfont", this.getIntArray(2012));
        this.cmdMap.put("settextarea", this.getIntArray(2013));
        this.cmdMap.put("select", this.getIntArray(2014));
        this.cmdMap.put("setselectarea", this.getIntArray(2015));
        this.cmdMap.put("setselectcolor", this.getIntArray(2016));
        this.cmdMap.put("midiload", this.getIntArray(2018));
        this.cmdMap.put("midiplay", this.getIntArray(2017));
        this.cmdMap.put("midistop", this.getIntArray(2019));
        this.cmdMap.put("audioloop", this.getIntArray(2021));
        this.cmdMap.put("audioplay", this.getIntArray(2020));
        this.cmdMap.put("audiostop", this.getIntArray(2022));
        this.cmdMap.put("soundloop", this.getIntArray(2021));
        this.cmdMap.put("soundplay", this.getIntArray(2020));
        this.cmdMap.put("soundstop", this.getIntArray(2022));
        this.cmdMap.put("setwaittime", this.getIntArray(2023));
        this.cmdMap.put("cellclick", this.getIntArray(2024));
    }

    public void getScript(String scfile, String txtcode) {
        Vector<String> vct0;
        int bpos;
        int code;
        this.scriptParams = new Vector();
        this.scriptCode = new Vector();
        this.scriptPointer = 0;
        this.labelMap = new HashMap();
        this.parStack = new Stack();
        this.subroutineStack = new Stack();
        try {
            String line;
            FileInputStream fis = new FileInputStream("./" + scfile);
            System.out.println("JONGS GetScript:./" + scfile + ":CODE:" + txtcode);
            InputStreamReader isr = new InputStreamReader((InputStream)fis, txtcode);
            BufferedReader br = new BufferedReader(isr);
            while ((line = br.readLine()) != null) {
                if ((line = line.trim()).length() == 0) continue;
                this.setScriptOneLine(line);
            }
            isr.close();
            fis.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        int pos = 0;
        while (pos < this.scriptCode.size()) {
            code = this.scriptCode.get(pos)[0];
            switch (code) {
                case 1001: 
                case 1002: 
                case 1003: 
                case 1004: {
                    bpos = pos + 1;
                    if (bpos == this.scriptCode.size() || (code = this.scriptCode.get(bpos)[0]) == 1008) break;
                    this.scriptCode.add(pos + 2, this.getIntArray(1009));
                    vct0 = new Vector();
                    vct0.add("end");
                    this.scriptParams.add(pos + 2, vct0);
                    this.scriptCode.add(pos + 1, this.getIntArray(1008));
                    vct0 = new Vector();
                    vct0.add("begin");
                    this.scriptParams.add(pos + 1, vct0);
                    break;
                }
            }
            ++pos;
        }
        pos = 0;
        while (pos < this.scriptCode.size()) {
            String label;
            code = this.scriptCode.get(pos)[0];
            if (code == 1016 && (label = (vct0 = this.scriptParams.get(pos)).get(1)).length() > 0) {
                if (this.labelMap.containsKey(label)) {
                    this.Error(8, "\u30e9\u30d9\u30eb[" + label + "]\u304c\u91cd\u8907\u3057\u3066\u3044\u307e\u3059\u3002");
                }
                this.labelMap.put(label, this.getIntArray(pos));
            }
            ++pos;
        }
        this.parStack.clear();
        pos = 0;
        while (pos < this.scriptCode.size()) {
            code = this.scriptCode.get(pos)[0];
            if (code == 1008) {
                this.parStack.push(this.getIntArray(pos));
            } else if (code == 1009) {
                if (this.parStack.size() == 0) {
                    this.Error(8, "\u30b9\u30af\u30ea\u30d7\u30c8\u306e\uff5b\uff5d\u306e\u5bfe\u5fdc\u304c\u3068\u308c\u3066\u3044\u307e\u305b\u3093\u3001\uff5d\u304c\u591a\u3044\u3088\u3046\u3067\u3059");
                }
                bpos = this.parStack.pop()[0];
                int epos = pos;
                int funcpos = bpos - 1;
                if (funcpos < 0) {
                    this.Error(8, "\uff5b\uff5d\u306e\u8a18\u8ff0\u4f4d\u7f6e\u304c\u4e0d\u6b63\u3067\u3059");
                }
                Vector<String> vct1 = this.scriptParams.get(bpos);
                vct1.add(Integer.toString(epos));
                Vector<String> vct2 = this.scriptParams.get(epos);
                vct2.add(Integer.toString(bpos));
                vct0 = this.scriptParams.get(funcpos);
                int fcode = this.scriptCode.get(funcpos)[0];
                vct1.add(vct0.get(0));
                vct2.add(vct0.get(0));
                if (fcode == 1003) {
                    if (vct0.size() < 2) {
                        this.Error(8, "WHILE\u6587\u306e\u69cb\u6587\u306b\u8aa4\u308a\u304c\u3042\u308a\u307e\u3059\u3002");
                    }
                    vct2.add(vct0.get(1));
                } else if (fcode == 1004) {
                    if (vct0.size() < 4) {
                        this.Error(8, "FOR\u6587\u306e\u69cb\u6587\u306b\u8aa4\u308a\u304c\u3042\u308a\u307e\u3059\u3002");
                    }
                    vct2.add(vct0.get(2));
                    vct2.add(vct0.get(3));
                }
            }
            ++pos;
        }
        if (this.parStack.size() > 0) {
            this.scriptPointer = this.parStack.pop()[0];
            this.Error(8, "\u30b9\u30af\u30ea\u30d7\u30c8\u306e\uff5b\uff5d\u306e\u5bfe\u5fdc\u304c\u3068\u308c\u3066\u3044\u307e\u305b\u3093\u3002}\u304c\u4e0d\u8db3\u3067\u3059");
        }
    }

    private void setScriptOneLine(String ln) {
        int pos1;
        String token1;
        int pos2;
        int pos;
        String line;
        this.now_Line = line = ln.trim();
        if (line.length() == 0) {
            return;
        }
        int rpos = line.indexOf("//");
        if (rpos >= 0) {
            line = line.substring(0, rpos);
            if ((line = line.trim()).length() == 0) {
                return;
            }
        }
        if ((pos = line.indexOf(58)) > 0) {
            String label = line.substring(0, pos).trim();
            pos2 = label.indexOf(32);
            if (pos2 < 0) {
                pos2 = label.indexOf(9);
            }
            if (pos2 > 0) {
                token1 = label.substring(0, pos2).toLowerCase();
                if (this.basicMap.get(token1)[0] == 1015) {
                    String token2 = label.substring(pos2).trim();
                    this.scriptCode.add(this.basicMap.get(token1));
                    this.scriptParams.add(this.getParams(String.valueOf(token1) + "," + token2));
                    line = line.substring(pos + 1).trim();
                    if (line.length() > 0) {
                        this.setScriptOneLine(line);
                    }
                    return;
                }
                this.Error(16, "\u30e9\u30d9\u30eb\u306b\u7a7a\u767d\u3084TAB\u306e\u542b\u307e\u308c\u308b\u6587\u5b57\u3092\u4f7f\u7528\u3067\u304d\u307e\u305b\u3093[" + line + "]");
            } else {
                String token12 = "label";
                String token2 = line.substring(0, pos).trim();
                this.scriptCode.add(this.basicMap.get(token12));
                this.scriptParams.add(this.getParams(String.valueOf(token12) + "," + token2));
                line = line.substring(pos + 1).trim();
                if (line.length() > 0) {
                    this.setScriptOneLine(line);
                }
                return;
            }
        }
        if (line.charAt(0) == '{') {
            token1 = "begin";
            this.scriptCode.add(this.basicMap.get(token1));
            Vector<String> vc = new Vector<String>();
            vc.add(token1);
            this.scriptParams.add(vc);
            line = line.substring(1).trim();
            if (line.length() > 0) {
                this.setScriptOneLine(line);
            }
            return;
        }
        if (line.charAt(0) == '}') {
            token1 = "end";
            this.scriptCode.add(this.basicMap.get(token1));
            Vector<String> vc = new Vector<String>();
            vc.add(token1);
            this.scriptParams.add(vc);
            line = line.substring(1).trim();
            if (line.length() > 0) {
                this.setScriptOneLine(line);
            }
            return;
        }
        pos = line.indexOf(32);
        if (pos < 0) {
            pos = line.indexOf(9);
        }
        pos2 = line.indexOf(40);
        if (pos > 0 && (pos2 < 0 || pos < pos2)) {
            int[] bcode;
            token1 = line.substring(0, pos).trim().toLowerCase();
            if (this.typeMap.containsKey(token1)) {
                String token2 = line.substring(pos).trim().toLowerCase();
                this.VarResist(token2, this.typeMap.get(token1)[0]);
                return;
            }
            if (this.basicMap.containsKey(token1) && (bcode = this.basicMap.get(token1))[0] == 1002) {
                this.scriptCode.add(bcode);
                this.scriptParams.add(this.getParams(token1));
                String token3 = line.substring(pos).trim();
                if (token3.length() > 0) {
                    this.setScriptOneLine(token3);
                }
                return;
            }
        }
        if ((pos1 = line.indexOf(40)) > 0) {
            token1 = line.substring(0, pos1).trim().toLowerCase();
            pos2 = this.ParenthesesIndexOf(line, pos1, '(', ')');
            String token2 = line.substring(pos1 + 1, pos2);
            if (this.basicMap.containsKey(token1)) {
                String token3;
                this.scriptCode.add(this.basicMap.get(token1));
                this.scriptParams.add(this.getParams(String.valueOf(token1) + "," + token2));
                if (pos2 > 0 && pos2 < line.length() && (token3 = line.substring(pos2 + 1).trim()).length() > 0) {
                    this.setScriptOneLine(token3);
                }
                return;
            }
            if (this.cmdMap.containsKey(token1)) {
                this.scriptCode.add(this.cmdMap.get(token1));
                this.scriptParams.add(this.getParams(String.valueOf(token1) + "," + token2));
                return;
            }
        } else {
            pos1 = line.indexOf(123);
            if (pos1 < 0) {
                pos1 = line.length();
            }
            if (this.basicMap.containsKey(token1 = line.substring(0, pos1).trim().toLowerCase())) {
                String token3;
                this.scriptCode.add(this.basicMap.get(token1));
                this.scriptParams.add(this.getParams(token1));
                if (pos1 > 0 && pos1 < line.length() && (token3 = line.substring(pos1).trim()).length() > 0) {
                    this.setScriptOneLine(token3);
                }
                return;
            }
        }
        if (this.isSubstitution(line)) {
            token1 = "set";
            this.scriptCode.add(this.basicMap.get(token1));
            Vector<String> vc = new Vector<String>();
            vc.add(token1);
            vc.add(line);
            this.scriptParams.add(vc);
        } else {
            token1 = "text";
            this.scriptCode.add(this.basicMap.get(token1));
            Vector<String> vc = new Vector<String>();
            vc.add(token1);
            vc.add(line);
            this.scriptParams.add(vc);
        }
    }

    private boolean isSubstitution(String line) {
        int pos0 = line.indexOf(61);
        if (pos0 < 0) {
            pos0 = line.indexOf("++");
        }
        if (pos0 < 0) {
            pos0 = line.indexOf("--");
        }
        if (pos0 < 0) {
            pos0 = line.indexOf("+=");
        }
        if (pos0 < 0) {
            pos0 = line.indexOf("-=");
        }
        if (pos0 < 0) {
            pos0 = line.indexOf("*=");
        }
        if (pos0 < 0) {
            pos0 = line.indexOf("/=");
        }
        if (pos0 < 0) {
            pos0 = line.indexOf("%=");
        }
        if (pos0 > 0) {
            String token;
            int pos1 = line.indexOf(91);
            if (pos1 > 0 && pos1 < pos0) {
                pos0 = pos1;
            }
            if (this.varIntMap.containsKey(token = line.substring(0, pos0).trim())) {
                return true;
            }
            if (this.varStrMap.containsKey(token)) {
                return true;
            }
        }
        return false;
    }

    private void VarResist(String line, int varkind) {
        Vector<String> vc = this.getParams(line);
        int n = 0;
        while (n < vc.size()) {
            String var;
            String varName = var = vc.get(n);
            int num = 0;
            int[] vmat = new int[]{1};
            if (var.indexOf(91) > 0) {
                int pos = var.indexOf(91);
                varName = var.substring(0, pos).trim();
                var = var.substring(pos);
                StringTokenizer st = new StringTokenizer(var, "[] ", false);
                vmat = new int[st.countTokens()];
                num = 0;
                while (st.hasMoreTokens()) {
                    String vl = st.nextToken().trim().toLowerCase();
                    vmat[num] = this.Calc(vl);
                    if (vmat[num] <= 0) continue;
                    ++num;
                }
            }
            if (varName.charAt(0) >= '0' && varName.charAt(0) <= '9') {
                this.Error(8, "\u6570\u5024\u3092\u5148\u982d\u6587\u5b57\u3068\u3059\u308b\u5909\u6570\u540d\u3067\u306f\u5ba3\u8a00\u3067\u304d\u307e\u305b\u3093[" + varName + "]");
            }
            if (this.basicMap.containsKey(varName)) {
                this.Error(8, "\u4e88\u7d04\u8a9e\u306b\u5b58\u5728\u3059\u308b\u5909\u6570\u540d\u3067\u306f\u5ba3\u8a00\u3067\u304d\u307e\u305b\u3093[" + varName + "]");
            }
            if (this.cmdMap.containsKey(varName)) {
                this.Error(8, "\u4e88\u7d04\u8a9e\u306b\u5b58\u5728\u3059\u308b\u5909\u6570\u540d\u3067\u306f\u5ba3\u8a00\u3067\u304d\u307e\u305b\u3093[" + varName + "]");
            }
            if (this.varIntMap.containsKey(varName)) {
                this.Error(8, "\u65e2\u306b\u5ba3\u8a00\u3055\u308c\u305f\u5909\u6570\u540d\u3067\u306f\u5ba3\u8a00\u3067\u304d\u307e\u305b\u3093[" + varName + "]");
            }
            if (this.varStrMap.containsKey(varName)) {
                this.Error(8, "\u65e2\u306b\u5ba3\u8a00\u3055\u308c\u305f\u5909\u6570\u540d\u3067\u306f\u5ba3\u8a00\u3067\u304d\u307e\u305b\u3093[" + varName + "]");
            }
            block0 : switch (varkind) {
                case 100: {
                    switch (num) {
                        case 0: {
                            int[] intVar0 = new int[1];
                            this.varIntMap.put(varName, intVar0);
                            break;
                        }
                        case 1: {
                            int[] intVar1 = new int[vmat[0]];
                            this.varIntMap.put(varName, intVar1);
                        }
                    }
                    break;
                }
                case 200: {
                    switch (num) {
                        case 0: {
                            String[] strVar0 = new String[1];
                            this.varStrMap.put(varName, strVar0);
                            break block0;
                        }
                        case 1: {
                            String[] strVar1 = new String[vmat[0]];
                            this.varStrMap.put(varName, strVar1);
                        }
                    }
                }
            }
            ++n;
        }
    }

    public Vector<String> getArrayMatrixParams(String var) {
        Vector<String> vc = new Vector<String>();
        int pos = var.indexOf(91);
        if (pos < 0) {
            vc.add(var.trim());
            return vc;
        }
        String token = var.substring(0, pos).trim();
        vc.add(token);
        while (pos > 0) {
            int pos1 = this.ParenthesesIndexOf(var, pos, '[', ']');
            if (pos1 == -1) {
                this.Error(8, "[]\u306e\u5bfe\u5fdc\u304c\u3068\u308c\u3066\u3044\u307e\u305b\u3093[" + var + "]");
            }
            token = var.substring(pos + 1, pos1);
            vc.add(token);
            pos = var.indexOf(91, pos1);
        }
        return vc;
    }

    private Vector<String> getParams(String pline) {
        Vector<String> params = new Vector<String>();
        StringTokenizer st = new StringTokenizer(pline, ",", false);
        while (st.countTokens() > 0) {
            params.add(st.nextToken().trim());
        }
        return params;
    }

    public void outScriptState() {
        System.err.println("----------------------------");
        System.err.println("----- JONG Script State-----");
        System.err.println("----------------------------");
        System.err.println("\u2605\u57fa\u672c\u578b\u2605");
        Object[] keys = this.typeMap.keySet().toArray();
        int n = 0;
        while (n < keys.length) {
            System.err.print("KEY:" + keys[n]);
            System.err.println(" CODE:" + this.typeMap.get(keys[n])[0]);
            ++n;
        }
        System.err.println();
        System.err.println("\u2605\u57fa\u672c\u30b3\u30de\u30f3\u30c9\u2605");
        keys = this.basicMap.keySet().toArray();
        n = 0;
        while (n < keys.length) {
            System.err.print("KEY:" + keys[n]);
            System.err.println(" CODE:" + this.basicMap.get(keys[n])[0]);
            ++n;
        }
        System.err.println();
        System.err.println("\u2605\u767b\u9332\u30b3\u30de\u30f3\u30c9\u2605");
        keys = this.cmdMap.keySet().toArray();
        n = 0;
        while (n < keys.length) {
            System.err.print("KEY:" + keys[n]);
            System.err.println(" CODE:" + this.cmdMap.get(keys[n])[0]);
            ++n;
        }
        System.err.println();
        System.err.println("\u2605\u30e9\u30d9\u30eb\u2605");
        keys = this.labelMap.keySet().toArray();
        n = 0;
        while (n < keys.length) {
            System.err.print("KEY:" + keys[n]);
            System.err.println(" CODE:" + this.labelMap.get(keys[n])[0]);
            ++n;
        }
        System.err.println();
        System.err.println("\u2605\u30b9\u30af\u30ea\u30d7\u30c8\u2605");
        n = 0;
        while (n < this.scriptCode.size()) {
            int[] code = this.scriptCode.get(n);
            Vector<String> vct = this.scriptParams.get(n);
            String cs = "0000" + code[0];
            String ln = "000" + n;
            System.err.print(ln.substring(ln.length() - 3));
            System.err.print(" Cmd:" + cs.substring(cs.length() - 4));
            System.err.println(" Param[" + vct.size() + "]" + vct.toString());
            ++n;
        }
    }

    private void setVariable(String line) {
        int pos0 = line.indexOf(61);
        String varName = line.substring(0, pos0);
        String param = line.substring(pos0 + 1).trim();
        if (this.isIntVar(varName)) {
            this.setVarIntValue(varName, this.Calc(param));
        } else if (this.isStrVar(varName)) {
            this.setVarStrValue(varName, this.getStrValue(param));
        }
    }

    private int getIntValue(String intstr) {
        String str = intstr.trim();
        if (this.isIntVar(str)) {
            return this.getVarIntValue(str);
        }
        int value = this.strToInt(str);
        if (value != 0) {
            return value;
        }
        if (str.charAt(0) != '0') {
            this.Error(8, "[" + str + "]\u3068\u3044\u3046\u6570\u5024\u578b\u306e\u5909\u6570\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        return 0;
    }

    private String getStrValue(String scrtext) {
        String str = scrtext.trim();
        char tc = str.charAt(0);
        if (tc == '+') {
            str = str.substring(1);
        }
        if (this.isStrVar(str)) {
            str = this.getVarStrValue(str);
        } else if (this.isIntVar(str)) {
            str = "" + this.getVarIntValue(str);
        } else if (str.indexOf(43) >= 0) {
            str = this.strToStr(str);
        } else if (str.charAt(0) == '\"' && str.charAt(str.length() - 1) == '\"') {
            str = str.substring(1, str.length() - 1);
        }
        if (tc == '+') {
            str = "+" + str;
        }
        return str;
    }

    private String strToStr(String str) {
        StringTokenizer st = new StringTokenizer(str, "\"+", false);
        String text = "";
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            text = this.isIntVar(token) ? String.valueOf(text) + this.getIntValue(token) : (this.isStrVar(token) ? String.valueOf(text) + this.getVarStrValue(token) : String.valueOf(text) + token);
        }
        return text;
    }

    private int strToInt(String str) {
        int DataVAL = 0;
        if (str.length() == 0) {
            return 0;
        }
        String DataStr = str.charAt(0) == '-' || str.charAt(0) == '+' ? str.substring(1) : str;
        try {
            DataVAL = DataStr.length() > 2 && DataStr.charAt(0) == '0' && DataStr.charAt(1) == 'x' ? Integer.parseInt(DataStr.substring(2), 16) : (DataStr.charAt(0) >= '0' && DataStr.charAt(0) <= '9' ? Integer.parseInt(DataStr, 10) : 0);
        }
        catch (NumberFormatException murle) {
            return 0;
        }
        if (str.charAt(0) == '-') {
            DataVAL = -DataVAL;
        }
        return DataVAL;
    }

    private int getVarIntValue(String str) {
        Vector<String> vc = this.getArrayMatrixParams(str);
        int[] varMat = (int[])this.varIntMap.get(vc.get(0).trim());
        if (varMat == null) {
            this.Error(8, "\u5909\u6570" + vc.get(0).trim() + "\u306f\u5b58\u5728\u3057\u307e\u305b\u3093\u3002");
        }
        if (vc.size() == 1) {
            return varMat[0];
        }
        int m = this.Calc(vc.get(1));
        return varMat[m];
    }

    private String getVarStrValue(String str) {
        Vector<String> vc = this.getArrayMatrixParams(str);
        String[] varMat = (String[])this.varStrMap.get(vc.get(0).trim());
        if (varMat == null) {
            this.Error(8, "\u5909\u6570" + vc.get(0).trim() + "\u306f\u5b58\u5728\u3057\u307e\u305b\u3093\u3002");
        }
        if (vc.size() == 1) {
            return varMat[0];
        }
        int m = this.getIntValue(vc.get(1));
        return varMat[m];
    }

    private void setVarIntValue(String str, int val) {
        Vector<String> vc = this.getArrayMatrixParams(str);
        int[] varMat = (int[])this.varIntMap.get(vc.get(0).trim());
        if (vc.size() == 1) {
            varMat[0] = val;
        } else {
            int m = this.Calc(vc.get(1));
            if (m < varMat.length) {
                varMat[m] = val;
            } else {
                this.Error(8, "\u5909\u6570" + str + "\u306e\u914d\u5217\u6dfb\u5b57\u3092\u30aa\u30fc\u30d0\u30fc" + m + "\u3057\u307e\u3057\u305f");
            }
        }
    }

    private void setVarStrValue(String str, String val) {
        Vector<String> vc = this.getArrayMatrixParams(str);
        String[] varMat = (String[])this.varStrMap.get(vc.get(0).trim());
        if (vc.size() == 1) {
            varMat[0] = val;
        } else {
            int m = this.Calc(vc.get(1));
            if (m < varMat.length) {
                varMat[m] = val;
            } else {
                this.Error(8, "\u5909\u6570" + str + "\u306e\u914d\u5217\u6dfb\u5b57\u3092\u30aa\u30fc\u30d0\u30fc" + m + "\u3057\u307e\u3057\u305f");
            }
        }
    }

    private boolean isIntVar(String str) {
        if (str.length() == 0) {
            return false;
        }
        int pos = str.indexOf(91);
        String varName = pos > 0 ? str.substring(0, pos).trim() : str.trim();
        return this.varIntMap.containsKey(varName);
    }

    private boolean isStrVar(String str) {
        if (str.length() == 0) {
            return false;
        }
        int pos = str.indexOf(91);
        String varName = pos > 0 ? str.substring(0, pos).trim() : str.trim();
        return this.varStrMap.containsKey(varName);
    }

    public int Calc(String calcStr) {
        int ans = 0;
        ans = calcStr.indexOf(40) < 0 ? this.singleCalc(calcStr) : this.parenthesesCalc(calcStr);
        return ans;
    }

    public int parenthesesCalc(String str) {
        int ans = 0;
        String calcStr = str.trim();
        String operator = "+-*/%";
        if (calcStr.charAt(0) == '-') {
            calcStr = "0" + str.trim();
        }
        Vector<String> cObj = new Vector<String>();
        String opeObj = "";
        int pos1 = 0;
        int pos0 = 0;
        while (pos1 < calcStr.length()) {
            char c = calcStr.charAt(pos1);
            if (operator.indexOf(c) >= 0) {
                String objStr = calcStr.substring(pos0, pos1).trim();
                if (objStr.charAt(0) == '(') {
                    objStr = objStr.substring(1, objStr.length() - 1).trim();
                }
                cObj.add(objStr);
                pos0 = pos1 + 1;
                opeObj = String.valueOf(opeObj) + calcStr.substring(pos1, pos0);
            } else if (c == '(') {
                pos1 = this.ParenthesesIndexOf(calcStr, pos1, '(', ')');
            } else if (c == '[') {
                pos1 = this.ParenthesesIndexOf(calcStr, pos1, '[', ']');
            }
            ++pos1;
        }
        cObj.add(calcStr.substring(pos0, pos1).trim());
        Vector<int[]> valObj = new Vector<int[]>();
        int n = 0;
        while (n < cObj.size()) {
            int val0 = this.Calc((String)cObj.get(n));
            valObj.add(this.getIntArray(val0));
            ++n;
        }
        ans = this.vectorCalc(valObj, opeObj);
        return ans;
    }

    private int singleCalc(String str) {
        int ans = 0;
        String calcStr = str.trim();
        String operator = "+-*/%";
        if (calcStr.charAt(0) == '-') {
            calcStr = "0" + str.trim();
        }
        Vector<String> cObj = new Vector<String>();
        String opeObj = "";
        int pos1 = 0;
        int pos0 = 0;
        while (pos1 < calcStr.length()) {
            char c = calcStr.charAt(pos1);
            if (operator.indexOf(c) >= 0) {
                cObj.add(new String(calcStr.substring(pos0, pos1)));
                pos0 = pos1 + 1;
                opeObj = String.valueOf(opeObj) + calcStr.substring(pos1, pos0);
            } else if (c == '[') {
                pos1 = this.ParenthesesIndexOf(calcStr, pos1, '[', ']');
            }
            ++pos1;
        }
        cObj.add(new String(calcStr.substring(pos0, pos1).trim()));
        Vector<int[]> valObj = new Vector<int[]>();
        int n = 0;
        while (n < cObj.size()) {
            int val0 = this.getIntValue((String)cObj.get(n));
            valObj.add(this.getIntArray(val0));
            ++n;
        }
        ans = this.vectorCalc(valObj, opeObj);
        return ans;
    }

    private int vectorCalc(Vector<int[]> valObj, String opeObj) {
        int ans0;
        int val1;
        int val0;
        char c;
        char[] oplst = opeObj.toCharArray();
        int n = 0;
        while (n < oplst.length) {
            c = oplst[n];
            switch (c) {
                case '*': {
                    val0 = valObj.get(n)[0];
                    val1 = valObj.get(n + 1)[0];
                    int n2 = ans0 = val0 * val1;
                    valObj.get((int)(n + 1))[0] = n2;
                    valObj.get((int)n)[0] = n2;
                    oplst[n] = 32;
                    break;
                }
                case '/': {
                    val0 = valObj.get(n)[0];
                    val1 = valObj.get(n + 1)[0];
                    int n3 = ans0 = val0 / val1;
                    valObj.get((int)(n + 1))[0] = n3;
                    valObj.get((int)n)[0] = n3;
                    oplst[n] = 32;
                    break;
                }
                case '%': {
                    val0 = valObj.get(n)[0];
                    val1 = valObj.get(n + 1)[0];
                    int n4 = ans0 = val0 % val1;
                    valObj.get((int)(n + 1))[0] = n4;
                    valObj.get((int)n)[0] = n4;
                    oplst[n] = 32;
                }
            }
            ++n;
        }
        n = oplst.length - 1;
        while (n >= 0) {
            if (oplst[n] == ' ') {
                valObj.get((int)n)[0] = valObj.get(n + 1)[0];
            }
            --n;
        }
        n = 0;
        while (n < oplst.length) {
            c = oplst[n];
            switch (c) {
                case '+': {
                    val0 = valObj.get(n)[0];
                    val1 = valObj.get(n + 1)[0];
                    int n5 = ans0 = val0 + val1;
                    valObj.get((int)(n + 1))[0] = n5;
                    valObj.get((int)n)[0] = n5;
                    oplst[n] = 32;
                    break;
                }
                case '-': {
                    val0 = valObj.get(n)[0];
                    val1 = valObj.get(n + 1)[0];
                    int n6 = ans0 = val0 - val1;
                    valObj.get((int)(n + 1))[0] = n6;
                    valObj.get((int)n)[0] = n6;
                    oplst[n] = 32;
                    break;
                }
                case ' ': {
                    valObj.get((int)(n + 1))[0] = valObj.get(n)[0];
                }
            }
            ++n;
        }
        int ans = valObj.get(valObj.size() - 1)[0];
        return ans;
    }

    private boolean judge(String judgeStr) {
        boolean rjudge = false;
        rjudge = judgeStr.indexOf("&&") > 0 || judgeStr.indexOf("||") > 0 ? this.someJudge(judgeStr) : this.singleJudge(judgeStr);
        return rjudge;
    }

    private boolean someJudge(String str) {
        String token;
        Vector<String> vct = new Vector<String>();
        StringBuffer opeObj = new StringBuffer();
        int pos1 = 0;
        int pos0 = 0;
        while (pos1 < str.length()) {
            switch (str.charAt(pos1)) {
                case '(': {
                    pos1 = this.ParenthesesIndexOf(str, pos1, '(', ')');
                    break;
                }
                case '[': {
                    pos1 = this.ParenthesesIndexOf(str, pos1, '[', ']');
                    break;
                }
                case '\"': {
                    pos1 = this.ParenthesesIndexOf(str, pos1, '\"', '\"');
                    break;
                }
                case '&': {
                    if (str.charAt(pos1 + 1) == '&') {
                        token = str.substring(pos0, pos1).trim();
                        if (token.length() > 2 && token.charAt(0) == '(' && token.charAt(token.length() - 1) == ')') {
                            token = token.substring(1, token.length() - 1).trim();
                        }
                        if (token.length() > 0) {
                            vct.add(token);
                            pos0 = pos1 += 2;
                        }
                    }
                    opeObj.append('&');
                    break;
                }
                case '|': {
                    if (str.charAt(pos1 + 1) == '|') {
                        token = str.substring(pos0, pos1).trim();
                        if (token.length() > 2 && token.charAt(0) == '(' && token.charAt(token.length() - 1) == ')') {
                            token = token.substring(1, token.length() - 1).trim();
                        }
                        if (token.length() > 0) {
                            vct.add(token);
                            pos0 = pos1 += 2;
                        }
                    }
                    opeObj.append('|');
                }
            }
            ++pos1;
        }
        token = str.substring(pos0, pos1).trim();
        if (token.length() > 2 && token.charAt(0) == '(' && token.charAt(token.length() - 1) == ')') {
            token = token.substring(1, token.length() - 1).trim();
        }
        if (token.length() > 0) {
            vct.add(token);
            pos0 = pos1 += 2;
        }
        char[] opeArray = opeObj.toString().toCharArray();
        boolean[] logicArray = new boolean[vct.size()];
        int n = 0;
        while (n < vct.size()) {
            logicArray[n] = this.judge((String)vct.get(n));
            ++n;
        }
        n = 0;
        while (n < opeArray.length) {
            boolean flg0;
            if (opeArray[n] == '&') {
                boolean bl = flg0 = logicArray[n] && logicArray[n + 1];
                logicArray[n + 1] = bl;
                logicArray[n] = bl;
            } else if (opeArray[n] == '|') {
                boolean bl = flg0 = logicArray[n] && logicArray[n + 1];
                logicArray[n + 1] = bl;
                logicArray[n] = bl;
            }
            ++n;
        }
        boolean rjudge = logicArray[opeArray.length];
        return rjudge;
    }

    private boolean singleJudge(String judgeStr) {
        boolean judge = false;
        String jstr = judgeStr.trim().charAt(0) == '!' ? judgeStr.substring(1).trim() : judgeStr.trim();
        int w = 2;
        int pos = jstr.indexOf("==");
        int type = 0;
        if (pos < 0) {
            w = 2;
            pos = jstr.indexOf("!=");
            type = 1;
        }
        if (pos < 0) {
            w = 2;
            pos = jstr.indexOf("=!");
            type = 2;
        }
        if (pos < 0) {
            w = 2;
            pos = jstr.indexOf("<=");
            type = 3;
        }
        if (pos < 0) {
            w = 2;
            pos = jstr.indexOf("=<");
            type = 4;
        }
        if (pos < 0) {
            w = 2;
            pos = jstr.indexOf(">=");
            type = 5;
        }
        if (pos < 0) {
            w = 2;
            pos = jstr.indexOf("=>");
            type = 6;
        }
        if (pos < 0) {
            w = 1;
            pos = jstr.indexOf("<");
            type = 7;
        }
        if (pos < 0) {
            w = 1;
            pos = jstr.indexOf(">");
            type = 8;
        }
        if (pos < 0) {
            this.Error(8, "\u6bd4\u8f03\u306e\u8a18\u8ff0\u306b\u8aa4\u308a\u304c\u3042\u308a\u307e\u3059\u3002");
        }
        String left = jstr.substring(0, pos).trim();
        String right = jstr.substring(pos + w).trim();
        if (this.isStrVar(left) || this.isStrVar(right)) {
            String lstrval = this.getStrValue(left);
            String rstrval = this.getStrValue(right);
            judge = type == 0 ? lstrval.equals(rstrval) : !lstrval.equals(rstrval);
        } else {
            int lintval = this.Calc(left);
            int rintval = this.Calc(right);
            switch (type) {
                case 0: {
                    judge = lintval == rintval;
                    break;
                }
                case 1: 
                case 2: {
                    judge = lintval != rintval;
                    break;
                }
                case 3: 
                case 4: {
                    judge = lintval <= rintval;
                    break;
                }
                case 5: 
                case 6: {
                    judge = lintval >= rintval;
                    break;
                }
                case 7: {
                    judge = lintval < rintval;
                    break;
                }
                case 8: {
                    boolean bl = judge = lintval > rintval;
                }
            }
        }
        if (judgeStr.trim().charAt(0) == '!') {
            judge = !judge;
        }
        return judge;
    }

    private int[] getIntArray(int cd) {
        int[] code = new int[]{cd};
        return code;
    }

    private int ParenthesesIndexOf(String S, int n, char begin, char end) {
        int len = S.length();
        int n0 = 0;
        int n1 = n;
        while (n1 < len) {
            if (S.charAt(n1) == begin) {
                ++n0;
            } else if (S.charAt(n1) == end && --n0 == 0) {
                return n1;
            }
            ++n1;
        }
        this.Error(8, "\u62ec\u5f27\u306e\u5bfe\u5fdc\u304c\u3068\u308c\u3066\u3044\u307e\u305b\u3093\u3002(" + S + ")");
        return -1;
    }

    private void inputValue(String str) {
        String val = "";
        try {
            val = this.bread.readLine();
        }
        catch (IOException e) {
            this.Error(8, "\u30ad\u30fc\u5165\u529b\u306b\u5931\u6557");
        }
        if (this.isStrVar(str)) {
            this.setVarStrValue(str, val);
        } else if (this.isIntVar(str)) {
            this.setVarIntValue(str, this.strToInt(val));
        }
    }

    private void buttonSelect(Vector<String> vct) {
        String rvect = new String(vct.get(1));
        this.dmng.setSelectParam(vct);
        this.waitDisplayExec();
        if (this.isIntVar(rvect)) {
            this.setVarIntValue(rvect, this.dmng.getSelectButton());
        } else if (this.isStrVar(rvect)) {
            this.setVarStrValue(rvect, this.dmng.getSelectText());
        }
    }

    private void cellClick(Vector<String> vct) {
        String rvect = vct.get(1);
        if (this.dmng.visibleCellNum() == 0) {
            this.setVarIntValue(rvect, -1);
            return;
        }
        this.dmng.cellClick();
        int cellvalue = -1;
        while (cellvalue == -1) {
            this.waitDisplayExec();
            cellvalue = this.dmng.getSelectCell();
        }
        this.setVarIntValue(rvect, cellvalue);
    }

    private void waitDisplayExec() {
        while (this.dmng.diaplayBusy()) {
            this.waitMiliSec(100);
        }
    }

    public void waitMiliSec(int w) {
        long wait = w;
        try {
            JongScripter.sleep(wait);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void drawText(String txt, boolean wait, int wtime) {
        String text = txt.trim();
        if (this.dmng == null) {
            this.Text = text.charAt(0) == '+' ? String.valueOf(text) + text.substring(1) : text;
            System.out.println(this.Text);
        } else if (wait) {
            this.dmng.drawText(text);
            this.waitDisplayExec();
        } else {
            this.dmng.drawWaitText(text, wtime);
        }
    }

    private void oneLineExec() {
        int code = this.scriptCode.get(this.scriptPointer)[0];
        Vector<String> params = this.scriptParams.get(this.scriptPointer);
        block0 : switch (code) {
            case 1021: {
                if (params.size() == 3) {
                    int iwk0 = this.Calc(params.get(1));
                    int iwk1 = this.Calc(params.get(2));
                    this.dmng = new jongsDisplayManagement(iwk0, iwk1);
                } else {
                    this.dmng = new jongsDisplayManagement();
                }
                ++this.scriptPointer;
                break;
            }
            case 1005: {
                if (params.size() != 2) {
                    this.Error(8, "\u30d1\u30e9\u30e1\u30fc\u30bf\u6570\u304c\u8aa4\u3063\u3066\u3044\u307e\u3059");
                }
                if (this.labelMap.containsKey(this.getStrValue(params.get(1)))) {
                    this.scriptPointer = this.labelMap.get(params.get(1))[0];
                    break;
                }
                this.Error(8, String.valueOf(this.getStrValue(params.get(1))) + "\u3068\u3044\u3046\u30e9\u30d9\u30eb\u306f\u30b9\u30af\u30ea\u30d7\u30c8\u5185\u306b\u5b58\u5728\u3057\u307e\u305b\u3093\u3002");
                break;
            }
            case 1006: {
                if (params.size() != 2) {
                    this.Error(8, "\u30d1\u30e9\u30e1\u30fc\u30bf\u6570\u304c\u8aa4\u3063\u3066\u3044\u307e\u3059");
                }
                if (this.labelMap.containsKey(this.getStrValue(params.get(1)))) {
                    this.subroutineStack.add(this.getIntArray(this.scriptPointer));
                    this.scriptPointer = this.labelMap.get(params.get(1))[0];
                    break;
                }
                this.Error(8, String.valueOf(this.getStrValue(params.get(1))) + "\u3068\u3044\u3046\u30e9\u30d9\u30eb\u306f\u30b9\u30af\u30ea\u30d7\u30c8\u5185\u306b\u5b58\u5728\u3057\u307e\u305b\u3093\u3002");
                break;
            }
            case 1007: {
                if (this.subroutineStack.empty()) {
                    this.Error(8, "return\u6587\u306e\u623b\u308a\u5148\u304c\u3042\u308a\u307e\u305b\u3093");
                }
                this.scriptPointer = this.subroutineStack.pop()[0] + 1;
                break;
            }
            case 1020: {
                if (params.size() == 2) {
                    String swk0 = this.getStrValue(params.get(1));
                    this.getScript(swk0, "EUC_JP");
                } else if (params.size() == 3) {
                    String swk0 = this.getStrValue(params.get(1));
                    String swk1 = this.getStrValue(params.get(2));
                    this.getScript(swk0, swk1);
                } else {
                    this.Error(8, "\u30d1\u30e9\u30e1\u30fc\u30bf\u6570\u304c\u8aa4\u3063\u3066\u3044\u307e\u3059");
                }
                this.scriptPointer = 0;
                break;
            }
            case 1011: {
                if (params.size() != 2) {
                    this.Error(8, "\u30d1\u30e9\u30e1\u30fc\u30bf\u6570\u304c\u8aa4\u3063\u3066\u3044\u307e\u3059");
                }
                String swk0 = this.getStrValue(params.get(1));
                this.drawText(swk0, true, 0);
                ++this.scriptPointer;
                break;
            }
            case 1022: {
                if (params.size() == 2) {
                    String swk0 = this.getStrValue(params.get(1));
                    this.drawText(swk0, false, 2000);
                } else if (params.size() == 3) {
                    String swk0 = this.getStrValue(params.get(1));
                    int iwk0 = this.Calc(params.get(2));
                    this.drawText(swk0, false, iwk0);
                } else if (params.size() != 2) {
                    this.Error(8, "\u30d1\u30e9\u30e1\u30fc\u30bf\u6570\u304c\u8aa4\u3063\u3066\u3044\u307e\u3059");
                }
                ++this.scriptPointer;
                break;
            }
            case 1013: {
                if (params.size() != 2) {
                    this.Error(8, "\u30d1\u30e9\u30e1\u30fc\u30bf\u6570\u304c\u8aa4\u3063\u3066\u3044\u307e\u3059");
                }
                this.inputValue(params.get(1));
                ++this.scriptPointer;
                break;
            }
            case 1010: {
                this.setVariable(params.get(1));
                ++this.scriptPointer;
                break;
            }
            case 1001: {
                if (params.size() != 2) {
                    this.Error(8, "\u30d1\u30e9\u30e1\u30fc\u30bf\u6570\u304c\u8aa4\u3063\u3066\u3044\u307e\u3059");
                }
                if (this.judge(params.get(1))) {
                    ++this.scriptPointer;
                } else {
                    Vector<String> vcs = this.scriptParams.get(this.scriptPointer + 1);
                    this.scriptPointer = Integer.parseInt(vcs.get(1));
                }
                ++this.scriptPointer;
                break;
            }
            case 1003: {
                if (params.size() != 2) {
                    this.Error(8, "\u30d1\u30e9\u30e1\u30fc\u30bf\u6570\u304c\u8aa4\u3063\u3066\u3044\u307e\u3059");
                }
                if (this.judge(params.get(1))) {
                    ++this.scriptPointer;
                } else {
                    Vector<String> vcs = this.scriptParams.get(this.scriptPointer + 1);
                    this.scriptPointer = Integer.parseInt(vcs.get(1));
                }
                ++this.scriptPointer;
                break;
            }
            case 1004: {
                if (params.size() != 4) {
                    this.Error(8, "\u30d1\u30e9\u30e1\u30fc\u30bf\u6570\u304c\u8aa4\u3063\u3066\u3044\u307e\u3059");
                }
                this.setVariable(params.get(1));
                if (this.judge(params.get(2))) {
                    ++this.scriptPointer;
                } else {
                    Vector<String> vcs = this.scriptParams.get(this.scriptPointer + 1);
                    this.scriptPointer = Integer.parseInt(vcs.get(1));
                }
                ++this.scriptPointer;
                break;
            }
            case 1009: {
                int iwk1 = Integer.parseInt(params.get(1));
                int iwk0 = this.basicMap.get(params.get(2))[0];
                switch (iwk0) {
                    case 1003: {
                        if (this.judge(params.get(3))) {
                            this.scriptPointer = iwk1 + 1;
                            break;
                        }
                        ++this.scriptPointer;
                        break;
                    }
                    case 1004: {
                        this.setVariable(params.get(4));
                        if (this.judge(params.get(3))) {
                            this.scriptPointer = iwk1 + 1;
                            break;
                        }
                        ++this.scriptPointer;
                        break;
                    }
                    case 1001: {
                        if (this.scriptCode.get(this.scriptPointer + 1)[0] != 1002) break block0;
                        Vector<String> vcs = this.scriptParams.get(this.scriptPointer + 2);
                        this.scriptPointer = Integer.parseInt(vcs.get(1)) + 1;
                        break;
                    }
                    default: {
                        ++this.scriptPointer;
                        break;
                    }
                }
                break;
            }
            case 1019: {
                this.debug = this.debug == 0 ? 1 : 0;
                ++this.scriptPointer;
                break;
            }
            case 2010: {
                if (params.size() != 2) {
                    this.Error(8, "\u30d1\u30e9\u30e1\u30fc\u30bf\u6570\u304c\u8aa4\u3063\u3066\u3044\u307e\u3059");
                }
                int iwk0 = this.Calc(params.get(1));
                if (this.dmng == null) {
                    this.waitMiliSec(iwk0);
                } else {
                    this.dmng.waitMiliSec(iwk0);
                }
                ++this.scriptPointer;
                break;
            }
            case 2001: {
                if (this.dmng == null) {
                    this.Error(8, "\u753b\u9762\u304c\u5b58\u5728\u3057\u306a\u3044\u306e\u3067\u3001\u753b\u9762\u7cfb\u306e\u51e6\u7406\u306f\u3067\u304d\u307e\u305b\u3093");
                }
                if (params.size() != 2) {
                    this.Error(8, "\u30d1\u30e9\u30e1\u30fc\u30bf\u6570\u304c\u8aa4\u3063\u3066\u3044\u307e\u3059");
                }
                int iwk0 = this.Calc(params.get(1));
                this.dmng.setCellNumber(iwk0);
                ++this.scriptPointer;
                break;
            }
            case 2006: {
                if (this.dmng == null) {
                    this.Error(8, "\u753b\u9762\u304c\u5b58\u5728\u3057\u306a\u3044\u306e\u3067\u3001\u753b\u9762\u7cfb\u306e\u51e6\u7406\u306f\u3067\u304d\u307e\u305b\u3093");
                }
                if (params.size() == 2) {
                    String swk0 = this.getStrValue(params.get(1));
                    this.dmng.setCellView(swk0);
                } else if (params.size() == 3) {
                    int iwk0 = this.Calc(params.get(1));
                    int iwk1 = this.Calc(params.get(2));
                    this.dmng.setCellView(iwk0, iwk1);
                } else {
                    this.Error(8, "\u30d1\u30e9\u30e1\u30fc\u30bf\u6570\u304c\u8aa4\u3063\u3066\u3044\u307e\u3059");
                }
                ++this.scriptPointer;
                break;
            }
            case 2003: {
                if (params.size() == 4) {
                    int iwk2;
                    int iwk0 = this.Calc(params.get(1));
                    String swk0 = params.get(2).trim();
                    int iwk1 = this.dmng.getPositionCode(swk0);
                    if (iwk1 == 0) {
                        iwk1 = this.Calc(params.get(2));
                    }
                    if ((iwk2 = this.dmng.getPositionCode(swk0 = params.get(3).trim())) == 0) {
                        iwk2 = this.Calc(params.get(3));
                    }
                    this.dmng.setCellPosition(iwk0, iwk1, iwk2);
                } else {
                    this.Error(8, "\u30d1\u30e9\u30e1\u30fc\u30bf\u6570\u304c\u8aa4\u3063\u3066\u3044\u307e\u3059");
                }
                ++this.scriptPointer;
                break;
            }
            case 2004: {
                if (params.size() == 4) {
                    int iwk0 = this.Calc(params.get(1));
                    int iwk1 = this.Calc(params.get(2));
                    int iwk2 = this.Calc(params.get(3));
                    this.dmng.setCellSize(iwk0, iwk1, iwk2);
                } else {
                    this.Error(8, "\u30d1\u30e9\u30e1\u30fc\u30bf\u6570\u304c\u8aa4\u3063\u3066\u3044\u307e\u3059");
                }
                ++this.scriptPointer;
                break;
            }
            case 2002: {
                if (this.dmng == null) {
                    this.Error(8, "\u753b\u9762\u304c\u5b58\u5728\u3057\u306a\u3044\u306e\u3067\u3001\u753b\u9762\u7cfb\u306e\u51e6\u7406\u306f\u3067\u304d\u307e\u305b\u3093");
                }
                if (params.size() == 3) {
                    String swk0;
                    int iwk0 = this.Calc(params.get(1));
                    boolean bwk0 = this.dmng.setCellImage(iwk0, swk0 = this.getStrValue(params.get(2)));
                    if (!bwk0) {
                        this.Error(8, "\u753b\u50cf\u30d5\u30a1\u30a4\u30eb" + swk0 + "\u304c\u8aad\u307f\u8fbc\u3081\u307e\u305b\u3093");
                    }
                } else {
                    this.Error(8, "\u30d1\u30e9\u30e1\u30fc\u30bf\u6570\u304c\u8aa4\u3063\u3066\u3044\u307e\u3059");
                }
                ++this.scriptPointer;
                break;
            }
            case 2007: {
                if (this.dmng == null) {
                    this.Error(8, "\u753b\u9762\u304c\u5b58\u5728\u3057\u306a\u3044\u306e\u3067\u3001\u753b\u9762\u7cfb\u306e\u51e6\u7406\u306f\u3067\u304d\u307e\u305b\u3093");
                }
                if (params.size() == 1) {
                    this.dmng.viewDisplay();
                } else if (params.size() == 2) {
                    String swk0 = this.getStrValue(params.get(1));
                    this.dmng.viewDisplay(swk0);
                } else if (params.size() == 3) {
                    String swk0 = this.getStrValue(params.get(1));
                    String swk1 = this.getStrValue(params.get(2));
                    this.dmng.transitionDisplay(swk0, swk1);
                } else {
                    this.Error(8, "\u30d1\u30e9\u30e1\u30fc\u30bf\u6570\u304c\u8aa4\u3063\u3066\u3044\u307e\u3059");
                }
                this.waitDisplayExec();
                ++this.scriptPointer;
                break;
            }
            case 2008: {
                if (this.dmng == null) {
                    this.Error(8, "\u753b\u9762\u304c\u5b58\u5728\u3057\u306a\u3044\u306e\u3067\u3001\u753b\u9762\u7cfb\u306e\u51e6\u7406\u306f\u3067\u304d\u307e\u305b\u3093");
                }
                if (params.size() == 2) {
                    String swk0 = this.getStrValue(params.get(1));
                    this.dmng.transitionDisplay(swk0);
                } else if (params.size() == 3) {
                    String swk0 = this.getStrValue(params.get(1));
                    String swk1 = this.getStrValue(params.get(2));
                    this.dmng.transitionDisplay(swk0, swk1);
                } else {
                    this.Error(8, "\u30d1\u30e9\u30e1\u30fc\u30bf\u6570\u304c\u8aa4\u3063\u3066\u3044\u307e\u3059");
                }
                this.waitDisplayExec();
                ++this.scriptPointer;
                break;
            }
            case 2005: {
                if (this.dmng == null) {
                    this.Error(8, "\u753b\u9762\u304c\u5b58\u5728\u3057\u306a\u3044\u306e\u3067\u3001\u753b\u9762\u7cfb\u306e\u51e6\u7406\u306f\u3067\u304d\u307e\u305b\u3093");
                }
                if (params.size() == 3) {
                    int iwk0 = this.Calc(params.get(1));
                    int iwk1 = this.Calc(params.get(2));
                    this.dmng.setTransColor(iwk0, iwk1);
                } else if (params.size() == 4) {
                    int iwk0 = this.Calc(params.get(1));
                    int iwk1 = this.Calc(params.get(2));
                    int iwk2 = this.Calc(params.get(3));
                    this.dmng.setTransColor(iwk0, iwk1, iwk2);
                } else if (params.size() == 5) {
                    int iwk0 = this.Calc(params.get(1));
                    int iwk1 = this.Calc(params.get(2));
                    int iwk2 = this.Calc(params.get(3));
                    int iwk3 = this.Calc(params.get(4));
                    this.dmng.setTransColor(iwk0, iwk1, iwk2, iwk3);
                } else {
                    this.Error(8, "\u30d1\u30e9\u30e1\u30fc\u30bf\u6570\u304c\u8aa4\u3063\u3066\u3044\u307e\u3059");
                }
                ++this.scriptPointer;
                break;
            }
            case 2024: {
                if (this.dmng == null) {
                    this.Error(8, "\u753b\u9762\u304c\u5b58\u5728\u3057\u306a\u3044\u306e\u3067\u3001\u753b\u9762\u7cfb\u306e\u51e6\u7406\u306f\u3067\u304d\u307e\u305b\u3093");
                }
                if (params.size() != 2) {
                    this.Error(8, "\u30d1\u30e9\u30e1\u30fc\u30bf\u6570\u304c\u8aa4\u3063\u3066\u3044\u307e\u3059");
                }
                this.cellClick(params);
                ++this.scriptPointer;
                break;
            }
            case 2009: {
                if (this.dmng == null) {
                    this.Error(8, "\u753b\u9762\u304c\u5b58\u5728\u3057\u306a\u3044\u306e\u3067\u3001\u753b\u9762\u7cfb\u306e\u51e6\u7406\u306f\u3067\u304d\u307e\u305b\u3093");
                }
                if (params.size() == 3) {
                    int iwk0 = this.Calc(params.get(1));
                    int iwk1 = this.Calc(params.get(2));
                    this.dmng.createDisplay(iwk0, iwk1);
                } else {
                    this.Error(8, "\u30d1\u30e9\u30e1\u30fc\u30bf\u6570\u304c\u8aa4\u3063\u3066\u3044\u307e\u3059");
                }
                ++this.scriptPointer;
                break;
            }
            case 2011: {
                if (this.dmng == null) {
                    this.Error(8, "\u753b\u9762\u304c\u5b58\u5728\u3057\u306a\u3044\u306e\u3067\u3001\u753b\u9762\u7cfb\u306e\u51e6\u7406\u306f\u3067\u304d\u307e\u305b\u3093");
                }
                if (params.size() == 2) {
                    int iwk0 = this.Calc(params.get(1));
                    this.dmng.setFontColor(iwk0, this.anotherColor(iwk0));
                } else if (params.size() == 3) {
                    int iwk0 = this.Calc(params.get(1));
                    int iwk1 = this.Calc(params.get(2));
                    this.dmng.setFontColor(iwk0, iwk1);
                } else {
                    this.Error(8, "\u30d1\u30e9\u30e1\u30fc\u30bf\u6570\u304c\u8aa4\u3063\u3066\u3044\u307e\u3059");
                }
                ++this.scriptPointer;
                break;
            }
            case 2012: {
                if (this.dmng == null) {
                    this.Error(8, "\u753b\u9762\u304c\u5b58\u5728\u3057\u306a\u3044\u306e\u3067\u3001\u753b\u9762\u7cfb\u306e\u51e6\u7406\u306f\u3067\u304d\u307e\u305b\u3093");
                }
                if (params.size() == 4) {
                    String swk0 = this.getStrValue(params.get(1));
                    String swk1 = this.getStrValue(params.get(2));
                    int iwk1 = this.Calc(params.get(3));
                    this.dmng.setTextFont(swk0, swk1, iwk1);
                } else {
                    this.Error(8, "\u30d1\u30e9\u30e1\u30fc\u30bf\u6570\u304c\u8aa4\u3063\u3066\u3044\u307e\u3059");
                }
                ++this.scriptPointer;
                break;
            }
            case 2013: {
                if (this.dmng == null) {
                    this.Error(8, "\u753b\u9762\u304c\u5b58\u5728\u3057\u306a\u3044\u306e\u3067\u3001\u753b\u9762\u7cfb\u306e\u51e6\u7406\u306f\u3067\u304d\u307e\u305b\u3093");
                }
                if (params.size() == 5) {
                    int iwk0 = this.Calc(params.get(1));
                    int iwk1 = this.Calc(params.get(2));
                    int iwk2 = this.Calc(params.get(3));
                    int iwk3 = this.Calc(params.get(4));
                    this.dmng.setTextArea(iwk0, iwk1, iwk2, iwk3);
                } else {
                    this.Error(8, "\u30d1\u30e9\u30e1\u30fc\u30bf\u6570\u304c\u8aa4\u3063\u3066\u3044\u307e\u3059");
                }
                ++this.scriptPointer;
                break;
            }
            case 2015: {
                if (this.dmng == null) {
                    this.Error(8, "\u753b\u9762\u304c\u5b58\u5728\u3057\u306a\u3044\u306e\u3067\u3001\u753b\u9762\u7cfb\u306e\u51e6\u7406\u306f\u3067\u304d\u307e\u305b\u3093");
                }
                if (params.size() == 5) {
                    int iwk0 = this.Calc(params.get(1));
                    int iwk1 = this.Calc(params.get(2));
                    int iwk2 = this.Calc(params.get(3));
                    int iwk3 = this.Calc(params.get(4));
                    this.dmng.setSelectArea(iwk0, iwk1, iwk2, iwk3);
                } else {
                    this.Error(8, "\u30d1\u30e9\u30e1\u30fc\u30bf\u6570\u304c\u8aa4\u3063\u3066\u3044\u307e\u3059");
                }
                ++this.scriptPointer;
                break;
            }
            case 2016: {
                if (this.dmng == null) {
                    this.Error(8, "\u753b\u9762\u304c\u5b58\u5728\u3057\u306a\u3044\u306e\u3067\u3001\u753b\u9762\u7cfb\u306e\u51e6\u7406\u306f\u3067\u304d\u307e\u305b\u3093");
                }
                if (params.size() == 5) {
                    int iwk0 = this.Calc(params.get(1));
                    int iwk1 = this.Calc(params.get(2));
                    int iwk2 = this.Calc(params.get(3));
                    int iwk3 = this.Calc(params.get(4));
                    this.dmng.setSelectColor(iwk0, iwk1, iwk2, iwk3);
                } else {
                    this.Error(8, "\u30d1\u30e9\u30e1\u30fc\u30bf\u6570\u304c\u8aa4\u3063\u3066\u3044\u307e\u3059");
                }
                ++this.scriptPointer;
                break;
            }
            case 2014: {
                if (this.dmng == null) {
                    this.Error(8, "\u753b\u9762\u304c\u5b58\u5728\u3057\u306a\u3044\u306e\u3067\u3001\u753b\u9762\u7cfb\u306e\u51e6\u7406\u306f\u3067\u304d\u307e\u305b\u3093");
                }
                if (params.size() < 3) {
                    this.Error(8, "\u30d1\u30e9\u30e1\u30fc\u30bf\u6570\u304c\u8aa4\u3063\u3066\u3044\u307e\u3059");
                }
                this.buttonSelect(params);
                ++this.scriptPointer;
                break;
            }
            case 2018: {
                String swk0;
                int iwk0;
                if (params.size() < 2) {
                    this.Error(8, "\u30d1\u30e9\u30e1\u30fc\u30bf\u6570\u304c\u8aa4\u3063\u3066\u3044\u307e\u3059");
                }
                if ((iwk0 = this.sound.MIDIload(swk0 = this.getStrValue(params.get(1)))) > 0) {
                    this.Error(8, "\u3053\u306eMIDI [" + swk0 + "] \u3092\u958b\u304f\u3053\u3068\u304c\u3067\u304d\u307e\u305b\u3093\u3002(" + iwk0 + ")");
                }
                ++this.scriptPointer;
                break;
            }
            case 2017: {
                int iwk0 = this.sound.Midiplay();
                if (iwk0 > 0) {
                    this.Error(8, "\u3053\u306eMIDI\u3092\u6f14\u594f\u3067\u304d\u307e\u305b\u3093\u3002");
                }
                this.th_wtime = 30;
                ++this.scriptPointer;
                break;
            }
            case 2019: {
                this.sound.MIDIstop();
                this.th_wtime = 0;
                ++this.scriptPointer;
                break;
            }
            case 2021: {
                String swk0;
                int iwk0;
                if (params.size() < 2) {
                    this.Error(8, "\u30d1\u30e9\u30e1\u30fc\u30bf\u6570\u304c\u8aa4\u3063\u3066\u3044\u307e\u3059");
                }
                if ((iwk0 = this.sound.AUDIOLoop(swk0 = this.getStrValue(params.get(1)))) > 0) {
                    this.Error(8, "\u3053\u306e\u30aa\u30fc\u30c7\u30a3\u30aa\u30d5\u30a1\u30a4\u30eb [" + swk0 + "] \u3092\u6f14\u594f\u3067\u304d\u307e\u305b\u3093\u3002(" + iwk0 + ")");
                }
                ++this.scriptPointer;
                break;
            }
            case 2020: {
                String swk0;
                int iwk0;
                if (params.size() < 2) {
                    this.Error(8, "\u30d1\u30e9\u30e1\u30fc\u30bf\u6570\u304c\u8aa4\u3063\u3066\u3044\u307e\u3059");
                }
                if ((iwk0 = this.sound.AUDIOPlay(swk0 = this.getStrValue(params.get(1)))) > 0) {
                    this.Error(8, "\u3053\u306e\u30aa\u30fc\u30c7\u30a3\u30aa\u30d5\u30a1\u30a4\u30eb [" + swk0 + "] \u3092\u6f14\u594f\u3067\u304d\u307e\u305b\u3093\u3002(" + iwk0 + ")");
                }
                ++this.scriptPointer;
                break;
            }
            case 2022: {
                if (params.size() < 2) {
                    this.Error(8, "\u30d1\u30e9\u30e1\u30fc\u30bf\u6570\u304c\u8aa4\u3063\u3066\u3044\u307e\u3059");
                }
                String swk0 = this.getStrValue(params.get(1));
                this.sound.AUDIOStop(swk0);
                ++this.scriptPointer;
                break;
            }
            case 2023: {
                if (params.size() < 2) {
                    this.Error(8, "\u30d1\u30e9\u30e1\u30fc\u30bf\u6570\u304c\u8aa4\u3063\u3066\u3044\u307e\u3059");
                }
                this.th_wtime = this.Calc(params.get(1));
                ++this.scriptPointer;
                break;
            }
            default: {
                ++this.scriptPointer;
            }
        }
    }

    private int anotherColor(int col) {
        int r = col >> 16 & 0xFF;
        int g = col >> 8 & 0xFF;
        int b = col & 0xFF;
        r = r > 127 ? (r /= 2) : (r + 127) / 2;
        g = g > 127 ? (g /= 2) : (g + 127) / 2;
        b = b > 127 ? (b /= 2) : (b + 127) / 2;
        int color = 0xFF000000 | r << 16 | g << 8 | b;
        return color;
    }

    private void Error(int level, String t0) {
        System.err.println("JONGS-Error:" + t0 + ":" + this.scriptParams.get(this.scriptPointer));
        switch (level) {
            case 0: {
                break;
            }
            case 4: {
                break;
            }
            case 8: {
                this.sound.MIDIclose();
                if (this.dmng != null) {
                    this.dmng.dispose();
                }
                System.exit(level);
                break;
            }
            default: {
                this.sound.MIDIclose();
                if (this.dmng != null) {
                    this.dmng.dispose();
                }
                System.exit(level);
            }
        }
    }

    @Override
    public void run() {
        while (this.scriptPointer < this.scriptCode.size()) {
            if (this.debug > 0) {
                System.out.println("JONGS Line:" + this.scriptParams.get(this.scriptPointer).toString());
            }
            this.oneLineExec();
            if (this.th_wtime <= 0) continue;
            this.waitMiliSec(this.th_wtime);
        }
        this.sound.MIDIclose();
        if (this.dmng != null) {
            this.dmng.dispose();
        }
    }

    public static void main(String[] args) {
        JongScripter js = new JongScripter();
        if (args.length > 0) {
            if (args.length >= 2) {
                js.getScript(args[0], args[1]);
            } else {
                js.getScript(args[0], "EUC_JP");
            }
            js.start();
        }
    }
}

