/*
 * Decompiled with CFR 0.152.
 */
package jongs;

import java.applet.Applet;
import java.applet.AudioClip;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.HashMap;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaEventListener;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;
import javax.sound.midi.Synthesizer;
import javax.sound.midi.Transmitter;

public class jongsSound
implements MetaEventListener {
    private static final int MIDI_END = 47;
    private static final int MIDI_MAX = 128;
    private static final int AUDIO_MAX = 128;
    Sequencer MIDIsequencer;
    Synthesizer MIDIsynthesizer;
    Sequence MIDIsequence;
    HashMap<String, Sequence> MIDIFiles;
    HashMap<String, AudioClip> AUDIOFiles;

    public jongsSound() {
        this.initSequencer();
        this.MIDIFiles = new HashMap(128);
        this.AUDIOFiles = new HashMap(128);
    }

    private int initSequencer() {
        try {
            this.MIDIsequencer = MidiSystem.getSequencer();
            this.MIDIsequencer.open();
            this.MIDIsequencer.addMetaEventListener(this);
            if (!(this.MIDIsequencer instanceof Synthesizer)) {
                this.MIDIsynthesizer = MidiSystem.getSynthesizer();
                this.MIDIsynthesizer.open();
                Receiver synthReceiver = this.MIDIsynthesizer.getReceiver();
                Transmitter seqTransmitter = this.MIDIsequencer.getTransmitter();
                seqTransmitter.setReceiver(synthReceiver);
            } else {
                this.MIDIsynthesizer = (Synthesizer)((Object)this.MIDIsequencer);
            }
        }
        catch (MidiUnavailableException mue) {
            mue.printStackTrace();
            return 8;
        }
        return 0;
    }

    public void meta(MetaMessage mm) {
        if (mm.getType() == 47 && this.MIDIsequencer != null && this.MIDIsequencer.isOpen()) {
            this.MIDIsequencer.setMicrosecondPosition(0L);
            this.MIDIsequencer.start();
        }
    }

    public int MIDIload(String filename) {
        if (this.MIDIFiles.size() >= 128) {
            return 8;
        }
        if (this.MIDIFiles.containsKey(filename)) {
            this.MIDIsequence = this.MIDIFiles.get(filename);
            this.MIDIstop();
            return 0;
        }
        File MidiFile = new File("./" + filename);
        try {
            this.MIDIsequence = MidiSystem.getSequence(MidiFile);
        }
        catch (InvalidMidiDataException e) {
            return 1;
        }
        catch (IOException e) {
            return 2;
        }
        catch (NullPointerException e) {
            return 3;
        }
        this.MIDIstop();
        return 0;
    }

    public int AUDIOload(String filename) {
        AudioClip clip;
        if (this.AUDIOFiles.size() >= 128) {
            return 8;
        }
        if (this.AUDIOFiles.containsKey(filename)) {
            return 0;
        }
        File audioFile = new File("./" + filename);
        try {
            clip = Applet.newAudioClip(audioFile.toURL());
        }
        catch (NullPointerException ne) {
            return 8;
        }
        catch (MalformedURLException mue) {
            return 8;
        }
        this.AUDIOFiles.put(filename, clip);
        return 0;
    }

    public int AUDIOPlay(String filename) {
        AudioClip clip;
        if (this.AUDIOFiles.containsKey(filename)) {
            AudioClip clip2 = this.AUDIOFiles.get(filename);
            clip2.play();
            return 0;
        }
        if (this.AUDIOFiles.size() >= 128) {
            return 8;
        }
        File audioFile = new File("./" + filename);
        try {
            clip = Applet.newAudioClip(audioFile.toURL());
        }
        catch (NullPointerException ne) {
            return 8;
        }
        catch (MalformedURLException mue) {
            return 8;
        }
        this.AUDIOFiles.put(filename, clip);
        clip.play();
        return 0;
    }

    public int AUDIOLoop(String filename) {
        AudioClip clip;
        if (this.AUDIOFiles.containsKey(filename)) {
            AudioClip clip2 = this.AUDIOFiles.get(filename);
            clip2.loop();
            return 0;
        }
        File audioFile = new File("./" + filename);
        try {
            clip = Applet.newAudioClip(audioFile.toURL());
        }
        catch (NullPointerException ne) {
            return 8;
        }
        catch (MalformedURLException mue) {
            return 8;
        }
        this.AUDIOFiles.put(filename, clip);
        clip.loop();
        return 0;
    }

    public void AUDIOStop(String filename) {
        if (this.AUDIOFiles.containsKey(filename)) {
            AudioClip clip = this.AUDIOFiles.get(filename);
            clip.stop();
        }
    }

    public int MIDIplay(String filename) {
        int retc = this.MIDIload(filename);
        if (retc == 0) {
            this.Midiplay();
            return 0;
        }
        return 8;
    }

    public int Midiplay() {
        if (this.MIDIsequence == null) {
            return 8;
        }
        return this.MIDIplay(this.MIDIsequence);
    }

    public int MIDIplay(Sequence seq) {
        this.MIDIstop();
        if (this.MIDIsequencer != null && seq != null) {
            try {
                this.MIDIsequencer.setSequence(seq);
                this.MIDIsequencer.start();
            }
            catch (InvalidMidiDataException imd) {
                return 8;
            }
            return 0;
        }
        return 8;
    }

    public void MIDIstop() {
        if (this.MIDIsequencer.isRunning()) {
            this.MIDIsequencer.stop();
        }
    }

    public void MIDIclose() {
        this.MIDIstop();
        this.MIDIsequencer.removeMetaEventListener(this);
        this.MIDIsequencer.close();
        this.MIDIsequencer = null;
    }
}

