package jongs;

import java.awt.image.BufferedImage;
import java.util.Vector;
import java.awt.Point;
//import java.util.StringTokenizer;
import java.awt.Rectangle;
import java.awt.Graphics;
import java.awt.image.ImageObserver;

// 
// JONGS - Java Open Novels Game Script
// 
//    JongsImage.java 
//
//  Copyright 2007  DENZI TOMIZKA
//
//  ver 1.00 Create by DENZI TOMIZKA 2007.5.25
//
/*
 *-----------------------------------------------------------------------
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU Library General Public License as published
 *   by the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU Library General Public License for more details.
 *
 *   You should have received a copy of the GNU Library General Public
 *   License along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *----------------------------------------------------------------------
 */


public class jongsImage  {
	Vector<int[]> transColors ;
	Rectangle posSize ;
	String filename;
	BufferedImage image ;
	boolean view ;
	boolean viewwm ;

	public jongsImage() {
		this.resetTransColor();
		posSize = new Rectangle() ;
		view = false ;
		viewwm = true ;
	}
	
	public void setImage(BufferedImage img, ImageObserver io) {
		this.resetTransColor();
		posSize.x = 0;
		posSize.y = 0;
		posSize.width = img.getWidth();
		posSize.height = img.getHeight();
        image = new BufferedImage(posSize.width,posSize.height, BufferedImage.TYPE_4BYTE_ABGR);
        Graphics g = image.getGraphics();
		g.drawImage(img,0,0,io);
	}

	public void setFileName(String fname) {
		filename = fname ;
	}
	
	public void setPoint(int x , int y) {
		this.posSize.x = x;
		this.posSize.y = y;
	}

	public void setPoint(Point p) {
		this.posSize.x = p.x;
		this.posSize.y = p.y;
	}

	public void setSize(int w , int h) {
		this.posSize.width = w;
		this.posSize.height = h;
	}
	
	public void setView(boolean v) { view = v  ;}		
	public void setViewWithMouse(boolean v) { viewwm = v  ;}	

	public int getX() { return posSize.x ;}
	public int getY() { return posSize.y ;}
	public int getWidth() { return posSize.width ;}
	public int getHeight() { return posSize.height ;}
	public boolean getView() { return view ;}	
	public boolean getViewWithMouse() { return viewwm ;}		
	
	/**
	 * ߐFݒ肷
	 * @param tc
	 */
	public void setTransColor(int tc) {
		int [] col ;
		//ߏC[WH
		if ( image.getColorModel().getTransparency() == BufferedImage.TRANSLUCENT ) {
			col = new int[1];
			col[0] = tc ;
			transColors.add(col);
			this.setTransImage(tc);
		} else {
		}
	}
	
	/**
	 * ߐFWŎw肷
	 * @param x
	 * @param y
	 * @param alpha
	 */
	public void setTransColor (int x , int y , int alpha) {
		int tc ;
		tc = image.getRGB(x,y) & 0x00ffffff ;
		tc = tc | (alpha << 24 );
		this.setTransColor(tc);
	}
	
	/**
	 * ߐFFƓxŎw肷
	 * @param x
	 * @param y
	 * @param alpha
	 */
	public void setTransColor (int color , int alpha) {
		int tc ;
		tc = color & 0x00ffffff ;
		tc = tc | (alpha << 24 );
		this.setTransColor(tc);
	}
	
	/**
	 * ߐFCɐݒ肷
	 * @param tc
	 */
	public void setTransColors(Vector<int[]> tcs) {
		int n , tc ;
		for ( n = 0 ; n < tcs.size() ; n++) {
			transColors.add(tcs.get(n));
			tc = tcs.get(n)[0];
			this.setTransImage(tc);			
		}
	}
	
	/**
	 * ߐFf[^Zbg
	 *
	 */
	public void resetTransColor() {
		this.transColors = new Vector <int[]>();		
	}

	/**
	 * ߐFʂɔf
	 * @param tc
	 */
	public void setTransImage(int tc){
		int width  = image.getWidth();
		int height = image.getHeight();
		int x , y ;
		int color = tc & 0x00ffffff ;
		int col0 ;
		
		for (y = 0 ; y < height ; y++) {
			for (x = 0 ; x < width ; x++) {
				col0 = image.getRGB(x, y) & 0x00ffffff;
				if ( col0 == color ) image.setRGB(x, y, tc);
			}
		}
	}
	
	
	/**
	 * wO[oWʒuLfmFB
	 * @param x
	 * @param y
	 * @return
	 */
	public boolean checkImageClick(int x , int y){
		int px , py , bx , by , col0 ;
		//sԂȂⓚpfalse
		if ( this.view == false ) return false ;
		//O[oWGAɊ܂܂ȂȂfalse
		if ( this.posSize.contains(x, y) == false ) {
			return false;
		}
		//摜W𓾂
		px = x - posSize.x ;
		py = y - posSize.y ;
		//gklB
		if ( posSize.width != this.image.getWidth() )
			bx = ( px * this.image.getWidth()) / posSize.width ;
		else 
			bx = px;
		if ( posSize.height != this.image.getHeight() )
			by = ( py * this.image.getHeight()) / posSize.height ;
		else 
			by = py;
		//䗦vŽ덷Ŕ͈͊OɂȂ\D͈͊Oł΂͂
		if ( bx < 0 || bx >= this.image.getWidth() ) return false ;
		if ( by < 0 || by >= this.image.getHeight() ) return false ;		
		col0 = ( image.getRGB( bx , by ) >> 24 );
		//F̓xOȂfalse
		if ( col0 == 0 ) return false;
		//SĂ̏NA΂sqtd
		//System.out.println(filename+"contain x:"+x+"y:"+y);
		return true;
	}
	
	/**
	 * ݂̃Z̏𕶎񉻂
	 */
	public String toString() {
		int n , tc;
		StringBuffer sb = new StringBuffer() ;
		sb.append("(");
		sb.append(this.filename);sb.append(" ");
		sb.append(this.posSize.x);sb.append(" ");
		sb.append(this.posSize.y);sb.append(" ");
		sb.append(this.posSize.width);sb.append(" ");
		sb.append(this.posSize.height);sb.append(" ");
		if (view) sb.append("1 ");
		else sb.append("0 ");
		if (viewwm) sb.append("1 ");
		else sb.append("0 ");
		for (  n = 0 ; n < this.transColors.size() ; n++  ) {
			tc =  this.transColors.get(n)[0] ;
			sb.append( Integer.toHexString(tc) );
		}
		sb.append("(");		
		return sb.toString();
	}
	
}
