<?php
/**
* @version $Id: index.php 4807 2006-08-28 17:30:12Z stingrey $
* @package Joomla
* @copyright Copyright (C) 2005 Open Source Matters. All rights reserved.
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL, see LICENSE.php
* Joomla! is free software. This version may have been modified pursuant
* to the GNU General Public License, and as distributed it includes or
* is derivative of works licensed under the GNU General Public License or
* other free or open source software licenses.
* See COPYRIGHT.php for copyright notices and details.
*/

// Set flag that this is a parent file
define( '_VALID_MOS', 1 );

if (file_exists( '../configuration.php' ) && filesize( '../configuration.php' ) > 10) {
	header( "Location: ../index.php" );
	exit();
}
require( '../globals.php' );
require_once( '../includes/version.php' );
//mbstringエミュレータ
if (!extension_loaded('mbstring')) {
    include('../includes/mb_emulator/mb-emulator.php');
}
//htaccess.txtが使えない時のPHP設定
//@ini_set('default_charset', "UTF-8");
//@ini_set('mbstring.language', "neutral");
//@ini_set('mbstring.internal_encoding', "UTF-8");
//@ini_set('mbstring.http_input', "auto");

/** Include common.php */
include_once( 'common.php' );
view();

/*
 * Added 1.0.11
 */
function view() {	
	$sp 		= ini_get( 'session.save_path' );
	
	$_VERSION 		= new joomlaVersion();				 	
	$versioninfo 	= $_VERSION->RELEASE .'.'. $_VERSION->DEV_LEVEL .' '. $_VERSION->DEV_STATUS;
	$version 		= $_VERSION->PRODUCT .' '. $_VERSION->RELEASE .'.'. $_VERSION->DEV_LEVEL .' '. $_VERSION->DEV_STATUS.' [ '.$_VERSION->CODENAME .' ] '. $_VERSION->RELDATE .' '. $_VERSION->RELTIME .' '. $_VERSION->RELTZ;
	
	echo "<?xml version=\"1.0\" encoding=\"UTF-8\"?".">";
	?>
	<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
	<html xmlns="http://www.w3.org/1999/xhtml">
	<head>
	<title>Joomla - Web インストーラ</title>
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
	<link rel="shortcut icon" href="../images/favicon.ico" />
	<link rel="stylesheet" href="install.css" type="text/css" />
	</head>
	<body>
	
	<div id="wrapper">
		<div id="header">
			<div id="joomla">
				<img src="header_install.png" alt="Joomla Installation" />
			</div>
		</div>
	</div>
	
	<div id="ctr" align="center">
		<div class="install">
			<div id="stepbar">
				<div class="step-on">設置前チェック</div>
				<div class="step-off">ライセンス</div>
				<div class="step-off">ステップ 1</div>
				<div class="step-off">ステップ 2</div>
				<div class="step-off">ステップ 3</div>
				<div class="step-off">ステップ 4</div>
			</div>
	
			<div id="right">
				<div id="step">設置前チェック</div>
	
				<div class="far-right">
					<input name="Button2" type="submit" class="button" value="次へ >>" onclick="window.location='install.php';" />
					<br/>
					<br/>
					<input type="button" class="button" value="もう一度チェック" onclick="window.location=window.location" />
				</div>
				<div class="clr"></div>				
					
				<h1 style="text-align: center; border-bottom: 0px;">
					<?php echo $version; ?>
				</h1>
	
				<h1>
					設置前チェック:
				</h1>
				
				<div class="install-text">
					<p>
						これらのアイテムが赤く強調されているなら修正して下さい。
					</p>
					<p>
						修正しないとJoomlaのインストールに失敗する場合があります。
					</p>
					<div class="ctr"></div>
				</div>
	
				<div class="install-form">
					<div class="form-block">
						<table class="content">
						<tr>
							<td class="item">
								PHP version >= 4.1.0
							</td>
							<td align="left">
								<?php echo phpversion() < '4.1' ? '<b><font color="red">No</font></b>' : '<b><font color="green">Yes</font></b>';?>
							</td>
						</tr>
						<tr>
							<td>
								&nbsp; - zlib compression support
							</td>
							<td align="left">
								<?php echo extension_loaded('zlib') ? '<b><font color="green">利用可能</font></b>' : '<b><font color="red">無効</font></b>';?>
							</td>
						</tr>
						<tr>
							<td>
								&nbsp; - XML support
							</td>
							<td align="left">
								<?php echo extension_loaded('xml') ? '<b><font color="green">利用可能</font></b>' : '<b><font color="red">無効</font></b>';?>
							</td>
						</tr>
						<tr>
							<td>
								&nbsp; - MySQL support
							</td>
							<td align="left">
								<?php echo function_exists( 'mysql_connect' ) ? '<b><font color="green">利用可能</font></b>' : '<b><font color="red">無効</font></b>';?>
							</td>
						</tr>
						<tr>
							<td valign="top" class="item">
								configuration.php
							</td>
							<td align="left">
								<?php
								if (@file_exists('../configuration.php') &&  @is_writable( '../configuration.php' )){
									echo '<b><font color="green">書込み可</font></b>';
								} else if (is_writable( '..' )) {
									echo '<b><font color="green">書込み可</font></b>';
								} else {
									echo '<b><font color="red">書込み不可</font></b><br /><span class="small">インストール終了後に表示される設定ファイルをコピーしてアップロードするならインストールを継続できます。</span>';
								} 
								?>
							</td>
						</tr>
						<tr>
							<td>
								&nbsp; - マルチバイト サポート
							</td>
							<td align="left">
							<?php echo extension_loaded('mbstring') ? '<b><font color="green">利用可能</font></b>' : '<b><font color="green">mb_emulatorを使用</font></b>';?>
							</td>
						</tr>
						<tr>
							<td class="item">
								Session save path
							</td>
							<td align="left" valign="top">
								<?php echo is_writable( $sp ) ? '<b><font color="green">書込み可</font></b>' : '<b><font color="red">書込み不可</font></b>';?>
							</td>
						</tr>
						<tr>
							<td class="item" colspan="2">
								<b>
									<?php echo $sp ? $sp : 'Not set'; ?>
								</b>
							</td>
						</tr>
						</table>
					</div>
				</div>
				<div class="clr"></div>
				
				<h1>
					バージョンチェック:
				</h1>
				
				<div class="install-text">
					<p>
						常に最新の Stable バージョンの Joomla! をインストールして下さい。
					</p>
					<p>
						<a href="http://www.joomla.org" target="_blank">www.joomla.org</a>で詳しい情報を確認して下さい。						
					</p>
					<div class="ctr"></div>
				</div>
						
				<div class="install-form">
					<div class="form-block" style="text-align: center;">
						<table class="content">
						<tr>
							<td class="item">
								<?php
								$link 			= 'http://www.joomla.org/content/blogcategory/32/66/';
								$status 		= 'status=yes,toolbar=yes,scrollbars=yes,titlebar=yes,menubar=yes,resizable=yes,directories=yes,location=yes';
								
								$release 		= strtotime($_VERSION->RELDATE);
								$now	 		= strtotime('now');
								$age			= ($now - $release) / 86400;	
								$age			= round($age);		
								?>
								<div style="clear: both; margin: 3px; padding: 0px 0px; display: block; float: left;">
									<table cellpadding="0" cellspacing="0" border="0" width="100%" class="adminheading">
									<tr>
										<td colspan="2" style="text-align: center;">
											<h3 style="font-size: 12px;">
												<?php
												if ($age < 1) {							
													?>
													<p style="font-weight: normal; padding: 0px; margin: 0px; font-size: 11px;">
														このJoomla! [ <?php echo $versioninfo; ?> ] は  
													</p>
													<div style="font-size: 13px; color: #cc0000;">
														<?php echo $age; ?> 前にリリースされています
													</div>
													<?php
												}
												?>
												<div style="margin-top: 10px;">
													<input name="Button3" type="submit" value="最新バージョンをチェック" onclick="window.open('<?php echo $link; ?>','win2','<?php echo $status; ?>'); return false;" />							
												</div>
											</h3>
										</td>
									</tr>
								    </table>
								</div>
							</td>
						</tr>
						</table>
					</div>
				</div>	
				<div class="clr"></div>		
				
				<?php
				$wrongSettingsTexts = array();
				
				if ( ini_get('magic_quotes_gpc') != '1' ) {
					$wrongSettingsTexts[] = 'PHP magic_quotes_gpc 設定が `OFF` になっています `ON`へ変更して下さい。';
				}
				if ( ini_get('register_globals') == '1' ) {
					$wrongSettingsTexts[] = 'PHP register_globals 設定が `ON` になっています `OFF` へ変更して下さい。';
				}
				if ( RG_EMULATION != 0 ) {
					$wrongSettingsTexts[] = 'Joomla! RG_EMULATION 設定は `ON` になっています `OFF` へ変更して下さい。<br /><span style="font-weight: normal; font-style: italic; color: #666;">互換性の為globals.phpファイルのデフォルトは`ON` になっています。</span>';
				}	
	
				if ( count($wrongSettingsTexts) ) {
					?>							
					<h1>
						セキュリティチェック:
					</h1>
					
					<div class="install-text">
						<p>
							PHPサーバ設定が<strong>セキュリティ</strong>上の問題を含んでいます。以下の項目を変更して下さい:
						</p>
						<p>
							Please check <a href="http://forum.joomla.org/index.php/topic,81058.0.html" target="_blank">the Official Joomla! Server Security post</a> for more information.<br/>
							日本語での投稿は<a href="http://forum.joomla.jp/component/option,com_smf/Itemid,37/board,14.0/" target="_blank">こちら</a>
						</p>
						<div class="ctr"></div>
					</div>
							
					<div class="install-form">
						<div class="form-block" style=" border: 1px solid #cc0000; background: #ffffcc;">
							<table class="content">
							<tr>
								<td class="item">
									<ul style="margin: 0px; padding: 0px; padding-left: 5px; text-align: left; padding-bottom: 0px; list-style: none;">
										<?php
										foreach ($wrongSettingsTexts as $txt) {
											?>	
											<li style="min-height: 25px; padding-bottom: 5px; padding-left: 25px; color: red; font-weight: bold; background-image: url(../includes/js/ThemeOffice/warning.png); background-repeat: no-repeat; background-position: 0px 2px;" >
												<?php
												echo $txt;
												?>
											</li>
											<?php
										}
										?>
									</ul>
								</td>
							</tr>
							</table>
						</div>
					</div>
					<div class="clr"></div>
					<?php
				}
				?>
												
				<h1>
					お勧め設定:
				</h1>
				
				<div class="install-text">
					<p>
						Joomla!を正常に作動させる為にこれらの設定が
						推薦されています。
					</p>					
					<p>
						しかし完全に同じではなくてもJoomla!は作動するかもしれません。<b>JP版は青文字のディレクティブを同じに設定しなければ正常作動しません。</b>
					</p>
					<div class="ctr"></div>
				</div>
		
				<div class="install-form">
					<div class="form-block">
		
						<table class="content">
						<tr>
							<td class="toggle" width="500px">
								ディレクティブ
							</td>
							<td class="toggle">
								お勧め
							</td>
							<td class="toggle">
								現在
							</td>
						</tr>
						<?php
						$php_recommended_settings = array(array ('Safe Mode','safe_mode','OFF'),
							array ('Display Errors','display_errors','ON'),
							array ('File Uploads','file_uploads','ON'),
							array ('Magic Quotes GPC','magic_quotes_gpc','ON'),
							array ('Magic Quotes Runtime','magic_quotes_runtime','OFF'),
							array ('Register Globals','register_globals','OFF'),
							array ('Output Buffering','output_buffering','OFF'),
							array ('Session auto start','session.auto_start','OFF'),
						);
						
						foreach ($php_recommended_settings as $phprec) {
							?>
							<tr>
								<td class="item">
									<?php echo $phprec[0]; ?>:
								</td>
								<td class="toggle">
									<?php echo $phprec[2]; ?>:
								</td>
								<td>
									<b>
										<?php
										if ( get_php_setting($phprec[1]) == $phprec[2] ) {
											?>
											<font color="green">
											<?php
										} else {
											?>
											<font color="red">
											<?php
										}
										echo get_php_setting($phprec[1]);
										?>
										</font>
									</b>
								<td>
							</tr>
							<?php
						}
						?>
						<tr>
							<td class="item">
								Register Globals Emulation:
							</td>
							<td class="toggle">
								OFF:
							</td>
							<td>
								<?php
								if ( RG_EMULATION ) {
									?>
									<font color="red"><b>
									<?php
								} else {
									?>
									<font color="green"><b>
									<?php
								}
								echo ((RG_EMULATION) ? 'ON' : 'OFF');
								?>
								</b>
								</font>
							<td>
						</tr>
						<tr>
							<td class="item"><font color="blue">mbstring.language:</font></td>
							<td class="toggle">neutral:</td>
							<td><?php
								if(ini_get('mbstring.language') == "neutral") {
								?>
								<font color="green"><b>
								<?php
								}else{
								?>
								<font color="red"><b>
								<?php
								}
								echo ini_get('mbstring.language');
								?>
								</b>
								</font>
							<td>
						</tr>
						<tr>
							<td class="item"><font color="blue">mbstring.internal_encoding:</font></td>
							<td class="toggle">UTF-8:</td>
							<td><?php if(ini_get('mbstring.internal_encoding') == "UTF-8") {
								?>
								<font color="green"><b>
								<?php
								}else{
								?>
								<font color="red"><b>
								<?php
								}
								echo ini_get('mbstring.internal_encoding');
								?>
								</b>
								</font>
							<td>
						</tr>
						<tr>
							<td class="item"><font color="blue">mbstring.encoding_translation:</font></td>
							<td class="toggle">OFF:</td>
							<?php
							$mb_string_encoding_translation_bool = FALSE;
							if (ini_get('mbstring.encoding_translation')){
								$mb_string_encoding_translation = strtolower(ini_get('mbstring.encoding_translation'));
								if($mb_string_encoding_translation != 'off') {
									$mb_string_encoding_translation_bool = TRUE;
								}
							}else{
								$mb_string_encoding_translation_bool = FALSE;
							}
							?>
							<td><?php if(!$mb_string_encoding_translation_bool) {
										$mbstring_encoding_translation = 'Off';
								?>
								<font color="green"><b>
								<?php
								}else{
									$mbstring_encoding_translation = 'On';
								?>
								<font color="red"><b>
								<?php
								}
								echo $mbstring_encoding_translation;
								?>
								</b>
								</font>
							<td>
						</tr>
						<tr>
							<td class="item"><font color="blue">mbstring.http_input:</font></td>
							<td class="toggle">auto:</td>
							<td><?php if(ini_get('mbstring.http_input') == "auto") {
								?>
								<font color="green"><b>
								<?php
								}else{
								?>
								<font color="red"><b>
								<?php
								}
								echo ini_get('mbstring.http_input');
								?>
								</b>
								</font>
							<td>
						</tr>
						<tr>
							<td class="item"><font color="blue">mbstring.http_output:</font></td>
							<td class="toggle">pass:</td>
							<td><?php if(ini_get('mbstring.http_output') == "pass") {
								?>
								<font color="green"><b>
								<?php
								}else{
								?>
								<font color="red"><b>
								<?php
								}
								echo ini_get('mbstring.http_output');
								?>
							</b>
							</font>
							<td>
						</tr>
						<tr>
							<td class="item" rowspan="3"><?php josmbstringCheck(100);?></td>
						</tr>
						</table>
					</div>
				</div>
				<div class="clr"></div>
		
				<h1>
					ディレクトリとファイルパーミッション:
				</h1>
				
				<div class="install-text">
					<p>
						Joomlaが正常に作動するようにするにはディレクトリとファイルパーミッションの設定が必要です。
					</p>
					<p>
						もし"書込み不可" になっているなら該当するディレクトリに書込み権限を設定して下さい。
					</p>
					<div class="clr">&nbsp;&nbsp;</div>
					<div class="ctr"></div>
				</div>
		
				<div class="install-form">
					<div class="form-block">	
						<table class="content">
						<?php
						writableCell( 'administrator/backups' );
						writableCell( 'administrator/components' );
						writableCell( 'administrator/modules' );
						writableCell( 'administrator/templates' );
						writableCell( 'cache' );
						writableCell( 'components' );
						writableCell( 'images' );
						writableCell( 'images/banners' );
						writableCell( 'images/stories' );
						writableCell( 'language' );
						writableCell( 'mambots' );
						writableCell( 'mambots/content' );
						writableCell( 'mambots/editors' );
						writableCell( 'mambots/editors-xtd' );
						writableCell( 'mambots/search' );
						writableCell( 'mambots/system' );
						writableCell( 'media' );
						writableCell( 'modules' );
						writableCell( 'templates' );
						?>
						</table>
					</div>
					<div class="clr"></div>
				</div>
	
				
				<div class="clr"></div>
			</div>
			<div class="clr"></div>
		</div>
	</div>
	
	<div class="ctr">
		<a href="http://www.joomla.org" target="_blank">Joomla!</a> is Free Software released under the GNU/GPL License.
	</div>
	
	</body>
	</html>
	<?php
}

function get_php_setting($val) {
	$r =  (ini_get($val) == '1' ? 1 : 0);
	return $r ? 'ON' : 'OFF';
}

function writableCell( $folder, $relative=1, $text='' ) {
	$writeable 		= '<b><font color="green">Writeable</font></b>';
	$unwriteable 	= '<b><font color="red">Unwriteable</font></b>';
	
	echo '<tr>';
	echo '<td class="item">' . $folder . '/</td>';
	echo '<td align="right">';
	if ( $relative ) {
		echo is_writable( "../$folder" ) 	? $writeable : $unwriteable;
	} else {
		echo is_writable( "$folder" ) 		? $writeable : $unwriteable;
	}
	echo '</tr>';
}
/*
 * JP Added 1.0.11JP
 */
	function josmbstringCheck($width='95%') {
			$mbstringSettingsTexts = array();
		$mb_emulator_use = "";
		$mb_string_encoding_translation_bool = FALSE;

		if( !extension_loaded('mbstring') ){
			$mbstringSettingsTexts[] = 'mb_emulatorを使用中です。文字化けする場合はApacheの設定を見直してください<br />一部マンボットが正常に作動しません';
			$mb_emulator_use = true;
		}
		if( !$mb_emulator_use ){
			if( ini_get('mbstring.language' ) != "neutral") {
				$mbstringSettingsTexts[] = 'mbstring.languageが'.ini_get('mbstring.language').'になっています `neutral`に設定して下さい';
			}
			if( ini_get('mbstring.internal_encoding' ) != "UTF-8") {
				$mbstringSettingsTexts[] = 'mbstring.internal_encodingが'.ini_get('mbstring.internal_encoding').'になっています `UTF-8`に設定して下さい';
			}
			//mbstring.encoding_translation String or bool
			if ( ini_get('mbstring.encoding_translation' ) ) {
				$mb_string_encoding_translation = strtolower(ini_get('mbstring.encoding_translation'));
				if($mb_string_encoding_translation != 'off') {
					$mb_string_encoding_translation_bool = TRUE;
				}
			}else{
				$mb_string_encoding_translation_bool = FALSE;
			}
			if($mb_string_encoding_translation_bool) {
				$mbstringSettingsTexts[] = 'mbstring.encoding_translationが'.ini_get('mbstring.encoding_translation').'になっています `Off`に設定して下さい';
			}
			if(ini_get('mbstring.http_input') != "auto") {
				$mbstringSettingsTexts[] = 'mbstring.http_inputが'.ini_get('mbstring.http_input').'になっています `auto`に設定して下さい';
			}
			if(ini_get('mbstring.http_output') != "pass") {
				$mbstringSettingsTexts[] = 'mbstring.http_outputが'.ini_get('mbstring.http_output').'になっています `pass`に設定して下さい';
			}
		}
		if ( count($mbstringSettingsTexts) ) {
		?>
		<div style="clear: both; margin: 3px; margin-top: 10px; padding: 5px 15px; display: block; float: left; border: 1px solid #cc0000; background: #ffffcc; text-align: left; width: <?php echo $width;?>;">
			<p style="color: #CC0000;">
				PHPサーバ設定がJoomla!を<strong>日本語環境で</strong>使用する場合の問題を含んでいます。以下の項目を変更して下さい:
			</p>			
			<ul style="margin: 0px; padding: 0px; padding-left: 15px; list-style: none;" >
				<?php
				foreach ($mbstringSettingsTexts as $txt) {
					?>	
					<li style="min-height: 25px; padding-bottom: 5px; padding-left: 25px; color: red; font-weight: bold; background-image: url(../includes/js/ThemeOffice/warning.png); background-repeat: no-repeat; background-position: 0px 2px;" >
						<?php
						echo $txt;
						?>
					</li>
					<?php
				}
				?>
			</ul>
			<p style="color: #666;">
			<?php
			if( eregi('apache',PHP_SAPI) || substr(php_sapi_name(), 0, 6) == 'apache'){		
			?>
				多くの場合、htaccess.txtファイルの該当ディレクティブコメントアウトを外して.htaccessにリネームして設置する事で解消できます。
			<?php
			}elseif(substr(php_sapi_name(), 0, 3) == 'cgi'){
			?>
				多くの場合、php.iniファイルに 該当ディレクティブ = 設定値 と記入したファイルを設置する事でで解消できます。
			<?php
			}else{
			?>
				HTTPサーバでのPHP設定方法を確認して設定を変更して下さい。
			<?php
			}
			?>
			</p>
			<p style="color: #333;">
			ファイルはJoomla!を設置したルートディレクトリに設置して下さい。
			一部の設定情報は正確に取得できない場合があります。
			</p>
		</div>
		<?php
	}
	}
?>