/*
 * Decompiled with CFR 0.152.
 */
package net.osdn.jpki.wrapper;

import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.Win32Exception;
import com.sun.jna.platform.win32.WinReg;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.jar.JarInputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.osdn.jpki.wrapper.InternalClassLoader;
import net.osdn.jpki.wrapper.JpkiException;
import net.osdn.jpki.wrapper.JpkiWrapperInternal;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.SignatureOptions;

public class JpkiWrapper {
    private static volatile ClassLoader loader;
    private String applicationName;
    private String applicationVersion;
    private JpkiWrapperInternal impl;
    private static Pattern ERROR_CODE_PATTERN;

    public static boolean isAvailable() {
        return JpkiWrapper.getJpkiInstallPath() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public JpkiWrapper() throws JpkiException, IOException, ReflectiveOperationException {
        if (loader == null) {
            Class<JpkiWrapper> clazz = JpkiWrapper.class;
            // MONITORENTER : net.osdn.jpki.wrapper.JpkiWrapper.class
            if (loader == null) {
                File jpkiInstallPath = JpkiWrapper.getJpkiInstallPath();
                if (jpkiInstallPath == null) {
                    throw new JpkiException("JPKI user software was not found. Make sure that the JPKI user software is correctly installed.", "JPKI\u5229\u7528\u8005\u30bd\u30d5\u30c8\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3067\u3057\u305f\u3002JPKI\u5229\u7528\u8005\u30bd\u30d5\u30c8\u304c\u6b63\u3057\u304f\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u3055\u308c\u3066\u3044\u308b\u3053\u3068\u3092\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044\u3002", null);
                }
                loader = JpkiWrapper.createLoader(jpkiInstallPath);
            }
            // MONITOREXIT : clazz
        }
        Class<?> cls = loader.loadClass("net.osdn.jpki.wrapper.internal.JpkiWrapperImpl");
        this.impl = (JpkiWrapperInternal)cls.getConstructor(new Class[0]).newInstance(new Object[0]);
    }

    public void setApplicationName(String name) {
        this.applicationName = name;
    }

    public void setApplicationVersion(String version) {
        this.applicationVersion = version;
    }

    public void addSignature(OutputStream output, PDDocument document) throws JpkiException, IOException {
        this.addSignature(output, document, null, null, null, null, null, null);
    }

    public void addSignature(OutputStream output, PDDocument document, SignatureOptions options) throws JpkiException, IOException {
        this.addSignature(output, document, null, null, null, null, null, options);
    }

    public void addSignature(OutputStream output, PDDocument document, String name, String reason, Date date, String location, String contact, SignatureOptions options) throws JpkiException, IOException {
        try {
            this.impl.addSignature(output, document, name, reason, date, location, contact, options, this.applicationName, this.applicationVersion);
        }
        catch (IOException e) {
            Matcher m;
            String message = e.getMessage();
            if (message != null && message.charAt(0) == '!' && (m = ERROR_CODE_PATTERN.matcher(message)).matches()) {
                int errorCode = Integer.parseInt(m.group(1));
                int winErrorCode = Integer.parseInt(m.group(2));
                throw new JpkiException(errorCode, winErrorCode, e.getCause());
            }
            throw e;
        }
    }

    private static ClassLoader createLoader(File jpkiInstallPath) throws IOException {
        String[] stringArray;
        if (JpkiWrapper.is64bitJavaVM()) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = "JPKICryptSignJNI64.jar";
            stringArray = stringArray2;
            stringArray2[1] = "JPKIUserCertService64.jar";
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = "JPKICryptSignJNI.jar";
            stringArray = stringArray3;
            stringArray3[1] = "JPKIUserCertService.jar";
        }
        String[] jarNames = stringArray;
        ArrayList<URL> urls = new ArrayList<URL>();
        for (String jarName : jarNames) {
            File jar = new File(jpkiInstallPath, jarName);
            if (!jar.exists()) continue;
            urls.add(jar.toURI().toURL());
        }
        String internalJar = JpkiWrapper.is64bitJavaVM() ? "/jpki-wrapper-internal64.jar" : "/jpki-wrapper-internal32.jar";
        try (InputStream in = JpkiWrapper.class.getResourceAsStream(internalJar);){
            InternalClassLoader internalClassLoader;
            try (JarInputStream jar = new JarInputStream(in);){
                InternalClassLoader loader;
                internalClassLoader = loader = new InternalClassLoader(urls.toArray(new URL[0]), jar);
            }
            return internalClassLoader;
        }
    }

    private static boolean is64bitJavaVM() {
        String s = System.getProperty("os.arch");
        return s != null && s.contains("64");
    }

    private static File getJpkiInstallPath() {
        block4: {
            try {
                File dir;
                String path1 = Advapi32Util.registryGetStringValue((WinReg.HKEY)WinReg.HKEY_LOCAL_MACHINE, (String)"SOFTWARE\\JPKI", (String)"InstallPath");
                if (path1 != null && (dir = new File(path1)).isDirectory()) {
                    return dir;
                }
            }
            catch (Exception e) {
                if (e instanceof Win32Exception && ((Win32Exception)e).getErrorCode() == 2) break block4;
                e.printStackTrace();
            }
        }
        String path2 = JpkiWrapper.findPath("JPKIMenu.exe");
        if (path2 != null) {
            return new File(path2).getParentFile();
        }
        return null;
    }

    private static String findPath(String executableFilename) {
        char[] pszPath = new char[1024];
        Pointer ppszOtherDirs = Pointer.NULL;
        char[] src = executableFilename.toCharArray();
        System.arraycopy(src, 0, pszPath, 0, src.length);
        boolean ret = Shlwapi.INSTANCE.PathFindOnPathW(pszPath, ppszOtherDirs);
        if (ret) {
            return new String(pszPath).trim();
        }
        return null;
    }

    static {
        ERROR_CODE_PATTERN = Pattern.compile("!ErrorCode=(-?[0-9]+),WinErrorCode=(-?[0-9]+)");
    }

    public static interface Shlwapi
    extends Library {
        public static final Shlwapi INSTANCE = (Shlwapi)Native.load((String)"shlwapi", Shlwapi.class);

        public boolean PathFindOnPathW(char[] var1, Pointer var2);
    }
}

