/*
 * Decompiled with CFR 0.152.
 */
package net.osdn.util.javafx.event;

import java.util.concurrent.Callable;
import net.osdn.util.javafx.event.SilentWrappedException;

@FunctionalInterface
public interface SilentCallable<V> {
    public V call() throws Exception;

    public static <V> Callable<V> wrap(SilentCallable<V> callable) {
        return () -> {
            try {
                return callable.call();
            }
            catch (Exception e) {
                Thread.UncaughtExceptionHandler ueh = Thread.currentThread().getUncaughtExceptionHandler();
                if (ueh != null) {
                    ueh.uncaughtException(Thread.currentThread(), e);
                    return null;
                }
                throw new SilentWrappedException(e);
            }
        };
    }
}

