/*
 * Decompiled with CFR 0.152.
 */
package net.osdn.util.javafx.event;

import javafx.util.Callback;
import net.osdn.util.javafx.event.SilentWrappedException;

@FunctionalInterface
public interface SilentCallback<P, R> {
    public R call(P var1) throws Exception;

    public static <P, R> Callback<P, R> wrap(SilentCallback<P, R> callback) {
        return param -> {
            try {
                return callback.call(param);
            }
            catch (Exception e) {
                Thread.UncaughtExceptionHandler ueh = Thread.currentThread().getUncaughtExceptionHandler();
                if (ueh != null) {
                    ueh.uncaughtException(Thread.currentThread(), e);
                    return null;
                }
                throw new SilentWrappedException(e);
            }
        };
    }
}

