/*
 * Decompiled with CFR 0.152.
 */
package net.osdn.util.javafx.event;

import javafx.event.Event;
import javafx.event.EventHandler;
import net.osdn.util.javafx.event.SilentWrappedException;

@FunctionalInterface
public interface SilentEventHandler<T extends Event> {
    public void handle(T var1) throws Exception;

    public static <T extends Event> EventHandler<T> wrap(SilentEventHandler<T> handler) {
        return event -> {
            try {
                handler.handle(event);
            }
            catch (Exception e) {
                Thread.UncaughtExceptionHandler ueh = Thread.currentThread().getUncaughtExceptionHandler();
                if (ueh != null) {
                    ueh.uncaughtException(Thread.currentThread(), e);
                    return;
                }
                throw new SilentWrappedException(e);
            }
        };
    }
}

