/*
 * Decompiled with CFR 0.152.
 */
package net.osdn.util.javafx.event;

import net.osdn.util.javafx.event.SilentWrappedException;

@FunctionalInterface
public interface SilentRunnable {
    public void run() throws Exception;

    public static Runnable wrap(SilentRunnable runnable) {
        return () -> {
            try {
                runnable.run();
            }
            catch (Exception e) {
                Thread.UncaughtExceptionHandler ueh = Thread.currentThread().getUncaughtExceptionHandler();
                if (ueh != null) {
                    ueh.uncaughtException(Thread.currentThread(), e);
                }
                throw new SilentWrappedException(e);
            }
        };
    }
}

