/*
 * @(#)CursorEndException.java
 *
 * Copyright (c) 2005 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.commons.exception;


/**
 * カーソル位置終端検知例外.
 * <BR><BR>
 * 実行カーソル位置が終端を検知した場合に返されます.
 *  
 * @version 1.0.0 2003/10/27
 * @author  masahito suzuki
 * @since   JRcCommons 1.00
 */
public class CursorEndException extends CursorOverException
{
    /**
     * コンタストラクタ.
     */
    public CursorEndException()
    {
        super() ;
    }
    
    /**
     * コンタストラクタ.
     * <BR><BR>
     * オブジェクト生成と同時に発生原因のExceptionを設定します.
     * <BR>
     * @param e スローエラー対象の例外を設定します。
     */
    public CursorEndException(Throwable e)
    {
        super(e) ;
    }
    
    /**
     * コンタストラクタ.
     * <BR><BR>
     * オブジェクト生成と同時に発生原因のExceptionを設定します.
     * <BR>
     * @param e スローエラー対象の例外を設定します。
     */
    public CursorEndException(BaseException e)
    {
        super(e) ;
    }
    
    /**
     * コンタストラクタ.
     * <BR><BR>
     * オブジェクト生成と同時にメッセージを設定します.
     * <BR>
     * @param   message スローエラー生成時のメッセージを設定します。
     */
    public CursorEndException(String message)
    {
        super(message) ;
    }
}
