/*
 * @(#)CursorOverException.java
 *
 * Copyright (c) 2005 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.commons.exception;


/**
 * カーソル範囲外例外.
 * <BR><BR>
 * 実行カーソル位置が範囲外になったときに返されます.
 *  
 * @version 1.0.0 2003/10/27
 * @author  masahito suzuki
 * @since   JRcCommons 1.00
 */
public class CursorOverException extends AccessException
{
    /**
     * コンタストラクタ.
     */
    public CursorOverException()
    {
        super() ;
    }
    
    /**
     * コンタストラクタ.
     * <BR><BR>
     * オブジェクト生成と同時に発生原因のExceptionを設定します.
     * <BR>
     * @param e スローエラー対象の例外を設定します。
     */
    public CursorOverException(Throwable e)
    {
        super(e) ;
    }
    
    /**
     * コンタストラクタ.
     * <BR><BR>
     * オブジェクト生成と同時に発生原因のExceptionを設定します.
     * <BR>
     * @param e スローエラー対象の例外を設定します。
     */
    public CursorOverException(BaseException e)
    {
        super(e) ;
    }
    
    /**
     * コンタストラクタ.
     * <BR><BR>
     * オブジェクト生成と同時にメッセージを設定します.
     * <BR>
     * @param   message スローエラー生成時のメッセージを設定します。
     */
    public CursorOverException(String message)
    {
        super(message) ;
    }
}
