/*
 * @(#)WriterCommon.java
 *
 * Copyright (c) 2005 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.commons.io;

import org.maachang.commons.exception.InputException;


/**
 * 指定情報を出力します.
 * <BR><BR>
 * 指定された情報に対して、出力します.
 *
 * @version 1.0.0 2003/11/03
 * @author  masahito suzuki
 * @since   JRcCommons 1.00
 */
public interface BaseWriter
{
    /**
     * ファイルクローズ.
     * <BR><BR>
     * オープンしているファイル情報をクローズします.
     * また、バッファに対して情報が存在する場合、その情報を
     * 書き込んでクローズします.
     */
    public void close() ;
    
    /**
     * バッファ情報を出力.
     * <BR><BR>
     * バッファ情報をファイルに出力します。
     * <BR>
     * @exception FileAccessException ファイルIO例外
     */
    public void flush() throws FileAccessException ;
    
    /**
     * 文字情報を出力.
     * <BR><BR>
     * 文字情報を出力します。
     * <BR>
     * @param stream 文字情報を設定します。
     * @exception InputException 入力例外
     * @exception FileAccessException ファイルアクセス例外.
     */
    public void print(String stream)
        throws InputException,FileAccessException ;
    
    /**
     * １行の文字情報を出力.
     * <BR><BR>
     * １行の文字情報を出力します。
     * <BR>
     * @exception FileAccessException ファイルアクセス例外.
     */
    public void println()
        throws FileAccessException ;
    
    /**
     * １行の文字情報を出力.
     * <BR><BR>
     * １行の文字情報を出力します。
     * <BR>
     * @param stream 文字情報を設定します。
     * @exception InputException 入力例外
     * @exception FileAccessException ファイルアクセス例外.
     */
    public void println( String stream )
        throws InputException,FileAccessException ;
    
    /**
     * 書き込み容量の取得.
     * <BR><BR>
     * 現在のファイル書き込み容量を取得します。
     * また、現在バッファに格納されている情報数も数に含まれます.
     * <BR>
     * @return long ファイル書き込み容量を取得します。<BR>
     *              ファイルがオープンされていない場合[-1]が返されます.
     */
    public long length() ;
    
    /**
     * オープンファイル名の取得.
     * <BR><BR>
     * 現在オープンされているファイル名の取得を行います。
     * <BR>
     * @return String 現在オープンされているファイル名を取得します。<BR>
     *   オープンされていない場合[null]が格納されます。
     */
    public String getFileName() ;
    
    /**
     * 現在状況を取得します。
     * <BR><BR>
     * 現在のファイルオープン状況を取得します。
     * <BR>
     * @return boolean 現在のファイルオープン状況が格納されています。<BR>
     *   [true]が返された場合、ファイルはオープンされています。<BR>
     *   [false]が返された場合、ファイルはオープンされていません。
     */
    public boolean isOpen() ;
    
}
