/*
 * @(#)NetAdapterBase.java
 *
 * Copyright (c) 2005 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.commons.net;

import org.maachang.commons.exception.AccessException;

/**
 * ネットワークアダプタ情報.
 * <BR><BR>
 * ネットワークアダプタ情報をサポートします.
 *  
 * @version 1.0.0 2004/10/15
 * @author  masahito suzuki
 * @since   JRcCommons 1.00
 */
public interface NetAdapter
{
    
    /**
     * 情報カテゴリ : IPアドレス.
     */
    public static final String CATEGORY_IPADDR = "ip-addr" ;
    
    /**
     * 情報カテゴリ : サブネットアドレス.
     */
    public static final String CATEGORY_SUBNET = "sub-net" ;
    
    /**
     * 情報カテゴリ : MACアドレス.
     */
    public static final String CATEGORY_MACADDR = "mac-addr" ;
    
    /**
     * 情報クリア.
     * <BR><BR>
     * 情報をクリアします.
     */
    public void clear() ;
    
    /**
     * ネットワーク情報取得処理.
     * <BR><BR>
     * 対象のネットワーク情報を取得します.
     * <BR>
     * @exception AccessException アクセス例外.
     */
    public void flush() throws AccessException ;
    
    /**
     * 対象カテゴリ情報数を取得.
     * <BR><BR>
     * 対象カテゴリの格納情報数を取得します.
     * <BR>
     * @param name 対象の媒体名(LANの場合[eth0]など.)を設定します.
     * @param category 対象のカテゴリ名を設定します.<BR>
     *                 [NetAdapterBase.CATEGORY_IPADDR]を指定した場合、IPアドレス追加となります.<BR>
     *                 [NetAdapterBase.CATEGORY_SUBNET]を指定した場合、サブネットアドレス追加となります.<BR>
     *                 [NetAdapterBase.CATEGORY_MACADDR]を指定した場合、MACアドレス追加となります.
     * @param no 対象の項番を設定します.
     * @return String カテゴリ内容が返されます.
     */
    public String getCategory( String name,String category,int no ) ;
    
    /**
     * 対象カテゴリ情報数を取得.
     * <BR><BR>
     * 対象カテゴリの格納情報数を取得します.
     * <BR>
     * @param name 対象の媒体名(LANの場合[eth0]など.)を設定します.
     * @param category 対象のカテゴリ名を設定します.<BR>
     *                 [NetAdapterBase.CATEGORY_IPADDR]を指定した場合、IPアドレス追加となります.<BR>
     *                 [NetAdapterBase.CATEGORY_SUBNET]を指定した場合、サブネットアドレス追加となります.<BR>
     *                 [NetAdapterBase.CATEGORY_MACADDR]を指定した場合、MACアドレス追加となります.
     * @return int 情報長が返されます.
     */
    public int getElement( String name,String category ) ;
    
    /**
     * 媒体名群の取得.
     * <BR><BR>
     * 対象媒体名群を取得します.
     * <BR>
     * @return String[] 格納されている媒体名群を取得します.
     */
    public String[] getNames() ;
    
}

