/*
 * @(#)Callback.java
 *
 * Copyright (c) 2005 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.commons.thread;

import org.maachang.commons.exception.ExecutionException;

/**
 * コールバックインターフェイス.
 * <BR><BR>
 * コールバックインターフェイスをサポートします。<BR>
 * このインターフェイスは、継承されたオブジェクトに対し、コールバック
 * 処理を提供します.
 * <BR>
 *
 * @version 1.0.0 2002/10/27
 * @author  masahito suzuki
 * @since  JRcCommons 1.00
 */
public interface Callback
{
    
    /**
     * コールバック初期化処理.
     * <BR><BR>
     * コールバック初期化処理を行います.<BR>
     * このメソッドは、コールバック先のオブジェクトで初期化処理を実施
     * する場合、呼び出されます.
     * <BR>
     * @param info オブジェクト情報を設定します.
     * @return Object 処理結果の内容が返されます.
     * @exception ExecutionException 実行例外.
     */
    public Object init(Object info) throws ExecutionException ;
    
    /**
     * コールバック終了化処理.
     * <BR><BR>
     * コールバック終了化処理を行います.<BR>
     * このメソッドは、コールバック先のオブジェクトで終了化処理を実施
     * する場合呼び出されます.
     * <BR>
     * @param info オブジェクト情報を設定します.
     * @return Object 処理結果の内容が返されます.
     * @exception ExecutionException 実行例外.
     */
    public Object exit(Object info) throws ExecutionException ;
    
    /**
     * コールバック実行処理.
     * <BR><BR>
     * コールバック先のオブジェクトから、実施された場合呼び出されます.
     * <BR>
     * @param info オブジェクト情報を設定します.
     * @return Object 処理結果の内容が返されます.
     * @exception ExecutionException 実行例外.
     */
    public Object execution(Object info) throws ExecutionException ;
    
}
