/*
 * @(#)ProcessThread.java
 *
 * Copyright (c) 2005 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.commons.thread;

import org.maachang.commons.exception.ExecutionException;

/**
 * コアスレッド処理部.
 * <BR><BR>
 * コアスレッドでの実行処理を実施します.<BR>
 * また、このオブジェクトはパッケージ内用です.
 *
 * @version     1.00, 2003/10/26
 * @author      Masahito Suzuki
 * @since  JRcCommons 1.00
 */
abstract class ProcessThread
{
    /**
     * コンストラクタ.
     */
    public ProcessThread()
    {
    }
    
    /**
     * スレッド実行.
     * <BR><BR>
     * スレッド実行を行う処理部を実装します.
     * @param in スレッド処理での引数情報を指定します.
     * @exception ExecutionException 実行例外.
     * @exception ThreadDeath スレッド破棄通知.
     */
    protected abstract void processThread( Object in )
        throws ExecutionException,ThreadDeath ;
    
    /**
     * スレッド破棄時の処理.
     * <BR><BR>
     * スレッド破棄時の処理を生成します.
     * <BR>
     * @param in スレッド処理で渡される引数情報です.
     * @exception Exception 処理エラーを設定します.
     */
    protected abstract void destroyThread( Object in )
        throws Exception ;
    
    /**
     * スレッド例外発生処理実施.
     * <BR><BR>
     * スレッド処理での例外が発生した場合、実施されます.
     * <BR>
     * @param err 実行例外が返されます.
     */
    protected abstract void toException( ExecutionException err ) ;
    
}

