/*
 * @(#)MaachangQStartup.java
 *
 * Copyright (c) 2007 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.queue ;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.maachang.commons.net.NetConfig;
import org.maachang.commons.util.UtilCom;
import org.maachang.queue.config.MqDefine;
import org.maachang.queue.config.service.ConfigService;
import org.maachang.queue.connect.service.ClientConnectService;
import org.maachang.queue.main.channel.service.ChannelService;
import org.maachang.queue.main.manager.service.ManagerService;
import org.maachang.queue.main.queue.service.QueueService;
import org.maachang.queue.main.service.SaveAndLoadService;

/**
 * MaachangQスタートアップ.
 *  
 * @version 2007/01/25
 * @author  masahito suzuki
 * @since   MaachangQ 1.00
 */
class MaachangQStartup {
    
    /**
     * ログオブジェクト.
     */
    private static final Log LOG = LogFactory.getLog( MaachangQStartup.class ) ;
    
    /**
     * スリープ.
     */
    private static final int WAIT = 150 ;
    
    /**
     * 処理フラグ.
     */
    private boolean shutdownFlag = false ;
    
    /**
     * コンストラクタ.
     */
    public MaachangQStartup() { }
    
    
    /**
     * 初期化処理.
     * <BR><BR>
     * 初期化処理を行います.
     * <BR>
     * @param configDir 対象のコンフィグディレクトリ名を設定します.
     * @exception Exception 例外.
     */
    public void init( String configDir )
        throws Exception {
        
        LOG.info( "#### MaachangQサービス生成処理 ####" ) ;
        
        this.destroy( false ) ;
        
        try {
            if( configDir == null || ( configDir = configDir.trim() ).length() <= 0 ) {
                configDir = MqDefine.EMV_NAME+MqDefine.CONF_DIR ;
            }
            
            // ネットワークアダプタ情報を取得.
            NetConfig.getInstance().flush() ;
            
            shutdownFlag = true ;
            
            // コンフィグ情報を生成.
            new ConfigService().init( configDir ) ;
            
            // キューsaveAndLoadを生成.
            new SaveAndLoadService().init() ;
            
            // キューマネージャサービスを生成.
            new ManagerService().init() ;
            
            // キューサービスを生成.
            new QueueService().init() ;
            
            // チャネルサービスを生成.
            new ChannelService().init() ;
            
            // クライアントコネクションサービスを生成.
            new ClientConnectService().init() ;
            
        } catch( Exception e ) {
            this.destroy( false ) ;
            LOG.error( "#### MaachangQサービス生成時にエラーが発生",e ) ;
            throw e ;
        }
        
    }
    
    /**
     * 終了化処理.
     * <BR><BR>
     * 終了化処理を行います.
     */
    public void destroy() {
        this.destroy( true ) ;
    }
    
    /**
     * 終了化処理.
     * <BR><BR>
     * 終了化処理を行います.
     * <BR>
     * @param mode ログ表示モードを設定します.
     */
    public void destroy( boolean mode ) {
        
        if( mode == true ) {
            if( shutdownFlag == false ) {
                return ;
            }
            LOG.info( "#### MaachangQサービス破棄処理 ####" ) ;
        }
        
        try {
            // キューsaveAndLoadを破棄.
            new SaveAndLoadService().destroy( mode ) ;
        } catch( Exception e ) {
            if( mode == true ) {
                LOG.error( "#### MaachangQサービス破棄時にエラーが発生",e ) ;
            }
        }
        
        if( mode == true ) {
            UtilCom.sleep( WAIT ) ;
        }
        
        try {
            // クライアントコネクションサービスを破棄.
            new ClientConnectService().destroy( mode ) ;
        } catch( Exception e ) {
            if( mode == true ) {
                LOG.error( "#### MaachangQサービス破棄時にエラーが発生",e ) ;
            }
        }
        
        if( mode == true ) {
            UtilCom.sleep( WAIT ) ;
        }
        
        try {
            // キューサービスを破棄.
            new QueueService().destroy( mode ) ;
        } catch( Exception e ) {
            if( mode == true ) {
                LOG.error( "#### MaachangQサービス破棄時にエラーが発生",e ) ;
            }
        }
        
        if( mode == true ) {
            UtilCom.sleep( WAIT ) ;
        }
        
        try {
            // キューマネージャサービスを破棄.
            new ManagerService().destroy( mode ) ;
        } catch( Exception e ) {
            if( mode == true ) {
                LOG.error( "#### MaachangQサービス破棄時にエラーが発生",e ) ;
            }
        }
        
        if( mode == true ) {
            UtilCom.sleep( WAIT ) ;
        }
        
        try {
            // チャネルサービスを破棄.
            new ChannelService().destroy( mode ) ;
        } catch( Exception e ) {
            if( mode == true ) {
                LOG.error( "#### MaachangQサービス破棄時にエラーが発生",e ) ;
            }
        }
        
        if( mode == true ) {
            UtilCom.sleep( WAIT ) ;
        }
        
        try {
            // コンフィグ情報を破棄.
            new ConfigService().destroy( mode ) ;
        } catch( Exception e ) {
            if( mode == true ) {
                LOG.error( "#### MaachangQサービス破棄時にエラーが発生",e ) ;
            }
        }
        
        if( mode == true ) {
            UtilCom.sleep( WAIT ) ;
        }
        
        shutdownFlag = false ;
    }
    
}
