/*
 * @(#)ExecutionServerAdmin.java
 *
 * Copyright (c) 2007 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.queue.connect ;

import org.maachang.commons.util.CharTable;
import org.maachang.commons.util.NumberTable;
import org.maachang.queue.access.MaachangQErrorCode;
import org.maachang.queue.access.MaachangQException;
import org.maachang.queue.access.net.ConnectObject;
import org.maachang.queue.connect.admin.login.LoginManager;
import org.maachang.queue.connect.admin.login.LoginSession;
import org.maachang.queue.connect.common.ExecutionReceiveClient;
import org.maachang.queue.connect.common.Telegram;

/**
 * 管理者メッセージ実行処理.
 *
 * @version 2007/01/14
 * @author  Masahito Suzuki
 * @since   MaachangQ 1.00
 */
public class ExecutionServerAdmin implements ExecutionReceiveClient {
    
    /**
     * 処理管理オブジェクト.
     */
    private final NumberTable executionTable = new NumberTable() ;
    
    /**
     * コンストラクタ.
     */
    public ExecutionServerAdmin() {
        
    }
    
    /**
     * オブジェクト破棄.
     * <BR><BR>
     * オブジェクトを破棄します.
     * <BR>
     * @exception Exception 例外.
     */
    protected void finalize() throws Exception {
        this.executionTable.clear() ;
    }
    
    /**
     * 処理オブジェクト追加.
     * <BR><BR>
     * 処理オブジェクトを追加します.
     * <BR>
     * @param exec 管理実行オブジェクトを設定します.
     */
    public void add( ExecutionAdmin exec ) {
        if( exec == null ) {
            return ;
        }
        
        executionTable.add( exec.getId(),exec ) ;
    }
    
    /**
     * スレッド終了処理.
     * <BR><BR>
     * スレッドが終了するときに呼び出されます.
     * <BR>
     * @param session 対象のログインセッションが設定されます.
     * @param tranMan 対象のトランザクションマネージャが設定されます.
     */
    public void exit( LoginSession session,CharTable tranMan ) {
        
        // 現在ログイン中の条件をログアウト.
        try {
            LoginManager.logout( session ) ;
        } catch( Exception e ) {
        }
        
    }
    
    /**
     * クライアント接続実行処理.
     * <BR><BR>
     * クライアント接続実行処理を行います.
     * <BR>
     * @param telegramType 処理対象の実行タイプを格納します.
     * @param connect コネクションオブジェクトが設定されます.
     * @param session 対象のログインセッションが設定されます.
     * @param tranMan 対象のトランザクションマネージャが設定されます.
     * @param id 対象の電文IDが設定されます.
     * @param type 対象の電文処理タイプが設定されます.
     * @param telegram 受信された電文が設定されます.
     * @exception Exception 例外.
     */
    public void execution( int[] telegramType,LoginSession session,
        CharTable tranMan,ConnectObject connect,int id,int type,
        Telegram telegram )
        throws Exception {
        
        // プロトコルタイプにあわせて処理を実行.
        ExecutionAdmin exec = ( ExecutionAdmin )executionTable.get( type ) ;
        
        if( exec != null ) {
            boolean ret = exec.execution(
                telegramType,session,connect,id,telegram ) ;
            if( ret == false ) {
                throw new MaachangQException(
                    "不明な処理タイプを受信",
                    MaachangQErrorCode.ERROR_NOT_EXECUTION_TYPE ) ;
            }
        }
        else {
            throw new MaachangQException(
                "不明なプロトコルタイプを受信",
                MaachangQErrorCode.ERROR_NOT_PROTOCOL_TYPE ) ;
        }
        
    }
    
}

