/*
 * @(#)ProtocolHeartBeat.java
 *
 * Copyright (c) 2006 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.queue.main.channel.protocol ;

import org.maachang.commons.exception.InputException;
import org.maachang.queue.main.channel.Channel;
import org.maachang.queue.main.channel.SendChannel;

/**
 * ハートビートプロトコル.
 * 
 * @version 2006/09/03
 * @author  masahito suzuki
 * @since   MaachangQ 1.00
 */
public class ProtocolHeartBeat implements ProtocolObject {
    
    
    /**
     * ハートビート用キューマネージャ名&キュー名.
     */
    private static final String HEARTBEAT_NAME = "unknown" ;
    
    /**
     * 電文ID.
     */
    private long id = -1L ;
    
    /**
     * チャネル名.
     */
    private String channelName = null ;
    
    /**
     * キューマネージャ名.
     */
    private String queueManager = null ;
    
    /**
     * 受信ポート番号.
     */
    private int port = -1 ;
    
    /**
     * チャネルID.
     */
    private int channelId = -1 ;
    
    /**
     * コンストラクタ.
     */
    public ProtocolHeartBeat() {
        
    }
    
    /**
     * ファイナライズ処理定義.
     * <BR><BR>
     * ファイナライズ処理定義.
     * @exception Exception 例外処理が返されます.
     */
    protected final void finalize() throws Exception
    {
        
        try{
            this.clear() ;
        }catch( Exception t ){
        }
        
    }
    
    /**
     * オブジェクト生成.
     * <BR><BR>
     * 前回のハートビートプロトコルオブジェクトを設定してオブジェクトを生成します.
     * <BR>
     * @param channel 対象のチャネルオブジェクトを設定します.
     * @exceptino InputException 入力例外.
     */
    public void create( Channel channel )
        throws InputException {
        
        this.create( -1,channel,0 ) ;
        
    }
    
    /**
     * オブジェクト生成.
     * <BR><BR>
     * 前回のハートビートプロトコルオブジェクトを設定してオブジェクトを生成します.
     * <BR>
     * @param channel 対象のチャネルオブジェクトを設定します.
     * @param count 現在のハートビート送信カウントを設定します.
     * @exceptino InputException 入力例外.
     */
    public void create( Channel channel,int count )
        throws InputException {
        
        this.create( -1,channel,count ) ;
        
    }
    
    /**
     * オブジェクト生成.
     * <BR><BR>
     * 前回のハートビートプロトコルオブジェクトを設定してオブジェクトを生成します.
     * <BR>
     * @param port 対象のポート番号を設定します.
     * @param channel 対象のチャネルオブジェクトを設定します.
     * @exceptino InputException 入力例外.
     */
    public void create( int port,Channel channel )
        throws InputException {
        
        this.create( port,channel,0 ) ;
        
    }
    
    /**
     * オブジェクト生成.
     * <BR><BR>
     * 前回のハートビートプロトコルオブジェクトを設定してオブジェクトを生成します.
     * <BR>
     * @param port 対象のポート番号を設定します.
     * @param channel 対象のチャネルオブジェクトを設定します.
     * @param count 現在のハートビート送信カウントを設定します.
     * @exceptino InputException 入力例外.
     */
    public void create( int port,Channel channel,int count )
        throws InputException {
        
        if( channel == null || ( channel instanceof SendChannel ) == false ||
            channel.isChannel() == false ) {
            throw new InputException( "引数は不正です" ) ;
        }
        
        this.clear() ;
        
        this.id = ( ( SendChannel )channel ).getSequenceID() ;
        this.channelName = channel.getName() ;
        this.queueManager = ( ( SendChannel )channel ).getQueueManager() ;
        this.port = port ;
        this.channelId = channel.getId() ;
        
    }
    
    /**
     * 情報クリア.
     * <BR><BR>
     * 情報をクリアします.
     */
    public void clear() {
        
        id = -1L ;
        channelName = null ;
        queueManager = null ;
        port = -1 ;
        channelId = -1 ;
        
    }
    
    /**
     * 電文ID情報を取得.
     * <BR><BR>
     * 電文ID情報を取得します.
     * <BR>
     * @return long 電文ID情報が返されます.
     */
    public long getId() {
        return id;
    }
    
    /**
     * 電文ID情報を設定.
     * <BR><BR>
     * 電文ID情報を設定します.
     * <BR>
     * @param id 対象の電文IDを設定します.
     */
    public void setId(long id) {
        this.id = id;
    }
    
    /**
     * 処理名を取得.
     * <BR><BR>
     * 処理名を取得します.
     * <BR>
     * @return String 処理名が返されます.
     */
    public String getName() {
        return HEARTBEAT_NAME ;
    }
    
    /**
     * 処理名を設定.
     * <BR><BR>
     * 処理名を設定します.
     * <BR>
     * @param name キュー名を設定します.
     */
    public void setName(String name) {
    }
    
    /**
     * チャネル名を設定.
     * <BR><BR>
     * チャネル名を設定します.
     * <BR>
     * @param channelName 対象のチャネル名を設定します.
     */
    public void setChannelName( String channelName ) {
        this.channelName = channelName ;
    }
    
    /**
     * チャネル名を取得.
     * <BR><BR>
     * チャネル名を取得します.
     * <BR>
     * @return String チャネル名が返されます.
     */
    public String getChannelName() {
       return this.channelName ;
    }
    
    /**
     * キューマネージャ名を設定.
     * <BR><BR>
     * キューマネージャ名を設定します.
     * <BR>
     * @param queueManagerName キューマネージャ名を設定します.
     */
    public void setQueueManagerName( String queueManagerName ) {
        
        queueManager = queueManagerName ;
        
    }
    
    /**
     * キューマネージャ名を取得.
     * <BR><BR>
     * キューマネージャ名を取得します.
     * <BR>
     * @return String キューマネージャ名が返されます.
     */
    public String getQueueManagerName() {
        return queueManager ;
    }
    
    /**
     * 受信ポート番号を取得.
     * <BR><BR>
     * 受信ポート番号を取得します.
     * <BR>
     * @return int 受信ポート番号が返されます.
     */
    public int getReceivePort() {
        return port ;
    }
    
    /**
     * 受信ポート番号を設定.
     * <BR><BR>
     * 受信ポート番号を設定します.
     * <BR>
     * @param port 受信ポート番号を設定します.
     */
    public void setReceivePort( int port ) {
        this.port = port ;
    }
    
    /**
     * チャネルIDを取得
     * <BR><BR>
     * チャネルIDを取得します.
     * <BR>
     * @return int チャネルIDが返されます.
     */
    public int getChannelId() {
        return channelId ;
    }
    
    /**
     * チャネルIDを設定.
     * <BR><RB>
     * チャネルIDを設定します.
     * <BR>
     * @param channelId 対象のチャネルIDを設定します.
     */
    public void setChannelId( int channelId ) {
        this.channelId = channelId ;
    }
    
    /**
     * プロトコルタイプを取得.
     * <BR><BR>
     * プロトコルタイプを取得します.
     * <BR>
     * @return int プロトコルタイプが返されます.<BR>
     *             [ProtocolObject.PROTOCOL_DATA]が返された場合、データオブジェクトです.<BR>
     *             [ProtocolObject.PROTOCOL_HEARTBEAT]が返された場合、ハートビートオブジェクトです.<BR>
     *             [ProtocolObject.PROTOCOL_SUCCESS]が返された場合、正常オブジェクトです.<BR>
     *             [ProtocolObject.PROTOCOL_ERROR]が返された場合ｍエラーオブジェクトです.
     */
    public int getType() {
        return ProtocolObject.PROTOCOL_HEARTBEAT ;
    }
    
    /**
     * プロトコル戻りタイプを取得.
     * <BR><BR>
     * プロトコル戻りタイプを取得します.
     * <BR>
     * @return int プロトコル戻りタイプが返されます.
     */
    public int getReturnType() {
        return ProtocolObject.PROTOCOL_HEARTBEAT ;
    }
    
    /**
     * オブジェクトを文字列に変換.
     * <BR><BR>
     * オブジェクトを文字列に変換します.
     * <BR>
     * @return String 文字列に変換された情報が返されます.
     */
    public String toString() {
        
        String ret = null ;
        
        ret = new StringBuffer().
            append( "[PROTOCOL_HEARTBEAT]" ).
            append( " id:" ).
            append( id ).
            append( " channelName:" ).
            append( channelName ).
            append( " queueManager:" ).
            append( queueManager ).
            append( " port:" ).
            append( port ).
            append( " channelId:" ).
            append( channelId ).
            toString() ;
            
        return ret ;
    }
    
}

