/*
 * @(#)CoreReceiveTable.java
 *
 * Copyright (c) 2006 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.queue.main.channel.service.receive.core ;

import java.net.InetAddress;

import org.maachang.commons.resource.BinResource;
import org.maachang.commons.util.RollObject;

/**
 * コア受信テーブル.
 *
 * @version 2006/12/21
 * @author  Masahito Suzuki
 * @since   MaachangQ 1.00
 */
public class CoreReceiveTable {
    
    /**
     * ロール格納数.
     */
    private static final int MAX_ROLL = 16384 ;
    
    /**
     * 受信データ管理.
     */
    private RollObject table = null ;
    
    /**
     * コンストラクタ.
     */
    public CoreReceiveTable() {
        table = new RollObject( MAX_ROLL ) ;
    }
    
    /**
     * 情報追加.
     * <BR><BR>
     * 情報を追加します.
     * <BR>
     * @param connectName 受信コネクション名を設定します.
     * @param binResource 対象のバイナリデータを設定します.
     * @param addr 対象のコネクションアドレスを設定します.
     * @param port 対象のコネクションポート番号を設定します.
     * @param cb32Word 対象の暗号ワードを設定します.
     * @return boolean 処理結果が返されます.<BR>
     *                  [true]が返された場合、正しく設定されました.<BR>
     *                  [false]が返された場合、ロール情報に空き領域は存在しません
     */
    public synchronized boolean put(
        String connectName,BinResource bin,InetAddress addr,int port,String cb32Word ) {
        if( connectName == null || bin == null || bin.size() <= 0 ||
            addr == null || port < 0 || port > 65535 ) {
            return true ;
        }
        return table.add(
            new CoreReceiveChild( connectName,bin,addr,port,cb32Word ) ) ;
    }
    
    /**
     * 情報取得.
     * <BR><BR>
     * 情報を取得します.
     * <BR>
     * @return CoreReceiveChild 情報が返されます.<BR>
     *                          [null]が返された場合、情報は存在しません.
     */
    public synchronized CoreReceiveChild get() {
        return ( CoreReceiveChild )table.get() ;
    }
    
    /**
     * 情報長を取得.
     * <BR><BR>
     * 現在格納されている情報長を取得します.
     * <BR>
     * @return int 情報長が返されます.
     */
    public synchronized int size() {
        return table.getSize() ;
    }
    
}

