/*
 * @(#)AdminQueueManagerBean.java
 *
 * Copyright (c) 2006 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.queue.main.manager ;

import java.io.Serializable;

import org.maachang.commons.serialize.SerializeUtil;

/**
 * キューマネージャBean.
 * 
 * @version 2006/09/05
 * @author  masahito suzuki
 * @since   MaachangQ 1.00
 */
public class QueueManagerBean implements Serializable {
    
    static {
        serialVersionUID = SerializeUtil.serialVersionUID(
            QueueManagerBean.class.getName()
        ) ;
    }
    
    /**
     * シリアライズUID.
     */
    private static final long serialVersionUID ;
    
    /**
     * キューマネージャ名.
     */
    private String queueManagerName = null ;
    
    /**
     * キャッシュセクタ数.
     */
    private int cacheSize = -1 ;
    
    /**
     * キュー名一覧.
     */
    private String[] queueNames = null ;
    
    /**
     * コンストラクタ.
     */
    public QueueManagerBean() {
        
    }
    
    /**
     * cacheSizeを取得.
     * <BR><BR>
     * @return cacheSize が返されます。
     */
    public int getCacheSize() {
        return cacheSize;
    }
    
    /**
     * cacheSizeを設定.
     * <BR><BR>
     * @param cacheSize 対象のcacheSizeを設定.
     */
    public void setCacheSize(int cacheSize) {
        this.cacheSize = ( cacheSize <= 0 ) ? -1 : cacheSize ;
    }
    
    /**
     * queueManagerNameを取得.
     * <BR><BR>
     * @return queueManagerName が返されます。
     */
    public String getQueueManagerName() {
        return queueManagerName;
    }
    
    /**
     * queueManagerNameを設定.
     * <BR><BR>
     * @param queueManagerName 対象のqueueManagerNameを設定.
     */
    public void setQueueManagerName(String queueManagerName) {
        if(
            queueManagerName == null ||
            ( queueManagerName = queueManagerName.trim().toLowerCase() ).length() <= 0 ) {
            return ;
        }
        this.queueManagerName = queueManagerName;
    }
    
    /**
     * queueNamesを取得.
     * <BR><BR>
     * @return queueNames が返されます。
     */
    public String[] getQueueNames() {
        return queueNames;
    }
    
    /**
     * queueNamesを設定.
     * <BR><BR>
     * @param queueNames 対象のqueueNamesを設定.
     */
    public void setQueueNames(String[] queueNames) {
        this.queueNames = queueNames;
    }
    
}

