/*
 * @(#)QueueMessage.java
 *
 * Copyright (c) 2006 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.queue.main.queue ;

/**
 * １つのキューメッセージを表すオブジェクト.
 *  
 * @version 2006/09/05
 * @author  masahito suzuki
 * @since   MaachangQ 1.00
 */
public class QueueMessage {
    
    /**
     * メッセージタイプ.
     */
    private boolean type = false ;
    
    /**
     * 圧縮フラグ.
     */
    private boolean gzipFlag = false ;
    
    /**
     * メッセージ長.
     * (圧縮時は、本来のメッセージ長).
     */
    private int length = 0 ;
    
    /**
     * メッセージ情報.
     */
    private Object message = null ;
    
    /**
     * コンストラクタ.
     */
    public QueueMessage() {
        
    }
    
    /**
     * ファイナライズ処理定義.
     * <BR><BR>
     * ファイナライズ処理定義.
     * @exception Exception 例外処理が返されます.
     */
    protected final void finalize() throws Exception
    {
        
        try{
            this.clear() ;
        }catch( Exception t ){
        }
        
    }
    
    /**
     * 情報クリア.
     * <BR><BR>
     * 情報を全てクリア.
     */
    public void clear() {
        
        type = false ;
        gzipFlag = false ;
        length = 0 ;
        message = null ;
        
    }
    
    /**
     * メッセージタイプを取得.
     * <BR><BR>
     * @return boolean [true]の場合はBinResource.
     */
    public boolean isType() {
        return type;
    }
    
    /**
     * メッセージタイプを設定.
     * <BR><BR>
     * @param gzipFlag [true]の場合はBinResource.
     */
    public void setType(boolean type) {
        this.type = type;
    }
    
    /**
     * 圧縮フラグを取得.
     * <BR><BR>
     * @return boolean 圧縮フラグ.
     */
    public boolean isGzipFlag() {
        return gzipFlag;
    }
    
    /**
     * 圧縮フラグを設定.
     * <BR><BR>
     * @param gzipFlag 圧縮フラグ.
     */
    public void setGzipFlag(boolean gzipFlag) {
        this.gzipFlag = gzipFlag;
    }
    
    /**
     * 圧縮時の場合は、本来のデータ長を取得.
     * <BR><BR>
     * @return int データ長.
     */
    public int getLength() {
        return length;
    }
    
    /**
     * 圧縮時の場合は、本来のデータ長を設定.
     * <BR><BR>
     * @param length データ長.
     */
    public void setLength(int length) {
        this.length = length;
    }
    
    /**
     * メッセージ情報を取得.
     * <BR><BR>
     * @return Object メッセージ情報.
     */
    public Object getMessage() {
        return message;
    }
    
    /**
     * メッセージ情報を設定.
     * <BR><BR>
     * @param message メッセージ情報.
     */
    public void setMessage(Object message) {
        this.message = message;
    }
    
}

