/*
 * @(#)SendMq.java
 *
 * Copyright (c) 2006 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.queue.main.queue ;

import org.maachang.commons.exception.InputException;
import org.maachang.queue.access.MaachangQException;
import org.maachang.queue.main.channel.Channel;

/**
 * 送信MQを表すインターフェイス.
 * <BR><BR>
 * 1つの送信MQを表すインターフェイスです.
 *  
 * @version 2006/12/21
 * @author  masahito suzuki
 * @since   MaachangQ 1.00
 */
public interface SendMq extends Mq,SendMqInterface {
    
    /**
     * 送信チャネルを追加.
     * <BR><BR>
     * この送信キューに対して送信チャネルを追加します.
     * <BR>
     * @param name 追加対象のチャネル名を設定します.
     * @exception InputException 入力例外.
     * @exception MaachangQException MaachangQ例外.
     */
    public void addChannel( String name )
        throws InputException,MaachangQException ;
    
    /**
     * 送信チャネルを削除.
     * <BR><BR>
     * この送信キューに設定されている送信チャネルを削除します.
     * <BR>
     * @param name 削除対象のチャネル名を設定します.
     * @exception InputException 入力例外.
     */
    public void removeChannel( String name )
        throws InputException ;
    
    /**
     * チャネル名を取得.
     * <BR><BR>
     * この送信キューに設定されている送信チャネル名を取得します.
     * <BR>
     * @param no 取得対象の項番を設定します.
     * @return String 対象のチャネル名が返されます.
     */
    public String getChannelName( int no ) ;
    
    /**
     * チャネルIDを取得.
     * <BR><BR>
     * この送信キューに設定されている送信チャネルIDを取得します.
     * <BR>
     * @param no 取得対象の項番を設定します.
     * @return int 対象のチャネルIDが返されます.
     */
    public int getChannelID( int no ) ;
    
    /**
     * チャネルオブジェクトを取得.
     * <BR><BR>
     * この送信キューに設定されている送信チャネルを取得します.
     * <BR>
     * @param no 取得対象の項番を設定します.
     * @return Channel 対象のチャネルオブジェクトが返されます.
     */
    public Channel getChannel( int no ) ;
    
    /**
     * チャネル名一覧を取得.
     * <BR><BR>
     * この送信キューに設定されている送信チャネル名一覧が返されます.
     * <BR>
     * @return String[] 送信チャネル名一覧が返されます.
     */
    public String[] getChannelNames() ;
    
    /**
     * チャネルID一覧を取得.
     * <BR><BR>
     * この送信キューに設定されている送信チャネルID一覧が返されます.
     * <BR>
     * @return int[] 送信チャネルID一覧が返されます.
     */
    public int[] getChannelDs() ;
    
    /**
     * 設定チャネル数を取得.
     * <BR><BR>
     * 設定されているチャネル数を取得します.
     * <BR>
     * @return int 設定されているチャネル数が返されます.
     */
    public int getChannelSize() ;
    
}

