/*
 * @(#)BaseQueueBean.java
 *
 * Copyright (c) 2006 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.queue.main.queue.base ;

import java.io.Serializable;

import org.maachang.commons.serialize.SerializeUtil;
import org.maachang.queue.main.queue.QueueBean;

/**
 * 基本QueueBean情報.
 *  
 * @version 2006/09/04
 * @author  masahito suzuki
 * @since   MaachangQ 1.00
 */
public class BaseQueueBean extends QueueBean {
    
    static {
        serialVersionUID = SerializeUtil.serialVersionUID(
            BaseQueueBean.class.getName()
        ) ;
    }
    
    /**
     * シリアライズUID.
     */
    private static final long serialVersionUID ;
    
    /**
     * コンストラクタ.
     */
    public BaseQueueBean() {
        
    }
    
    /**
     * autoCommitを取得.
     * <BR><BR>
     * @return autoCommit が返されます。
     */
    public boolean isAutoCommit() {
        return this.autoCommit;
    }
    
    /**
     * autoCommitを設定.
     * <BR><BR>
     * @param autoCommit 対象のautoCommitを設定.
     */
    public void setAutoCommit(boolean autoCommit) {
        this.autoCommit = autoCommit;
    }
    
    /**
     * gzipを取得.
     * <BR><BR>
     * @return gzip が返されます。
     */
    public boolean isGzip() {
        return this.gzip;
    }
    
    /**
     * gzipを設定.
     * <BR><BR>
     * @param gzip 対象のgzipを設定.
     */
    public void setGzip(boolean gzip) {
        this.gzip = gzip;
    }
    
    /**
     * maxMessageLengthを取得.
     * <BR><BR>
     * @return maxMessageLength が返されます。
     */
    public int getMaxMessageLength() {
        return this.maxMessageLength;
    }
    
    /**
     * maxMessageLengthを設定.
     * <BR><BR>
     * @param maxMessageLength 対象のmaxMessageLengthを設定.
     */
    public void setMaxMessageLength(int maxMessageLength) {
        this.maxMessageLength = maxMessageLength;
    }
    
    /**
     * maxQueueを取得.
     * <BR><BR>
     * @return maxQueue が返されます。
     */
    public int getMaxQueue() {
        return this.maxQueue;
    }
    
    /**
     * maxQueueを設定.
     * <BR><BR>
     * @param maxQueue 対象のmaxQueueを設定.
     */
    public void setMaxQueue(int maxQueue) {
        this.maxQueue = maxQueue;
    }
    
    /**
     * optionを取得.
     * <BR><BR>
     * @return option が返されます。
     */
    public Serializable getOption() {
        return this.option;
    }
    
    /**
     * optionを設定.
     * <BR><BR>
     * @param option 対象のoptionを設定.
     */
    public void setOption(Serializable option) {
        this.option = option;
    }
    
    /**
     * queueManagerNameを取得.
     * <BR><BR>
     * @return queueManagerName が返されます。
     */
    public String getQueueManagerName() {
        return this.queueManagerName;
    }
    
    /**
     * queueManagerNameを設定.
     * <BR><BR>
     * @param queueManagerName 対象のqueueManagerNameを設定.
     */
    public void setQueueManagerName(String queueManagerName) {
        if(
            queueManagerName == null || 
            ( queueManagerName = queueManagerName.trim().toLowerCase() ).length() <= 0
        ) {
            return ;
        }
        this.queueManagerName = queueManagerName;
    }
    
    /**
     * queueNameを取得.
     * <BR><BR>
     * @return queueName が返されます。
     */
    public String getQueueName() {
        return this.queueName;
    }
    
    /**
     * queueNameを設定.
     * <BR><BR>
     * @param queueName 対象のqueueNameを設定.
     */
    public void setQueueName(String queueName) {
        if(
            queueName == null || 
            ( queueName = queueName.trim().toLowerCase() ).length() <= 0
        ) {
            return ;
        }
        this.queueName = queueName;
    }
    
    /**
     * typeを取得.
     * <BR><BR>
     * @return type が返されます。
     */
    public int getType() {
        return this.type;
    }
    
    /**
     * typeを設定.
     * <BR><BR>
     * @param type 対象のtypeを設定.
     */
    public void setType(int type) {
        this.type = type;
    }
    
    /**
     * warningを取得.
     * <BR><BR>
     * @return warning が返されます。
     */
    public double getWarning() {
        return this.warning;
    }
    
    /**
     * warningを設定.
     * <BR><BR>
     * @param warning 対象のwarningを設定.
     */
    public void setWarning(double warning) {
        this.warning = warning;
    }
    
    /**
     * cacheNameを設定.
     * <BR><BR>
     * @param cacheName 対象のcacheNameを設定.
     */
    public void setCacheName(String cacheName) {
        if(
            cacheName == null || 
            ( cacheName = cacheName.trim().toLowerCase() ).length() <= 0
        ) {
            return ;
        }
        this.cacheName = cacheName;
    }
    
}

